/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.overview;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.libra.framework.editor.core.model.IBundle;
import org.eclipse.libra.framework.editor.core.model.IPackageExport;
import org.eclipse.libra.framework.editor.core.model.IPackageImport;
import org.eclipse.libra.framework.editor.core.model.IServiceReference;
import org.eclipse.libra.framework.editor.ui.internal.EditorUIPlugin;
import org.eclipse.libra.framework.editor.ui.internal.overview.BundleInformationMasterDetailsBlock;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.JarEntryEditorInput;
import org.eclipse.pde.internal.ui.editor.JarEntryFile;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.forms.AbstractFormPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.ide.FileStoreEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleInformationDetailsPart
extends AbstractFormPart
implements IDetailsPage {
    private IBundle bundle;
    private Map<Long, IBundle> bundles;
    private Text bundleSymbolicNameText;
    private FilteredTree exportsTable;
    private TreeViewer exportsTableViewer;
    private Text idText;
    private FilteredTree importsTable;
    private TreeViewer importsTableViewer;
    private Text locationText;
    private Text manifestText;
    private final BundleInformationMasterDetailsBlock masterDetailsBlock;
    private Text providerText;
    private Table servicePropertiesTable;
    private TableViewer servicePropertiesTableViewer;
    private FilteredTree servicesTable;
    private TreeViewer servicesTableViewer;
    private Text stateText;
    private Text versionText;

    public BundleInformationDetailsPart(BundleInformationMasterDetailsBlock bundleInformationMasterDetailsBlock) {
        this.masterDetailsBlock = bundleInformationMasterDetailsBlock;
    }

    public void createContents(Composite parent) {
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        GridLayout layout = new GridLayout();
        layout.marginTop = -5;
        layout.marginLeft = 6;
        parent.setLayout((Layout)layout);
        GridData data = new GridData(770);
        Section detailsSection = toolkit.createSection(parent, 458);
        detailsSection.setText("Bundle Details");
        detailsSection.setDescription("Details about the selected bundle.");
        detailsSection.setLayoutData((Object)data);
        this.createSectionToolbar(detailsSection, toolkit, new Action("Show dependency graph for bundle", PDEPluginImages.DESC_COMGROUP_OBJ){

            public void run() {
                BundleInformationDetailsPart.this.masterDetailsBlock.openDependencyPage(BundleInformationDetailsPart.this.bundle.getSymbolicName(), BundleInformationDetailsPart.this.bundle.getVersion());
            }
        });
        Composite detailsComposite = toolkit.createComposite((Composite)detailsSection);
        layout = new GridLayout();
        layout.numColumns = 4;
        detailsComposite.setLayout((Layout)layout);
        data = new GridData(1808);
        data.minimumHeight = 100;
        data.heightHint = 100;
        detailsComposite.setLayoutData((Object)data);
        toolkit.paintBordersFor(detailsComposite);
        detailsSection.setClient((Control)detailsComposite);
        Label idLabel = toolkit.createLabel(detailsComposite, "Id:");
        idLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.idText = toolkit.createText(detailsComposite, "");
        this.idText.setEditable(false);
        this.idText.setLayoutData((Object)new GridData(770));
        Label stateLabel = toolkit.createLabel(detailsComposite, "State:");
        stateLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.stateText = toolkit.createText(detailsComposite, "", 0);
        this.stateText.setEditable(false);
        this.stateText.setLayoutData((Object)new GridData(770));
        Label bundleSymbolicNameLabel = toolkit.createLabel(detailsComposite, "Symbolic-Name:");
        bundleSymbolicNameLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.bundleSymbolicNameText = toolkit.createText(detailsComposite, "", 0);
        this.bundleSymbolicNameText.setEditable(false);
        this.bundleSymbolicNameText.setLayoutData((Object)new GridData(770));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.bundleSymbolicNameText);
        Label versionLabel = toolkit.createLabel(detailsComposite, "Version:");
        versionLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.versionText = toolkit.createText(detailsComposite, "");
        this.versionText.setEditable(false);
        this.versionText.setLayoutData((Object)new GridData(770));
        Label providerLabel = toolkit.createLabel(detailsComposite, "Provider:");
        providerLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.providerText = toolkit.createText(detailsComposite, "", 0);
        this.providerText.setEditable(false);
        this.providerText.setLayoutData((Object)new GridData(770));
        Label locationLabel = toolkit.createLabel(detailsComposite, "Location:");
        locationLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.locationText = toolkit.createText(detailsComposite, "", 0);
        this.locationText.setEditable(false);
        this.locationText.setLayoutData((Object)new GridData(770));
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.locationText);
        Link openDependenciesText = new Link(detailsComposite, 0);
        openDependenciesText.setText("<a href=\"open\">Show dependency graph for bundle</a>");
        openDependenciesText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleInformationDetailsPart.this.masterDetailsBlock.openDependencyPage(BundleInformationDetailsPart.this.bundle.getSymbolicName(), BundleInformationDetailsPart.this.bundle.getVersion());
            }
        });
        GridDataFactory.fillDefaults().grab(true, false).span(4, 1).applyTo((Control)openDependenciesText);
        Section manifestSection = toolkit.createSection(parent, 394);
        manifestSection.setText("Manifest");
        manifestSection.setDescription("Displays the bundle manifest.");
        manifestSection.setLayoutData((Object)new GridData(770));
        Composite manifestComposite = toolkit.createComposite((Composite)manifestSection);
        layout = new GridLayout();
        layout.numColumns = 1;
        manifestComposite.setLayout((Layout)layout);
        manifestComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(manifestComposite);
        manifestSection.setClient((Control)manifestComposite);
        this.createSectionToolbar(manifestSection, toolkit, new Action("Open MANIFEST.MF in editor", PDEPluginImages.DESC_TOC_LEAFTOPIC_OBJ){

            public void run() {
                BundleInformationDetailsPart.this.openBundleEditor(BundleInformationDetailsPart.this.bundle);
            }
        });
        this.manifestText = toolkit.createText(manifestComposite, "", 66);
        this.manifestText.setEditable(false);
        this.manifestText.setFont(JFaceResources.getTextFont());
        GC gc = new GC((Drawable)this.manifestText);
        FontMetrics fm = gc.getFontMetrics();
        int height = 10 * fm.getHeight();
        gc.dispose();
        data = new GridData(768);
        data.heightHint = this.manifestText.computeSize((int)-1, (int)height).y;
        this.manifestText.setLayoutData((Object)data);
        Link openManifestText = new Link(manifestComposite, 0);
        openManifestText.setText("<a href=\"open\">Open MANIFEST.MF in editor</a>");
        openManifestText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BundleInformationDetailsPart.this.openBundleEditor(BundleInformationDetailsPart.this.bundle);
            }
        });
        Section importsSection = toolkit.createSection(parent, 458);
        importsSection.setText("Package Imports");
        importsSection.setLayoutData((Object)new GridData(770));
        importsSection.setDescription("Information about visible packages and consumers of those packages.");
        Composite importsComposite = toolkit.createComposite((Composite)importsSection);
        layout = new GridLayout();
        layout.numColumns = 1;
        importsComposite.setLayout((Layout)layout);
        importsComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(importsComposite);
        importsSection.setClient((Control)importsComposite);
        ImageDescriptor collapseAllImageDescriptor = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ELCL_COLLAPSEALL");
        this.createSectionToolbar(importsSection, toolkit, new Action("Collapse All", collapseAllImageDescriptor){

            public void run() {
                BundleInformationDetailsPart.this.importsTableViewer.collapseAll();
            }
        });
        this.importsTable = new FilteredTree(importsComposite, 68096, new PatternFilter());
        data = new GridData(768);
        data.heightHint = 200;
        this.importsTable.getViewer().getControl().setLayoutData((Object)data);
        this.importsTableViewer = this.importsTable.getViewer();
        this.importsTableViewer.setContentProvider((IContentProvider)new PackageImportContentProvider());
        this.importsTableViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.importsTableViewer.setAutoExpandLevel(2);
        Section exportsSection = toolkit.createSection(parent, 394);
        exportsSection.setText("Package Exports");
        exportsSection.setLayoutData((Object)new GridData(770));
        exportsSection.setDescription("Information about exported packages and bundles that use these packages.");
        Composite exportsComposite = toolkit.createComposite((Composite)exportsSection);
        layout = new GridLayout();
        layout.numColumns = 1;
        exportsComposite.setLayout((Layout)layout);
        exportsComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(exportsComposite);
        exportsSection.setClient((Control)exportsComposite);
        this.createSectionToolbar(exportsSection, toolkit, new Action("Collapse All", collapseAllImageDescriptor){

            public void run() {
                BundleInformationDetailsPart.this.exportsTableViewer.collapseAll();
            }
        });
        this.exportsTable = new FilteredTree(exportsComposite, 68096, new PatternFilter());
        data = new GridData(768);
        data.heightHint = 200;
        this.exportsTable.getViewer().getControl().setLayoutData((Object)data);
        this.exportsTableViewer = this.exportsTable.getViewer();
        this.exportsTableViewer.setContentProvider((IContentProvider)new PackageExportContentProvider());
        this.exportsTableViewer.setLabelProvider((IBaseLabelProvider)new PackageLabelProvider());
        this.exportsTableViewer.setAutoExpandLevel(2);
        Section servicesSection = toolkit.createSection(parent, 394);
        servicesSection.setText("Services");
        servicesSection.setDescription("Details about registered and in-use services.");
        servicesSection.setLayoutData((Object)new GridData(770));
        Composite servicesComposite = toolkit.createComposite((Composite)servicesSection);
        layout = new GridLayout();
        layout.numColumns = 1;
        servicesComposite.setLayout((Layout)layout);
        servicesComposite.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(servicesComposite);
        servicesSection.setClient((Control)servicesComposite);
        this.createSectionToolbar(servicesSection, toolkit, new Action("Collapse All", collapseAllImageDescriptor){

            public void run() {
                BundleInformationDetailsPart.this.servicesTableViewer.collapseAll();
            }
        });
        this.servicesTable = new FilteredTree(servicesComposite, 68096, new PatternFilter());
        data = new GridData(768);
        data.heightHint = 200;
        this.servicesTable.getViewer().getControl().setLayoutData((Object)data);
        this.servicesTableViewer = this.servicesTable.getViewer();
        this.servicesTableViewer.setContentProvider((IContentProvider)new ServicesContentProvider());
        this.servicesTableViewer.setLabelProvider((IBaseLabelProvider)new ServicesLabelProvider());
        this.servicesTableViewer.setAutoExpandLevel(2);
        this.servicesTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                BundleInformationDetailsPart.this.servicePropertiesTableViewer.setInput(((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Label servicePropertiesLabel = toolkit.createLabel(servicesComposite, "Service Properties:");
        servicePropertiesLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        this.servicePropertiesTable = toolkit.createTable(servicesComposite, 66308);
        data = new GridData(768);
        data.heightHint = 100;
        this.servicePropertiesTable.setLayoutData((Object)data);
        this.servicePropertiesTable.setLinesVisible(true);
        TableColumn keyColumn = new TableColumn(this.servicePropertiesTable, 16384);
        keyColumn.setText("Key");
        keyColumn.setWidth(150);
        TableColumn valueColumn = new TableColumn(this.servicePropertiesTable, 16384);
        valueColumn.setText("Value");
        valueColumn.setWidth(450);
        this.servicePropertiesTable.setHeaderVisible(true);
        this.servicePropertiesTableViewer = new TableViewer(this.servicePropertiesTable);
        this.servicePropertiesTableViewer.setContentProvider((IContentProvider)new ServicePropertyContentProvider());
        this.servicePropertiesTableViewer.setLabelProvider((IBaseLabelProvider)new ServicePropertyLabelProvider());
        this.servicePropertiesTableViewer.setComparator((ViewerComparator)new ServicePropertyComparator());
    }

    public void refresh(Map<Long, IBundle> bundles) {
        this.bundles = bundles;
    }

    public void selectionChanged(IFormPart part, ISelection selection) {
        this.bundle = (IBundle)((IStructuredSelection)selection).getFirstElement();
        this.idText.setText(this.bundle.getId());
        this.stateText.setText(this.bundle.getState());
        this.bundleSymbolicNameText.setText(this.bundle.getSymbolicName());
        this.versionText.setText(this.bundle.getVersion());
        String vendor = (String)this.bundle.getHeaders().get("Bundle-Vendor");
        this.providerText.setText(vendor == null ? "" : vendor);
        this.locationText.setText(this.bundle.getLocation());
        this.importsTableViewer.setInput((Object)this.bundle);
        this.importsTableViewer.setAutoExpandLevel(2);
        this.exportsTableViewer.setInput((Object)this.bundle);
        this.exportsTableViewer.setAutoExpandLevel(2);
        StringBuilder builder = new StringBuilder();
        for (Map.Entry header : this.bundle.getHeaders().entrySet()) {
            builder.append((String)header.getKey()).append(": ").append((String)header.getValue()).append(Text.DELIMITER);
        }
        this.manifestText.setText(builder.toString());
        this.servicesTableViewer.setInput((Object)this.bundle);
        this.servicesTableViewer.setAutoExpandLevel(2);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit, Action ... actions) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        final Cursor handCursor = new Cursor((Device)Display.getCurrent(), 21);
        toolbar.setCursor(handCursor);
        toolbar.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (handCursor != null && !handCursor.isDisposed()) {
                    handCursor.dispose();
                }
            }
        });
        Action[] actionArray = actions;
        int n = actions.length;
        int n2 = 0;
        while (n2 < n) {
            Action action = actionArray[n2];
            toolBarManager.add((IAction)action);
            ++n2;
        }
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    private void openBundleEditor(IBundle bundle) {
        try {
            String fileName = "META-INF/MANIFEST.MF";
            IEditorInput input = this.getEditorInput(this.getBundleRoot(bundle), fileName);
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileName, this.getContentType());
            IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            page.openEditor(input, desc.getId());
        }
        catch (Exception e) {
            EditorUIPlugin.log(e);
        }
    }

    private File getBundleRoot(IBundle bundle) throws URISyntaxException {
        File bundleRoot;
        String location = bundle.getLocation();
        if (location.startsWith("reference:")) {
            location = location.substring("reference:".length());
        }
        if (location.startsWith("file:/")) {
            bundleRoot = new File(new URI(location));
        } else if (location.startsWith("file:")) {
            location = location.substring("file:".length());
            bundleRoot = new File(location);
        } else {
            bundleRoot = new File(new URI(location));
        }
        return bundleRoot;
    }

    private IEditorInput getEditorInput(File bundleRoot, String filename) {
        JarEntryEditorInput input = null;
        if (bundleRoot.isFile()) {
            try {
                ZipFile zipFile = new ZipFile(bundleRoot);
                if (zipFile.getEntry(filename) != null) {
                    input = new JarEntryEditorInput((IStorage)new JarEntryFile(zipFile, filename));
                }
            }
            catch (IOException iOException) {}
        } else {
            File file = new File(bundleRoot, filename);
            if (file.exists()) {
                try {
                    IFileStore store = EFS.getStore((URI)file.toURI());
                    input = new FileStoreEditorInput(store);
                }
                catch (CoreException coreException) {}
            }
        }
        return input;
    }

    private IContentType getContentType() {
        IContentType type = Platform.getContentTypeManager().findContentTypeFor("META-INF/MANIFEST.MF");
        if (type == null) {
            type = Platform.getContentTypeManager().getContentType("org.eclipse.pde.bundleManifest");
        }
        if (type == null) {
            type = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        }
        return type;
    }

    class PackageExportContentProvider
    implements ITreeContentProvider {
        private IBundle bundle;

        PackageExportContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IPackageExport) {
                HashSet<IBundle> bundles = new HashSet<IBundle>();
                String name = ((IPackageExport)parentElement).getName();
                String version = ((IPackageExport)parentElement).getVersion();
                String id = this.bundle.getId();
                for (IBundle bundle : BundleInformationDetailsPart.this.bundles.values()) {
                    for (IPackageImport pi : bundle.getPackageImports()) {
                        if (!pi.getSupplierId().equals(id) || !pi.getName().equals(name) || !pi.getVersion().equals(version)) continue;
                        bundles.add(bundle);
                    }
                }
                return bundles.toArray(new IBundle[bundles.size()]);
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (this.bundle.getPackageExports().size() > 0) {
                return this.bundle.getPackageExports().toArray();
            }
            return new Object[]{"<no exported packages>"};
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.bundle = (IBundle)newInput;
        }
    }

    class PackageImportContentProvider
    implements ITreeContentProvider {
        private IBundle bundle;

        PackageImportContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IPackageImport) {
                String supplierId = ((IPackageImport)parentElement).getSupplierId();
                IBundle value = (IBundle)BundleInformationDetailsPart.this.bundles.get(Long.valueOf(supplierId));
                if (value != null) {
                    return new Object[]{value};
                }
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            if (this.bundle.getPackageImports().size() > 0) {
                return this.bundle.getPackageImports().toArray();
            }
            return new Object[]{"<no imported packages>"};
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.bundle = (IBundle)newInput;
        }
    }

    class PackageLabelProvider
    extends LabelProvider {
        PackageLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IPackageImport) {
                return PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_PACKAGE);
            }
            if (element instanceof IPackageExport) {
                return PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_PACKAGE);
            }
            if (element instanceof IBundle) {
                return PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_BUNDLE);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IPackageImport) {
                return String.valueOf(((IPackageImport)element).getName()) + " (" + ((IPackageImport)element).getVersion() + ")";
            }
            if (element instanceof IPackageExport) {
                return String.valueOf(((IPackageExport)element).getName()) + " (" + ((IPackageExport)element).getVersion() + ")";
            }
            if (element instanceof IBundle) {
                return String.valueOf(((IBundle)element).getSymbolicName()) + " (" + ((IBundle)element).getVersion() + ")";
            }
            return super.getText(element);
        }
    }

    class ServicePropertyComparator
    extends ViewerComparator {
        ServicePropertyComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Map.Entry p1 = (Map.Entry)e1;
            Map.Entry p2 = (Map.Entry)e2;
            return ((String)p1.getKey()).compareTo((String)p2.getKey());
        }
    }

    class ServicePropertyContentProvider
    implements IStructuredContentProvider {
        private IServiceReference ref;

        ServicePropertyContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.ref != null) {
                return this.ref.getProperties().entrySet().toArray();
            }
            return new Object[0];
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.ref = newInput instanceof IServiceReference ? (IServiceReference)newInput : null;
        }
    }

    class ServicePropertyLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ServicePropertyLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Map.Entry entry = (Map.Entry)element;
            if (columnIndex == 0) {
                return (String)entry.getKey();
            }
            if (columnIndex == 1) {
                return (String)entry.getValue();
            }
            return null;
        }
    }

    class ServicesContentProvider
    implements ITreeContentProvider {
        private IBundle bundle;

        ServicesContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ServicesHolder) {
                return ((ServicesHolder)parentElement).getRefs().toArray();
            }
            if (parentElement instanceof IServiceReference) {
                HashSet<IBundle> bs = new HashSet<IBundle>();
                IServiceReference ref = (IServiceReference)parentElement;
                if (ref.getType() == IServiceReference.Type.IN_USE) {
                    bs.add((IBundle)BundleInformationDetailsPart.this.bundles.get(ref.getBundleId()));
                } else if (ref.getType() == IServiceReference.Type.REGISTERED) {
                    for (Long id : ref.getUsingBundleIds()) {
                        bs.add((IBundle)BundleInformationDetailsPart.this.bundles.get(id));
                    }
                }
                return bs.toArray();
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            HashSet<ServicesHolder> serviceHolder = new HashSet<ServicesHolder>();
            if (this.bundle.getRegisteredServices().size() > 0) {
                serviceHolder.add(new ServicesHolder(this.bundle.getRegisteredServices(), "Registered Services"));
            }
            if (this.bundle.getServicesInUse().size() > 0) {
                serviceHolder.add(new ServicesHolder(this.bundle.getServicesInUse(), "Services in Use"));
            }
            if (serviceHolder.size() > 0) {
                return serviceHolder.toArray();
            }
            return new Object[]{"<no registered or used services>"};
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.bundle = (IBundle)newInput;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class ServicesHolder {
            private final String label;
            private final Set<IServiceReference> refs;

            public ServicesHolder(Set<IServiceReference> refs, String label) {
                this.refs = refs;
                this.label = label;
            }

            public String getLabel() {
                return this.label;
            }

            public Set<IServiceReference> getRefs() {
                return this.refs;
            }
        }
    }

    class ServicesLabelProvider
    extends LabelProvider {
        ServicesLabelProvider() {
        }

        public Image getImage(Object element) {
            if (element instanceof IServiceReference) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXTENSIONS_OBJ);
            }
            if (element instanceof ServicesContentProvider.ServicesHolder) {
                return PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_EXTENSIONS_OBJ);
            }
            if (element instanceof IBundle) {
                return PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_BUNDLE);
            }
            return super.getImage(element);
        }

        public String getText(Object element) {
            if (element instanceof IServiceReference) {
                String id = (String)((IServiceReference)element).getProperties().get("service.id");
                if (id.length() > 0) {
                    return String.valueOf(((IServiceReference)element).getClazzes()[0]) + " (" + id + ")";
                }
                return ((IServiceReference)element).getClazzes()[0];
            }
            if (element instanceof IBundle) {
                return String.valueOf(((IBundle)element).getSymbolicName()) + " (" + ((IBundle)element).getVersion() + ")";
            }
            if (element instanceof ServicesContentProvider.ServicesHolder) {
                return ((ServicesContentProvider.ServicesHolder)element).getLabel();
            }
            return super.getText(element);
        }
    }
}

