/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views;

import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class TableNavigator
extends TableCursor {
    public static final String copyright = "(c) Copyright IBM Corporation 2000, 2002.";
    private static final String TABLETREEITEM_ID = "TableTreeItemID";
    final Table table;
    protected SelectionKeyAdapter keyAdapter = null;

    public TableNavigator(Table table, StructuredViewer viewer) {
        super(table, 0);
        this.table = table;
        final Table currentTable = table;
        final StructuredViewer sViewer = viewer;
        this.setVisible(false);
        this.addPaintListener(viewer);
        this.addKeyListeners(viewer);
        this.addMouseListeners(viewer);
        this.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                currentTable.setSelection(new TableItem[]{TableNavigator.this.getRow()});
                if (sViewer instanceof TableViewer) {
                    TableTreeItem tableTreeItem = (TableTreeItem)TableNavigator.this.getRow().getData(TableNavigator.TABLETREEITEM_ID);
                    StructuredSelection selection = new StructuredSelection(tableTreeItem.getData());
                    sViewer.setSelection((ISelection)selection, true);
                }
            }
        });
        this.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                Object eventSource = e.getSource();
                if (eventSource instanceof Control) {
                    if (!this.isChild((Control)currentTable, (Control)eventSource)) {
                        if (currentTable.getItemCount() > 0 && currentTable.getSelectionCount() <= 0) {
                            if (sViewer instanceof TableViewer) {
                                TableTreeItem tableTreeItem = (TableTreeItem)TableNavigator.this.getRow().getData(TableNavigator.TABLETREEITEM_ID);
                                StructuredSelection selection = new StructuredSelection(tableTreeItem.getData());
                                sViewer.setSelection((ISelection)selection, true);
                            } else {
                                currentTable.setSelection(0);
                                TableNavigator.this.setSelection(0, 0);
                            }
                            TableNavigator.this.notifyListeners(13, new Event());
                        }
                    } else if (currentTable.getItems().length > 0) {
                        try {
                            TableNavigator.this.setVisible(true);
                        }
                        catch (Exception exception) {
                            currentTable.setSelection(0);
                            TableNavigator.this.setSelection(0, 0);
                        }
                    } else {
                        TableNavigator.this.setVisible(false);
                    }
                }
            }

            protected boolean isChild(Control parent, Control child) {
                Control tempChild = child;
                while (tempChild != null) {
                    if (tempChild == parent) {
                        return true;
                    }
                    tempChild = tempChild.getParent();
                }
                return false;
            }

            public void focusLost(FocusEvent e) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!(currentTable == null || currentTable.isDisposed() || currentTable.isFocusControl() || this.isChild((Control)currentTable, Display.getDefault().getFocusControl()))) {
                            TableNavigator.this.setVisible(false);
                        }
                    }
                });
            }
        });
        table.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (currentTable.getItemCount() > 0 && Display.getDefault().getFocusControl() != null && !Display.getDefault().getFocusControl().equals((Object)TableNavigator.this)) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!TableNavigator.this.isVisible()) {
                                if (TableNavigator.this.getRow() == null && currentTable.getItemCount() > 0) {
                                    currentTable.setSelection(0);
                                    TableNavigator.this.setSelection(0, 0);
                                    TableNavigator.this.notifyListeners(13, new Event());
                                }
                                try {
                                    TableNavigator.this.setVisible(true);
                                    TableNavigator.this.setFocus();
                                }
                                catch (Exception exception) {
                                    if (currentTable.getItemCount() > 0) {
                                        currentTable.setSelection(0);
                                        TableNavigator.this.setSelection(0, 0);
                                    }
                                    TableNavigator.this.setVisible(false);
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    public Table getTable() {
        return this.table;
    }

    public void addPaintListener(StructuredViewer viewer) {
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                TableItem[] selection = TableNavigator.this.table.getSelection();
                final TableItem row = selection.length == 0 ? TableNavigator.this.table.getItem(TableNavigator.this.table.getTopIndex()) : selection[0];
                final String cellText = row.getText(TableNavigator.this.getColumn());
                final Image cellImage = row.getImage(TableNavigator.this.getColumn());
                final int col = TableNavigator.this.getColumn();
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!row.isDisposed()) {
                            String newText = row.getText(TableNavigator.this.getColumn());
                            TableNavigator.this.getRow();
                            if (!newText.equals(cellText) || row.getImage(col) != cellImage) {
                                TableNavigator.this.redraw();
                            }
                        }
                    }
                });
            }
        });
    }

    public SelectionKeyAdapter getKeyAdapter(StructuredViewer viewer) {
        if (this.keyAdapter == null) {
            return new SelectionKeyAdapter(viewer);
        }
        return this.keyAdapter;
    }

    public void setKeyAdapter(SelectionKeyAdapter kAdapter) {
        this.keyAdapter = kAdapter;
    }

    public void addKeyListeners(StructuredViewer viewer) {
        StructuredViewer structuredViewer = viewer;
        this.addKeyListener((KeyListener)this.getKeyAdapter(structuredViewer));
    }

    public void addMouseListeners(StructuredViewer viewer) {
        final StructuredViewer structuredViewer = viewer;
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                TableItem row = TableNavigator.this.getRow();
                int column = TableNavigator.this.getColumn();
                if (e.button == 1) {
                    TableTreeItem tableTreeItem;
                    if (structuredViewer instanceof TableViewer) {
                        ((TableViewer)structuredViewer).editElement(row.getData(), column);
                    } else if (structuredViewer instanceof TableViewer && column == 1) {
                        tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                        ((TableViewer)structuredViewer).editElement(tableTreeItem.getData(), column);
                    }
                    if (structuredViewer instanceof TableViewer && row.getData(TableNavigator.TABLETREEITEM_ID) instanceof TableTreeItem && column == 0) {
                        tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                        boolean expandState = tableTreeItem.getExpanded();
                        ((AbstractTreeViewer)structuredViewer).setExpandedState(tableTreeItem.getData(), !expandState);
                        TableNavigator.this.refresh();
                    }
                }
            }
        });
    }

    public void moveCellEditorsAbove(CellEditor[] editorArray) {
        int i = 0;
        while (i < editorArray.length) {
            CellEditor cEd = editorArray[i];
            if (cEd != null && cEd.getControl() != null) {
                cEd.getControl().moveAbove(null);
            }
            ++i;
        }
    }

    public void refresh() {
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!TableNavigator.this.isDisposed() && TableNavigator.this.isVisible()) {
                    TableNavigator.this.redraw();
                }
            }
        });
    }

    public class SelectionKeyAdapter
    extends KeyAdapter {
        StructuredViewer structuredViewer;
        int lastKeyPressed = -1;

        public SelectionKeyAdapter(StructuredViewer viewer) {
            this.structuredViewer = viewer;
        }

        public void keyPressed(KeyEvent e) {
            TableTreeItem tableTreeItem;
            TableItem row = TableNavigator.this.getRow();
            int column = TableNavigator.this.getColumn();
            if (this.lastKeyPressed == 131072 && e.keyCode == 0x1000013) {
                Menu popup = TableNavigator.this.getTable().getMenu();
                popup.setVisible(true);
            }
            this.lastKeyPressed = e.keyCode;
            if (row.getData(TableNavigator.TABLETREEITEM_ID) instanceof TableTreeItem) {
                if (column == 0 && e.character == '+') {
                    tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                    ((AbstractTreeViewer)this.structuredViewer).setExpandedState(tableTreeItem.getData(), true);
                    TableNavigator.this.refresh();
                } else if (column == 0 && e.character == '-') {
                    tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                    ((AbstractTreeViewer)this.structuredViewer).setExpandedState(tableTreeItem.getData(), false);
                    TableNavigator.this.refresh();
                }
            }
            if (e.keyCode == 0x100000B) {
                if (this.structuredViewer instanceof TableViewer) {
                    ((TableViewer)this.structuredViewer).editElement(row.getData(), column);
                } else if (this.structuredViewer instanceof TableViewer) {
                    tableTreeItem = (TableTreeItem)row.getData(TableNavigator.TABLETREEITEM_ID);
                    ((TableViewer)this.structuredViewer).editElement(tableTreeItem.getData(), column);
                }
            }
        }
    }
}

