/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.client;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.http.HttpConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.HttpClientUtils;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.eclipse.rdf4j.http.client.HttpClientDependent;
import org.eclipse.rdf4j.http.client.HttpClientSessionManager;
import org.eclipse.rdf4j.http.client.RDF4JProtocolSession;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedHttpClientSessionManager
implements HttpClientSessionManager,
HttpClientDependent {
    private static final AtomicLong threadCount = new AtomicLong();
    public static final String CORE_POOL_SIZE_PROPERTY = "org.eclipse.rdf4j.client.executors.corePoolSize";
    public static final String MAX_CONN_PER_ROUTE_PROPERTY = "org.eclipse.rdf4j.client.http.maxConnPerRoute";
    public static final String MAX_CONN_TOTAL_PROPERTY = "org.eclipse.rdf4j.client.http.maxConnTotal";
    public static final String CONNECTION_TIMEOUT_PROPERTY = "org.eclipse.rdf4j.client.http.connectionTimeout";
    public static final String CONNECTION_REQUEST_TIMEOUT_PROPERTY = "org.eclipse.rdf4j.client.http.connectionRequestTimeout";
    public static final String SOCKET_TIMEOUT_PROPERTY = "org.eclipse.rdf4j.client.http.socketTimeout";
    public static final String SPARQL_CONNECTION_TIMEOUT_PROPERTY = "org.eclipse.rdf4j.client.sparql.http.connectionTimeout";
    public static final String SPARQL_CONNECTION_REQUEST_TIMEOUT_PROPERTY = "org.eclipse.rdf4j.client.sparql.http.connectionRequestTimeout";
    public static final String SPARQL_SOCKET_TIMEOUT_PROPERTY = "org.eclipse.rdf4j.client.sparql.http.socketTimeout";
    public static final int DEFAULT_CORE_POOL_SIZE = 5;
    public static final int DEFAULT_MAX_CONN_PER_ROUTE = 25;
    public static final int DEFAULT_MAX_CONN_TOTAL = 50;
    public static final int DEFAULT_CONNECTION_TIMEOUT = 30000;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 3600000;
    public static final int DEFAULT_SOCKET_TIMEOUT = 864000000;
    public static final int DEFAULT_SPARQL_CONNECTION_TIMEOUT = 5000;
    public static final int DEFAULT_SPARQL_CONNECTION_REQUEST_TIMEOUT = 600000;
    public static final int DEFAULT_SPARQL_SOCKET_TIMEOUT = 3600000;
    public static final int CORE_POOL_SIZE = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.executors.corePoolSize", String.valueOf(5)));
    public static final int MAX_CONN_PER_ROUTE = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.http.maxConnPerRoute", String.valueOf(25)));
    public static final int MAX_CONN_TOTAL = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.http.maxConnTotal", String.valueOf(50)));
    public static final int CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.http.connectionTimeout", String.valueOf(30000)));
    public static final int CONNECTION_REQUEST_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.http.connectionRequestTimeout", String.valueOf(3600000)));
    public static final int SOCKET_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.http.socketTimeout", String.valueOf(864000000)));
    public static final int SPARQL_CONNECTION_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.sparql.http.connectionTimeout", String.valueOf(5000)));
    public static final int SPARQL_CONNECTION_REQUEST_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.sparql.http.connectionRequestTimeout", String.valueOf(600000)));
    public static final int SPARQL_SOCKET_TIMEOUT = Integer.parseInt(System.getProperty("org.eclipse.rdf4j.client.sparql.http.socketTimeout", String.valueOf(3600000)));
    private int currentConnectionTimeout = CONNECTION_TIMEOUT;
    private int currentConnectionRequestTimeout = CONNECTION_REQUEST_TIMEOUT;
    private int currentSocketTimeout = SOCKET_TIMEOUT;
    private final Logger logger = LoggerFactory.getLogger(SharedHttpClientSessionManager.class);
    private volatile HttpClient httpClient;
    private volatile CloseableHttpClient dependentClient;
    private final ExecutorService executor;
    private volatile HttpClientBuilder httpClientBuilder;
    private final Map<SPARQLProtocolSession, Boolean> openSessions = new ConcurrentHashMap<SPARQLProtocolSession, Boolean>();
    private static final HttpRequestRetryHandler retryHandlerStale = new RetryHandlerStale();
    private static final ServiceUnavailableRetryStrategy serviceUnavailableRetryHandler = new ServiceUnavailableRetryHandler();

    public SharedHttpClientSessionManager() {
        ThreadFactory backingThreadFactory = Executors.defaultThreadFactory();
        ExecutorService threadPoolExecutor = Executors.newCachedThreadPool(runnable -> {
            Thread thread = backingThreadFactory.newThread(runnable);
            thread.setName(String.format("rdf4j-SharedHttpClientSessionManager-%d", threadCount.getAndIncrement()));
            thread.setDaemon(true);
            return thread;
        });
        Integer corePoolSize = CORE_POOL_SIZE;
        ((ThreadPoolExecutor)threadPoolExecutor).setCorePoolSize(corePoolSize);
        this.executor = threadPoolExecutor;
    }

    public SharedHttpClientSessionManager(CloseableHttpClient dependentClient, ScheduledExecutorService dependentExecutorService) {
        this.dependentClient = Objects.requireNonNull(dependentClient, "HTTP client was null");
        this.httpClient = this.dependentClient;
        this.executor = Objects.requireNonNull(dependentExecutorService, "Executor service was null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpClient getHttpClient() {
        HttpClient result = this.httpClient;
        if (result == null) {
            SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
            synchronized (sharedHttpClientSessionManager) {
                result = this.httpClient;
                if (result == null) {
                    this.dependentClient = this.createHttpClient();
                    this.httpClient = this.dependentClient;
                    result = this.dependentClient;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setHttpClient(HttpClient httpClient) {
        SharedHttpClientSessionManager sharedHttpClientSessionManager = this;
        synchronized (sharedHttpClientSessionManager) {
            this.httpClient = Objects.requireNonNull(httpClient, "HTTP Client cannot be null");
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
    }

    public void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        this.httpClientBuilder = httpClientBuilder;
    }

    @Override
    public SPARQLProtocolSession createSPARQLProtocolSession(String queryEndpointUrl, String updateEndpointUrl) {
        SPARQLProtocolSession session = new SPARQLProtocolSession(this.getHttpClient(), this.executor){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    SharedHttpClientSessionManager.this.openSessions.remove(this);
                }
            }
        };
        session.setQueryURL(queryEndpointUrl);
        session.setUpdateURL(updateEndpointUrl);
        this.openSessions.put(session, true);
        return session;
    }

    @Override
    public RDF4JProtocolSession createRDF4JProtocolSession(String serverURL) {
        RDF4JProtocolSession session = new RDF4JProtocolSession(this.getHttpClient(), this.executor){

            @Override
            public void close() {
                try {
                    super.close();
                }
                finally {
                    SharedHttpClientSessionManager.this.openSessions.remove(this);
                }
            }
        };
        session.setServerURL(serverURL);
        this.openSessions.put(session, true);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutDown() {
        try {
            this.openSessions.keySet().forEach(session -> {
                try {
                    session.close();
                }
                catch (Exception e) {
                    this.logger.error(e.toString(), (Throwable)e);
                }
            });
            CloseableHttpClient toCloseDependentClient = this.dependentClient;
            this.dependentClient = null;
            if (toCloseDependentClient != null) {
                HttpClientUtils.closeQuietly((HttpClient)toCloseDependentClient);
            }
        }
        finally {
            try {
                this.executor.shutdown();
                this.executor.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (!this.executor.isTerminated()) {
                    this.executor.shutdownNow();
                }
            }
        }
    }

    @Deprecated
    public void initialize() {
    }

    protected final ExecutorService getExecutorService() {
        return this.executor;
    }

    private CloseableHttpClient createHttpClient() {
        HttpClientBuilder nextHttpClientBuilder = this.httpClientBuilder;
        if (nextHttpClientBuilder != null) {
            return nextHttpClientBuilder.build();
        }
        RequestConfig requestConfig = this.getDefaultRequestConfig();
        return HttpClientBuilder.create().evictExpiredConnections().evictIdleConnections(30L, TimeUnit.MINUTES).setRetryHandler(retryHandlerStale).setServiceUnavailableRetryStrategy(serviceUnavailableRetryHandler).setMaxConnPerRoute(MAX_CONN_PER_ROUTE).setMaxConnTotal(MAX_CONN_TOTAL).useSystemProperties().setRedirectStrategy((RedirectStrategy)new SameMethodRedirectStrategy()).setDefaultRequestConfig(requestConfig).build();
    }

    public RequestConfig getDefaultRequestConfig() {
        return RequestConfig.custom().setConnectTimeout(this.currentConnectionTimeout).setConnectionRequestTimeout(this.currentConnectionRequestTimeout).setSocketTimeout(this.currentSocketTimeout).setRedirectsEnabled(true).setRelativeRedirectsAllowed(true).setExpectContinueEnabled(true).setCookieSpec("standard").build();
    }

    public void setDefaultSparqlServiceTimeouts() {
        this.currentConnectionTimeout = SPARQL_CONNECTION_TIMEOUT;
        this.currentConnectionRequestTimeout = SPARQL_CONNECTION_REQUEST_TIMEOUT;
        this.currentSocketTimeout = SPARQL_SOCKET_TIMEOUT;
    }

    public void setDefaultTimeouts() {
        this.currentConnectionTimeout = CONNECTION_TIMEOUT;
        this.currentConnectionRequestTimeout = CONNECTION_REQUEST_TIMEOUT;
        this.currentSocketTimeout = SOCKET_TIMEOUT;
    }

    private static class SameMethodRedirectStrategy
    extends DefaultRedirectStrategy {
        private static final String[] REDIRECT_METHODS = new String[]{"GET", "HEAD", "POST", "PUT", "DELETE", "PATCH"};

        private SameMethodRedirectStrategy() {
        }

        protected boolean isRedirectable(String method) {
            for (String m : REDIRECT_METHODS) {
                if (!m.equalsIgnoreCase(method)) continue;
                return true;
            }
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            URI uri = this.getLocationURI(request, response, context);
            RequestBuilder rb = RequestBuilder.copy((HttpRequest)request);
            rb.setUri(uri);
            return rb.build();
        }
    }

    private static class ServiceUnavailableRetryHandler
    implements ServiceUnavailableRetryStrategy {
        private final Logger logger = LoggerFactory.getLogger(ServiceUnavailableRetryHandler.class);

        private ServiceUnavailableRetryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
            if (response.getStatusLine().getStatusCode() != 408) {
                return false;
            }
            String keepAlive = System.getProperty("http.keepAlive", "true");
            if (!"true".equalsIgnoreCase(keepAlive)) {
                return false;
            }
            int pooledConnections = MAX_CONN_PER_ROUTE;
            if (executionCount > pooledConnections + 1) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpConnection conn = clientContext.getConnection();
            ServiceUnavailableRetryHandler serviceUnavailableRetryHandler = this;
            synchronized (serviceUnavailableRetryHandler) {
                try {
                    this.logger.info("Cleaning up closed connection");
                    conn.close();
                    return true;
                }
                catch (IOException e) {
                    this.logger.error("Error cleaning up closed connection", (Throwable)e);
                }
            }
            return false;
        }

        public long getRetryInterval() {
            return 1000L;
        }
    }

    private static class RetryHandlerStale
    implements HttpRequestRetryHandler {
        private final Logger logger = LoggerFactory.getLogger(RetryHandlerStale.class);

        private RetryHandlerStale() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean retryRequest(IOException ioe, int count, HttpContext context) {
            if (count > 1) {
                return false;
            }
            HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)context);
            HttpConnection conn = clientContext.getConnection();
            if (conn != null) {
                RetryHandlerStale retryHandlerStale = this;
                synchronized (retryHandlerStale) {
                    if (conn.isStale()) {
                        try {
                            this.logger.warn("Closing stale connection");
                            conn.close();
                            return true;
                        }
                        catch (IOException e) {
                            this.logger.error("Error closing stale connection", (Throwable)e);
                        }
                    }
                }
            }
            return false;
        }
    }
}

