/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.core.ecl.parser.model.OccurrencesSettings;
import org.eclipse.rcptt.ui.editors.ecl.ECLEditorPlugin;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ECLMarkOccurencesPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button occurencesEnabled;
    private Button markCommands;
    private Button markProcs;
    private Button markGlobals;
    private Button markLocals;

    public boolean performOk() {
        this.save();
        return super.performOk();
    }

    protected void performDefaults() {
        this.toUI(OccurrencesSettings.DEFAULT);
        super.performDefaults();
    }

    private OccurrencesSettings fromUI() {
        return new OccurrencesSettings(this.occurencesEnabled.getSelection(), this.markCommands.getSelection(), this.markProcs.getSelection(), this.markGlobals.getSelection(), this.markLocals.getSelection());
    }

    private void toUI(OccurrencesSettings settings) {
        this.occurencesEnabled.setSelection(settings.enabled);
        this.markCommands.setSelection(settings.commands);
        this.markProcs.setSelection(settings.procs);
        this.markGlobals.setSelection(settings.globals);
        this.markLocals.setSelection(settings.locals);
        this.updateEnablement();
    }

    private void updateEnablement() {
        boolean enabled = this.occurencesEnabled.getSelection();
        this.markCommands.setEnabled(enabled);
        this.markProcs.setEnabled(enabled);
        this.markGlobals.setEnabled(enabled);
        this.markLocals.setEnabled(enabled);
    }

    private void save() {
        ECLEditorPlugin.setMarkSettings(this.fromUI());
    }

    public void init(IWorkbench workbench) {
    }

    private Button createButton(Composite parent, String labelText, boolean master) {
        Button button = new Button(parent, 32);
        if (master) {
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ECLMarkOccurencesPage.this.updateEnablement();
                }
            });
        }
        button.setText(labelText);
        if (!master) {
            GridData gridData = new GridData();
            gridData.horizontalIndent = 10;
            button.setLayoutData((Object)gridData);
        }
        return button;
    }

    private void addFiller(Composite composite) {
        PixelConverter pixelConverter = new PixelConverter((Control)composite);
        Label filler = new Label(composite, 16384);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 1;
        gd.heightHint = pixelConverter.convertHeightInCharsToPixels(1) / 2;
        filler.setLayoutData((Object)gd);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.occurencesEnabled = this.createButton(composite, "Mark occurrences of the selected element in the current file.", true);
        this.addFiller(composite);
        this.markCommands = this.createButton(composite, "Commands", false);
        this.markProcs = this.createButton(composite, "References", false);
        this.markGlobals = this.createButton(composite, "Parameters", false);
        this.markLocals = this.createButton(composite, "Constants", false);
        this.toUI(ECLEditorPlugin.getMarkSettings());
        return composite;
    }
}

