/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.internal;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.CookieStore;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.impl.client.BasicCookieStore;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.userstorage.IStorageService;
import org.eclipse.userstorage.internal.Blob;
import org.eclipse.userstorage.internal.Codes;
import org.eclipse.userstorage.internal.Headers;
import org.eclipse.userstorage.internal.StorageProperties;
import org.eclipse.userstorage.internal.StorageService;
import org.eclipse.userstorage.internal.util.IOUtil;
import org.eclipse.userstorage.internal.util.JSONUtil;
import org.eclipse.userstorage.internal.util.ProxyUtil;
import org.eclipse.userstorage.internal.util.StringUtil;
import org.eclipse.userstorage.spi.Credentials;
import org.eclipse.userstorage.spi.ICredentialsProvider;
import org.eclipse.userstorage.util.ConflictException;
import org.eclipse.userstorage.util.NotFoundException;
import org.eclipse.userstorage.util.ProtocolException;

public class Session
implements Headers,
Codes {
    public static final String APPLICATION_JSON = "application/json";
    public static final String USER_AGENT_ID = "uss/1.0.0";
    public static final String USER_AGENT_PROPERTY = String.valueOf(Session.class.getName()) + ".userAgent";
    public static final String NOT_FOUND_ETAG = "not_found";
    private static final int AUTHENTICATION_ATTEMPTS = 3;
    private static final boolean DEBUG = Boolean.getBoolean("org.eclipse.userstorage.session.debug");
    private final CookieStore cookieStore = new BasicCookieStore();
    private final Executor executor = Executor.newInstance().cookieStore(this.cookieStore);
    private final StorageService service;
    private String sessionID;
    private String csrfToken;

    public Session(StorageService service) {
        this.service = service;
    }

    public IStorageService getService() {
        return this.service;
    }

    public void reset() {
        this.sessionID = null;
        this.csrfToken = null;
        this.cookieStore.clear();
    }

    public Map<String, Map<String, Object>> retrieveProperties(final String applicationToken, ICredentialsProvider credentialsProvider, int pageSize, int page) throws IOException {
        if (pageSize < 1 || pageSize > 100) {
            throw new IllegalArgumentException("pageSize=" + pageSize);
        }
        if (page < 1) {
            throw new IllegalArgumentException("page=" + page);
        }
        URI uri = StringUtil.newURI(this.service.getServiceURI(), "api/blob/" + applicationToken + "?pagesize=" + pageSize + "&page=" + page);
        return (Map)new RequestTemplate<Map<String, Map<String, Object>>>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                return this.configureRequest(Request.Get((URI)this.uri), this.uri);
            }

            @Override
            protected Map<String, Map<String, Object>> handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                this.getStatusCode("GET", this.uri, response, 200);
                List array = (List)JSONUtil.parse(responseEntity.getContent(), null);
                HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>();
                for (Object element : array) {
                    Map map = (Map)element;
                    Object appToken = map.remove("application_token");
                    if (!applicationToken.equals(appToken)) {
                        StatusLine statusLine = response.getStatusLine();
                        String protocolVersion = statusLine == null ? "HTTP" : this.getProtocolVersion(statusLine);
                        throw new ProtocolException("GET", this.uri, protocolVersion, 444, "Bad Response : Wrong application token: " + appToken);
                    }
                    map.remove("url");
                    String key = (String)map.remove("key");
                    result.put(key, map);
                }
                return result;
            }
        }.send(credentialsProvider);
    }

    public InputStream retrieveBlob(String applicationToken, String key, final Map<String, String> properties, final boolean useETag, ICredentialsProvider credentialsProvider) throws IOException {
        URI uri = StringUtil.newURI(this.service.getServiceURI(), "api/blob/" + applicationToken + "/" + key);
        return (InputStream)new RequestTemplate<InputStream>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                Request request = this.configureRequest(Request.Get((URI)this.uri), this.uri);
                if (useETag) {
                    String eTag = (String)properties.get("etag");
                    if (DEBUG) {
                        System.out.println("Retrieving etag = " + eTag);
                    }
                    if (!StringUtil.isEmpty(eTag)) {
                        request.setHeader("If-None-Match", "\"" + eTag + "\"");
                    }
                }
                return request;
            }

            @Override
            protected InputStream handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                int statusCode = this.getStatusCode("GET", this.uri, response, 200, 304, 404);
                String eTag = Session.getETag(response);
                if (eTag != null) {
                    if (DEBUG) {
                        System.out.println("Retrieved etag = " + eTag);
                    }
                    properties.put("etag", eTag);
                }
                if (statusCode == 200) {
                    Map object = (Map)JSONUtil.parse(responseEntity.getContent(), "value");
                    InputStream stream = (InputStream)object.remove("value");
                    for (Map.Entry entry : object.entrySet()) {
                        Object value = entry.getValue();
                        properties.put((String)entry.getKey(), String.valueOf(value));
                    }
                    return stream;
                }
                if (statusCode == 304) {
                    return Blob.NOT_MODIFIED;
                }
                properties.clear();
                StatusLine statusLine = response.getStatusLine();
                throw new NotFoundException("GET", this.uri, this.getProtocolVersion(statusLine), statusLine.getReasonPhrase());
            }
        }.send(credentialsProvider);
    }

    public boolean updateBlob(String applicationToken, String key, final Map<String, String> properties, final InputStream in, ICredentialsProvider credentialsProvider) throws IOException, ConflictException {
        URI uri = StringUtil.newURI(this.service.getServiceURI(), "api/blob/" + applicationToken + "/" + key);
        return (Boolean)new RequestTemplate<Boolean>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                Request request = this.configureRequest(Request.Put((URI)this.uri), this.uri);
                String eTag = (String)properties.get("etag");
                if (DEBUG) {
                    System.out.println("Updating etag = " + eTag);
                }
                if (!StringUtil.isEmpty(eTag)) {
                    request.setHeader("If-Match", "\"" + eTag + "\"");
                }
                this.body = JSONUtil.build(Collections.singletonMap("value", in));
                request.bodyStream(this.body);
                return request;
            }

            @Override
            protected Boolean handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                String eTag = Session.getETag(response);
                int statusCode = this.getStatusCode("PUT", this.uri, response, 200, 201, 409);
                if (statusCode == 409) {
                    StatusLine statusLine = response.getStatusLine();
                    throw new ConflictException("PUT", this.uri, this.getProtocolVersion(statusLine), statusLine.getReasonPhrase(), eTag);
                }
                if (eTag == null) {
                    throw new ProtocolException("PUT", this.uri, this.getProtocolVersion(response.getStatusLine()), 444, "Bad Response : No ETag");
                }
                if (DEBUG) {
                    System.out.println("Updated etag = " + eTag);
                }
                properties.put("etag", eTag);
                if (statusCode == 201) {
                    return true;
                }
                return false;
            }
        }.send(credentialsProvider);
    }

    public boolean deleteBlob(String applicationToken, String key, final Map<String, String> properties, ICredentialsProvider credentialsProvider) throws IOException, ConflictException {
        URI uri = StringUtil.newURI(this.service.getServiceURI(), "api/blob/" + applicationToken + "/" + key);
        boolean deleted = (Boolean)new RequestTemplate<Boolean>(this, uri){

            @Override
            protected Request prepareRequest() throws IOException {
                Request request = this.configureRequest(Request.Delete((URI)this.uri), this.uri);
                String eTag = (String)properties.get("etag");
                if (!StringUtil.isEmpty(eTag)) {
                    request.setHeader("If-Match", "\"" + eTag + "\"");
                }
                return request;
            }

            @Override
            protected Boolean handleResponse(HttpResponse response, HttpEntity responseEntity) throws IOException {
                int statusCode = this.getStatusCode("DELETE", this.uri, response, 204, 409, 404);
                String eTag = Session.getETag(response);
                if (statusCode == 409) {
                    StatusLine statusLine = response.getStatusLine();
                    throw new ConflictException("DELETE", this.uri, this.getProtocolVersion(statusLine), statusLine.getReasonPhrase(), eTag);
                }
                properties.put("etag", "<deleted_etag>");
                if (statusCode == 204) {
                    return true;
                }
                return false;
            }
        }.send(credentialsProvider);
        return deleted;
    }

    private void debugResponseEntity(HttpEntity responseEntity) throws IOException {
        if (DEBUG && responseEntity != null) {
            responseEntity.writeTo((OutputStream)System.out);
            System.out.println();
            System.out.println();
        }
    }

    private static String getETag(HttpResponse response) {
        String eTag;
        Header[] headers = response.getHeaders("ETag");
        if (headers != null && headers.length != 0 && !StringUtil.isEmpty(eTag = headers[0].getValue())) {
            return eTag.substring(1, eTag.length() - 1);
        }
        return null;
    }

    private abstract class RequestTemplate<T> {
        protected final URI uri;
        protected InputStream body;

        public RequestTemplate(URI uri) {
            this.uri = uri;
        }

        public final synchronized T send(ICredentialsProvider credentialsProvider) throws IOException {
            int authenticationAttempts = 3;
            boolean reauthentication = false;
            Credentials credentials = Session.this.service.getCredentials();
            if (credentials != null) {
                if (StringUtil.isEmpty(credentials.getUsername()) || StringUtil.isEmpty(credentials.getPassword())) {
                    credentials = null;
                } else {
                    ++authenticationAttempts;
                }
            }
            boolean authenticated = false;
            while (true) {
                this.body = null;
                HttpEntity responseEntity = null;
                try {
                    authenticated = false;
                    this.authenticate(credentials, credentialsProvider, reauthentication);
                    authenticated = true;
                    Request request = this.prepareRequest();
                    HttpResponse response = this.sendRequest(request, this.uri);
                    IOUtil.closeSilent(this.body);
                    this.body = null;
                    responseEntity = response.getEntity();
                    T t = this.handleResponse(response, responseEntity);
                    return t;
                }
                catch (IOException ex) {
                    ProtocolException protocolException;
                    Session.this.debugResponseEntity(responseEntity);
                    if (ex instanceof ProtocolException && (protocolException = (ProtocolException)ex).getStatusCode() == 401) {
                        if (authenticated) {
                            Session.this.reset();
                            continue;
                        }
                        if (--authenticationAttempts > 0) {
                            reauthentication = true;
                            credentials = null;
                            continue;
                        }
                    }
                    throw ex;
                }
                finally {
                    IOUtil.closeSilent(this.body);
                    this.body = null;
                    continue;
                }
                break;
            }
        }

        protected final void authenticate(Credentials credentials, ICredentialsProvider credentialsProvider, boolean reauthentication) throws IOException {
            if (Session.this.sessionID == null) {
                Session.this.reset();
                InputStream body = null;
                HttpEntity responseEntity = null;
                try {
                    try {
                        credentials = this.getCredentials(credentials, credentialsProvider, reauthentication);
                        LinkedHashMap<String, String> arguments = new LinkedHashMap<String, String>();
                        arguments.put("username", credentials.getUsername());
                        arguments.put("password", credentials.getPassword());
                        URI uri = StringUtil.newURI(Session.this.service.getServiceURI(), "api/user/login");
                        Request request = this.configureRequest(Request.Post((URI)uri), uri);
                        body = JSONUtil.build(arguments);
                        request.bodyStream(body);
                        HttpResponse response = this.sendRequest(request, uri);
                        responseEntity = response.getEntity();
                        this.getStatusCode("POST", uri, response, 200);
                        Map object = (Map)JSONUtil.parse(responseEntity.getContent(), null);
                        Session.this.sessionID = (String)object.get("sessid");
                        if (Session.this.sessionID == null) {
                            throw new IOException("No session ID");
                        }
                        Session.this.csrfToken = (String)object.get("token");
                    }
                    catch (IOException ex) {
                        Session.this.sessionID = null;
                        Session.this.csrfToken = null;
                        Session.this.debugResponseEntity(responseEntity);
                        throw ex;
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.closeSilent(body);
                    throw throwable;
                }
                IOUtil.closeSilent(body);
            }
            this.acquireCSRFToken();
        }

        protected final void acquireCSRFToken() throws IOException {
            if (Session.this.csrfToken == null) {
                HttpEntity responseEntity = null;
                try {
                    URI uri = StringUtil.newURI(Session.this.service.getServiceURI(), "api/user/token");
                    Request request = this.configureRequest(Request.Post((URI)uri), uri);
                    HttpResponse response = this.sendRequest(request, uri);
                    responseEntity = response.getEntity();
                    Map object = (Map)JSONUtil.parse(responseEntity.getContent(), null);
                    Session.this.csrfToken = (String)object.get("token");
                    if (Session.this.csrfToken == null) {
                        throw new IOException("No CSRF token");
                    }
                }
                catch (IOException ex) {
                    Session.this.csrfToken = null;
                    Session.this.debugResponseEntity(responseEntity);
                    throw ex;
                }
            }
        }

        protected final Request configureRequest(Request request, URI uri) {
            if (Session.this.csrfToken != null) {
                request.setHeader("X-CSRF-Token", Session.this.csrfToken);
            }
            String userAgent = System.getProperty(USER_AGENT_PROPERTY, Session.USER_AGENT_ID);
            return request.viaProxy(ProxyUtil.getProxyHost(uri)).staleConnectionCheck(true).connectTimeout(StorageProperties.getProperty("org.eclipse.userstorage.connectTimeout", 3000)).socketTimeout(StorageProperties.getProperty("org.eclipse.userstorage.socketTimeout", 10000)).addHeader("User-Agent", userAgent).addHeader("Content-Type", Session.APPLICATION_JSON).addHeader("Accept", Session.APPLICATION_JSON);
        }

        protected final HttpResponse sendRequest(Request request, URI uri) throws IOException {
            long start = 0L;
            if (DEBUG) {
                try {
                    start = System.currentTimeMillis();
                    StringBuilder builder = new StringBuilder();
                    builder.append(request);
                    builder.append('\n');
                    Field f1 = Request.class.getDeclaredField("request");
                    f1.setAccessible(true);
                    Object o1 = f1.get(request);
                    Field f2 = Class.forName("org.apache.http.message.AbstractHttpMessage").getDeclaredField("headergroup");
                    f2.setAccessible(true);
                    Object o2 = f2.get(o1);
                    Field f3 = o2.getClass().getDeclaredField("headers");
                    f3.setAccessible(true);
                    List o3 = (List)f3.get(o2);
                    for (Header header : o3) {
                        builder.append("   ");
                        builder.append(header);
                        builder.append('\n');
                    }
                    System.out.print(builder);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            Response result = ProxyUtil.proxyAuthentication(Session.this.executor, uri).execute(request);
            HttpResponse response = result.returnResponse();
            if (DEBUG) {
                try {
                    StringBuilder builder = new StringBuilder();
                    builder.append(response.getStatusLine());
                    builder.append('\n');
                    Header[] headerArray = response.getAllHeaders();
                    int n = headerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Header header = headerArray[n2];
                        builder.append("   ");
                        builder.append(header);
                        builder.append('\n');
                        ++n2;
                    }
                    if (start != 0L) {
                        long millis = System.currentTimeMillis() - start;
                        builder.append("Took: ");
                        builder.append(millis);
                        builder.append(" millis");
                        builder.append('\n');
                    }
                    builder.append('\n');
                    System.out.print(builder);
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
            return response;
        }

        protected final int getStatusCode(String method, URI uri, HttpResponse response, int ... expectedStatusCodes) throws ProtocolException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine == null) {
                throw new ProtocolException(method, uri, this.getProtocolVersion(statusLine), 444, "Bad Response : No status line returned");
            }
            int statusCode = statusLine.getStatusCode();
            if (statusCode == 401) {
                Session.this.sessionID = null;
                Session.this.csrfToken = null;
            }
            int i = 0;
            while (i < expectedStatusCodes.length) {
                int expectedStatusCode = expectedStatusCodes[i];
                if (statusCode == expectedStatusCode) {
                    return statusCode;
                }
                ++i;
            }
            throw new ProtocolException(method, uri, this.getProtocolVersion(statusLine), statusCode, statusLine.getReasonPhrase());
        }

        protected final String getProtocolVersion(StatusLine statusLine) {
            ProtocolVersion protocolVersion;
            if (statusLine != null && (protocolVersion = statusLine.getProtocolVersion()) != null) {
                return protocolVersion.toString();
            }
            return "HTTP";
        }

        protected final Credentials getCredentials(Credentials credentials, ICredentialsProvider credentialsProvider, boolean reauthentication) throws OperationCanceledException {
            if (credentials == null && credentialsProvider != null) {
                block8: {
                    Semaphore semaphore = Session.this.service.getAuthenticationSemaphore();
                    try {
                        try {
                            semaphore.acquire();
                            credentials = credentialsProvider.provideCredentials(Session.this.service, reauthentication);
                        }
                        catch (InterruptedException interruptedException) {
                            semaphore.release();
                            break block8;
                        }
                    }
                    catch (Throwable throwable) {
                        semaphore.release();
                        throw throwable;
                    }
                    semaphore.release();
                }
                if (credentials != null) {
                    Session.this.service.setCredentials(credentials);
                }
            }
            if (credentials == null) {
                throw new OperationCanceledException("No credentials provided");
            }
            return credentials;
        }

        protected abstract Request prepareRequest() throws IOException;

        protected abstract T handleResponse(HttpResponse var1, HttpEntity var2) throws IOException;
    }
}

