/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.dynamichelpers.ExtensionTracker;
import org.eclipse.core.runtime.dynamichelpers.IExtensionChangeHandler;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceNode;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.preferences.WorkbenchPreferenceExpressionNode;
import org.eclipse.ui.internal.registry.PreferencePageRegistryReader;

public class WorkbenchPreferenceManager
extends PreferenceManager
implements IExtensionChangeHandler {
    public WorkbenchPreferenceManager(char separatorChar) {
        super(separatorChar, (PreferenceNode)new WorkbenchPreferenceExpressionNode(""));
        IExtensionTracker tracker = PlatformUI.getWorkbench().getExtensionTracker();
        tracker.registerHandler((IExtensionChangeHandler)this, ExtensionTracker.createExtensionPointFilter((IExtensionPoint)this.getExtensionPointFilter()));
        Platform.getExtensionRegistry().addRegistryChangeListener(event -> {
            if (event.getExtensionDeltas("org.eclipse.ui", "keywords").length > 0) {
                for (IPreferenceNode element : this.getElements(1)) {
                    ((WorkbenchPreferenceNode)element).clearKeywords();
                }
            }
        });
    }

    public void addPages(Collection pageContributions) {
        for (Object next : pageContributions) {
            if (!(next instanceof WorkbenchPreferenceNode)) continue;
            WorkbenchPreferenceNode wNode = (WorkbenchPreferenceNode)next;
            this.addToRoot((IPreferenceNode)wNode);
            this.registerNode(wNode);
        }
    }

    private void registerNode(WorkbenchPreferenceNode node) {
        PlatformUI.getWorkbench().getExtensionTracker().registerObject(node.getConfigurationElement().getDeclaringExtension(), (Object)node, 2);
        IPreferenceNode[] iPreferenceNodeArray = node.getSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subNode = iPreferenceNodeArray[n2];
            this.registerNode((WorkbenchPreferenceNode)subNode);
            ++n2;
        }
    }

    public void addExtension(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configElement = iConfigurationElementArray[n2];
            WorkbenchPreferenceNode node = PreferencePageRegistryReader.createNode(configElement);
            if (node != null) {
                this.registerNode(node);
                String category = node.getCategory();
                if (category == null) {
                    this.addToRoot((IPreferenceNode)node);
                } else {
                    IPreferenceNode parent = null;
                    for (IPreferenceNode element : this.getElements(1)) {
                        if (!category.equals(element.getId())) continue;
                        parent = element;
                        break;
                    }
                    if (parent == null) {
                        String message = "Invalid preference category path: " + category + " (bundle: " + node.getPluginId() + ", page: " + node.getId() + ")";
                        WorkbenchPlugin.log(StatusUtil.newStatus(2, message, null));
                        this.addToRoot((IPreferenceNode)node);
                    } else {
                        parent.add((IPreferenceNode)node);
                    }
                }
            }
            ++n2;
        }
    }

    private IExtensionPoint getExtensionPointFilter() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "preferencePages");
    }

    public void removeExtension(IExtension extension, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof IPreferenceNode) {
                IPreferenceNode wNode = (IPreferenceNode)object;
                wNode.disposeResources();
                this.deepRemove(this.getRoot(), wNode);
            }
            ++n2;
        }
    }

    private boolean deepRemove(IPreferenceNode parent, IPreferenceNode nodeToRemove) {
        if (parent == nodeToRemove && parent == this.getRoot()) {
            this.removeAll();
            return true;
        }
        if (parent.remove(nodeToRemove)) {
            return true;
        }
        IPreferenceNode[] iPreferenceNodeArray = parent.getSubNodes();
        int n = iPreferenceNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPreferenceNode subNode = iPreferenceNodeArray[n2];
            if (this.deepRemove(subNode, nodeToRemove)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

