/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.ssl;

import java.security.Principal;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CertificateChainSorter {
    public static X509Certificate[] sortCertificates(X509Certificate[] certificates) {
        if (certificates == null || certificates.length <= 1) {
            return certificates;
        }
        Map<Principal, X509Certificate> subjects = CertificateChainSorter.createIndexBySubject(certificates);
        List<X509Certificate> sortedChain = CertificateChainSorter.buildSortedChain(certificates[0], subjects);
        return sortedChain.toArray(new X509Certificate[0]);
    }

    private static Map<Principal, X509Certificate> createIndexBySubject(X509Certificate[] certificates) {
        HashMap<Principal, X509Certificate> subjects = new HashMap<Principal, X509Certificate>();
        int i = 0;
        while (i < certificates.length) {
            X509Certificate currentCert = certificates[i];
            subjects.put(currentCert.getSubjectDN(), currentCert);
            ++i;
        }
        return subjects;
    }

    private static List<X509Certificate> buildSortedChain(X509Certificate endEntityCertificate, Map<Principal, X509Certificate> subjects) {
        X509Certificate issuer;
        ArrayList<X509Certificate> sortedChain = new ArrayList<X509Certificate>();
        X509Certificate currentCert = endEntityCertificate;
        sortedChain.add(currentCert);
        do {
            if ((issuer = subjects.get(currentCert.getIssuerDN())) == null) continue;
            sortedChain.add(issuer);
            currentCert = issuer;
        } while (issuer != null && !CertificateChainSorter.isRootCertificate(issuer));
        return sortedChain;
    }

    private static boolean isRootCertificate(X509Certificate certificate) {
        return certificate != null && certificate.getSubjectDN().equals(certificate.getIssuerDN());
    }
}

