/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.helper;

import org.apache.felix.scr.impl.logger.InternalLogger;
import org.apache.felix.scr.impl.manager.ComponentActivator;
import org.apache.felix.scr.impl.manager.RegionConfigurationSupport;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ConfigAdminTracker {
    public static final String CONFIGURATION_ADMIN = "org.osgi.service.cm.ConfigurationAdmin";
    private final ServiceTracker<ConfigurationAdmin, RegionConfigurationSupport> configAdminTracker;

    public ConfigAdminTracker(final ComponentActivator componentActivator) {
        this.configAdminTracker = new ServiceTracker(componentActivator.getBundleContext(), CONFIGURATION_ADMIN, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ConfigurationAdmin, RegionConfigurationSupport>(){

            public RegionConfigurationSupport addingService(ServiceReference<ConfigurationAdmin> reference) {
                boolean visible = false;
                try {
                    ConfigurationAdmin ca = (ConfigurationAdmin)componentActivator.getBundleContext().getService(reference);
                    if (ca != null) {
                        visible = true;
                        componentActivator.getBundleContext().ungetService(reference);
                    }
                }
                catch (Exception ex) {
                    componentActivator.getLogger().log(InternalLogger.Level.ERROR, "Configuration admin API visible to bundle " + componentActivator.getBundleContext().getBundle() + " is not the same as the Configuration Admin API visible to the SCR implementation.", ex);
                }
                if (!visible) {
                    return null;
                }
                return componentActivator.setRegionConfigurationSupport(reference);
            }

            public void modifiedService(ServiceReference<ConfigurationAdmin> reference, RegionConfigurationSupport service) {
            }

            public void removedService(ServiceReference<ConfigurationAdmin> reference, RegionConfigurationSupport rcs) {
                componentActivator.unsetRegionConfigurationSupport(rcs);
            }
        });
        this.configAdminTracker.open();
    }

    public void dispose() {
        this.configAdminTracker.close();
    }
}

