/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.style.ConfigAttribute;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;
import org.eclipse.nebula.widgets.nattable.style.IStyle;

public abstract class StyleProxy
implements IStyle {
    private final ConfigAttribute<IStyle> styleConfigAttribute;
    protected final IConfigRegistry configRegistry;
    private final DisplayMode targetDisplayMode;
    private final List<String> configLabels;

    @Deprecated
    public StyleProxy(ConfigAttribute<IStyle> styleConfigAttribute, IConfigRegistry configRegistry, String targetDisplayMode, List<String> configLabels) {
        this(styleConfigAttribute, configRegistry, DisplayMode.valueOf(targetDisplayMode), configLabels);
    }

    public StyleProxy(ConfigAttribute<IStyle> styleConfigAttribute, IConfigRegistry configRegistry, DisplayMode targetDisplayMode, List<String> configLabels) {
        this.styleConfigAttribute = styleConfigAttribute;
        this.configRegistry = configRegistry;
        this.targetDisplayMode = targetDisplayMode;
        this.configLabels = configLabels;
    }

    @Override
    public <T> T getAttributeValue(ConfigAttribute<T> styleAttribute) {
        T styleAttributeValue = null;
        IDisplayModeOrdering displayModeOrdering = this.configRegistry.getDisplayModeOrdering();
        for (DisplayMode displayMode : displayModeOrdering.getDisplayModeOrdering(this.targetDisplayMode)) {
            for (String configLabel : this.configLabels) {
                IStyle cellStyle = this.configRegistry.getSpecificConfigAttribute(this.styleConfigAttribute, displayMode, configLabel);
                if (cellStyle == null || (styleAttributeValue = (T)cellStyle.getAttributeValue(styleAttribute)) == null) continue;
                return styleAttributeValue;
            }
            IStyle cellStyle = this.configRegistry.getSpecificConfigAttribute(this.styleConfigAttribute, displayMode, null);
            if (cellStyle == null || (styleAttributeValue = (T)cellStyle.getAttributeValue(styleAttribute)) == null) continue;
            return styleAttributeValue;
        }
        return null;
    }
}

