/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.fixtures;

import java.net.URL;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultColumnHeaderStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.sort.painter.SortableHeaderTextPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;

public class StyledColumnHeaderConfiguration
extends DefaultColumnHeaderStyleConfiguration {
    public StyledColumnHeaderConfiguration() {
        this.font = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Verdana", 10, 1)});
    }

    public void configureRegistry(IConfigRegistry configRegistry) {
        super.configureRegistry(configRegistry);
        this.addNormalModeStyling(configRegistry);
        this.addSelectedModeStyling(configRegistry);
    }

    private void addSelectedModeStyling(IConfigRegistry configRegistry) {
        Image selectedBgImage = GUIHelper.getImageByURL((String)"selectedColumnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("selected_column_header_bg.png"));
        TextPainter txtPainter = new TextPainter(false, false);
        BackgroundImagePainter selectedCellPainter = new BackgroundImagePainter((ICellPainter)txtPainter, selectedBgImage, GUIHelper.getColor((int)192, (int)192, (int)192));
        SortableHeaderTextPainter selectedHeaderPainter = new SortableHeaderTextPainter((ICellPainter)selectedCellPainter, false, true);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)selectedHeaderPainter, "SELECT", "COLUMN_HEADER");
    }

    private void addNormalModeStyling(IConfigRegistry configRegistry) {
        Image bgImage = GUIHelper.getImageByURL((String)"columnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("column_header_bg.png"));
        TextPainter txtPainter = new TextPainter(false, false);
        BackgroundImagePainter bgImagePainter = new BackgroundImagePainter((ICellPainter)txtPainter, bgImage, GUIHelper.getColor((int)192, (int)192, (int)192));
        SortableHeaderTextPainter headerPainter = new SortableHeaderTextPainter((ICellPainter)bgImagePainter, false, true);
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "COLUMN_HEADER");
        configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)headerPainter, "NORMAL", "CORNER");
    }
}

