/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples.examples._131_Filtering;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDoubleDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.fixture.data.PricingTypeBean;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.PersistentNatExampleWrapper;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.FilterRowExampleGridLayer;
import org.eclipse.nebula.widgets.nattable.examples.fixtures.PricingTypeBeanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterIconPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowPainter;
import org.eclipse.nebula.widgets.nattable.filterrow.TextMatchingMode;
import org.eclipse.nebula.widgets.nattable.filterrow.config.FilterRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class FilterRowGridExample
extends AbstractNatExample {
    public static void main(String[] args) {
        StandaloneNatExampleRunner.run(new PersistentNatExampleWrapper(new FilterRowGridExample()));
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        FilterRowExampleGridLayer underlyingLayer = new FilterRowExampleGridLayer((IConfigRegistry)configRegistry);
        NatTable natTable = new NatTable(parent, (ILayer)underlyingLayer, false);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
        natTable.addConfiguration((IConfiguration)new FilterRowCustomConfiguration(){

            @Override
            public void configureRegistry(IConfigRegistry configRegistry) {
                super.configureRegistry(configRegistry);
                Style rowStyle = new Style();
                rowStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.getColor((int)197, (int)212, (int)231));
                configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)rowStyle, "NORMAL", "FILTER_ROW");
            }
        });
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.configure();
        return natTable;
    }

    private static Comparator<?> getIngnorecaseComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareToIgnoreCase(o2);
            }
        };
    }

    public static class FilterRowCustomConfiguration
    extends AbstractRegistryConfiguration {
        final DefaultDoubleDisplayConverter doubleDisplayConverter = new DefaultDoubleDisplayConverter();

        public void configureRegistry(IConfigRegistry configRegistry) {
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new FilterRowPainter((ImagePainter)new FilterIconPainter(GUIHelper.getImage((String)"filter"))), "NORMAL", "FILTER_ROW");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_COMPARATOR, (Object)FilterRowGridExample.getIngnorecaseComparator(), "NORMAL", "FILTER_COLUMN_2");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)this.doubleDisplayConverter, "NORMAL", "FILTER_COLUMN_5");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_5");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)this.doubleDisplayConverter, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.TEXT_MATCHING_MODE, (Object)TextMatchingMode.REGULAR_EXPRESSION, "NORMAL", "FILTER_COLUMN_6");
            configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(Arrays.asList(new PricingTypeBean("MN"), new PricingTypeBean("AT"))), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(FilterRowConfigAttributes.FILTER_DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "FILTER_COLUMN_4");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new PricingTypeBeanDisplayConverter(), "NORMAL", "PRICING_TYPE_PROP_NAME");
        }
    }
}

