/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._800_Integration;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.ConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.ExtendedReflectiveColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IColumnPropertyAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.IDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditBindings;
import org.eclipse.nebula.widgets.nattable.edit.config.DefaultEditConfiguration;
import org.eclipse.nebula.widgets.nattable.edit.editor.ComboBoxCellEditor;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.export.command.ExportCommandHandler;
import org.eclipse.nebula.widgets.nattable.export.config.DefaultExportBindings;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsEventLayer;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.GlazedListsSortModel;
import org.eclipse.nebula.widgets.nattable.extension.glazedlists.filterrow.DefaultGlazedListsFilterStrategy;
import org.eclipse.nebula.widgets.nattable.filterrow.FilterRowHeaderComposite;
import org.eclipse.nebula.widgets.nattable.filterrow.IFilterStrategy;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.layer.CompositeLayer;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.print.command.PrintCommandHandler;
import org.eclipse.nebula.widgets.nattable.print.config.DefaultPrintBindings;
import org.eclipse.nebula.widgets.nattable.selection.RowSelectionProvider;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.sort.ISortModel;
import org.eclipse.nebula.widgets.nattable.sort.SortHeaderLayer;
import org.eclipse.nebula.widgets.nattable.sort.config.SingleClickSortConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _801_VerticalCompositionWithFeaturesExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _801_VerticalCompositionWithFeaturesExample());
    }

    @Override
    public String getDescription() {
        return "This example shows how to assemble a table that consists of a column header and a body layer.\nThis example also shows how to configure such a composition by adding sorting, filtering, editing, copy, print and export features.\nAdditionally it contains example code for modifying the table content with actions outside the NatTable context.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        ConfigRegistry configRegistry = new ConfigRegistry();
        Composite panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        panel.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)panel);
        Composite gridPanel = new Composite(panel, 0);
        gridPanel.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)gridPanel);
        Composite buttonPanel = new Composite(panel, 0);
        buttonPanel.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)buttonPanel);
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        ExtendedReflectiveColumnPropertyAccessor columnPropertyAccessor = new ExtendedReflectiveColumnPropertyAccessor(propertyNames);
        List values = PersonService.getPersons((int)10);
        final EventList eventList = GlazedLists.eventList((Collection)values);
        TransformedList rowObjectsGlazedList = GlazedLists.threadSafeList((EventList)eventList);
        SortedList sortedList = new SortedList((EventList)rowObjectsGlazedList, null);
        FilterList filterList = new FilterList((EventList)sortedList);
        ListDataProvider bodyDataProvider = new ListDataProvider((List)filterList, (IColumnAccessor)columnPropertyAccessor);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        GlazedListsEventLayer eventLayer = new GlazedListsEventLayer((IUniqueIndexLayer)bodyDataLayer, (EventList)filterList);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)eventLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DataLayer columnHeaderDataLayer = new DataLayer((IDataProvider)columnHeaderDataProvider);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
        SortHeaderLayer sortHeaderLayer = new SortHeaderLayer((ILayer)columnHeaderLayer, (ISortModel)new GlazedListsSortModel(sortedList, (IColumnPropertyAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry, (ILayer)columnHeaderDataLayer), false);
        FilterRowHeaderComposite filterRowHeaderLayer = new FilterRowHeaderComposite((IFilterStrategy)new DefaultGlazedListsFilterStrategy(filterList, (IColumnAccessor)columnPropertyAccessor, (IConfigRegistry)configRegistry), (ILayer)sortHeaderLayer, (IDataProvider)columnHeaderDataProvider, (IConfigRegistry)configRegistry);
        CompositeLayer compositeLayer = new CompositeLayer(1, 2);
        compositeLayer.setChildLayer("COLUMN_HEADER", (ILayer)filterRowHeaderLayer, 0, 0);
        compositeLayer.setChildLayer("BODY", (ILayer)viewportLayer, 0, 1);
        compositeLayer.addConfiguration((IConfiguration)new DefaultEditConfiguration());
        compositeLayer.addConfiguration((IConfiguration)new DefaultEditBindings());
        compositeLayer.registerCommandHandler((ILayerCommandHandler)new PrintCommandHandler((ILayer)compositeLayer));
        compositeLayer.addConfiguration((IConfiguration)new DefaultPrintBindings());
        compositeLayer.registerCommandHandler((ILayerCommandHandler)new ExportCommandHandler((ILayer)compositeLayer));
        compositeLayer.addConfiguration((IConfiguration)new DefaultExportBindings());
        final NatTable natTable = new NatTable(gridPanel, (ILayer)compositeLayer, false);
        natTable.setConfigRegistry((IConfigRegistry)configRegistry);
        natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
        natTable.addConfiguration((IConfiguration)new SingleClickSortConfiguration());
        natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

            public void configureRegistry(IConfigRegistry configRegistry) {
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.ALWAYS_EDITABLE);
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITABLE_RULE, (Object)IEditableRule.NEVER_EDITABLE, "NORMAL", "COLUMN_4");
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(Arrays.asList(Person.Gender.FEMALE, Person.Gender.MALE)), "NORMAL", "COLUMN_2");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)_801_VerticalCompositionWithFeaturesExample.this.getGenderBooleanConverter(), "NORMAL", "COLUMN_2");
                configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)new ComboBoxCellEditor(Arrays.asList(Boolean.TRUE, Boolean.FALSE)), "NORMAL", "COLUMN_3");
                configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", "COLUMN_3");
            }
        });
        natTable.configure();
        final RowSelectionProvider selectionProvider = new RowSelectionProvider(selectionLayer, (IRowDataProvider)bodyDataProvider, false);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        Button button = new Button(buttonPanel, 8);
        button.setText("Remove selected item");
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (natTable.getActiveCellEditor() != null) {
                    natTable.commitAndCloseActiveCellEditor();
                }
                Person item = (Person)((IStructuredSelection)selectionProvider.getSelection()).getFirstElement();
                eventList.remove((Object)item);
            }
        });
        return panel;
    }

    private IDisplayConverter getGenderBooleanConverter() {
        return new DisplayConverter(){

            public Object canonicalToDisplayValue(Object canonicalValue) {
                if (canonicalValue instanceof Person.Gender) {
                    return canonicalValue.toString();
                }
                return null;
            }

            public Object displayToCanonicalValue(Object displayValue) {
                Boolean displayBoolean = Boolean.valueOf(displayValue.toString());
                return displayBoolean != false ? Person.Gender.MALE : Person.Gender.FEMALE;
            }
        };
    }
}

