/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._400_Configuration;

import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.CellConfigAttributes;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultBooleanDisplayConverter;
import org.eclipse.nebula.widgets.nattable.data.convert.DefaultDateDisplayConverter;
import org.eclipse.nebula.widgets.nattable.dataset.person.Person;
import org.eclipse.nebula.widgets.nattable.dataset.person.PersonService;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultBodyDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultColumnHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultRowHeaderDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.hover.HoverLayer;
import org.eclipse.nebula.widgets.nattable.hover.config.ColumnHeaderHoverLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.hover.config.RowHeaderHoverLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AggregateConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ColumnLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.NatTableBorderOverlayPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.CheckBoxPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.Style;
import org.eclipse.nebula.widgets.nattable.style.theme.DarkNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.DefaultNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.IThemeExtension;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class _423_ThemeStylingExample
extends AbstractNatExample {
    public static final String FEMALE_LABEL = "FemaleLabel";
    public static final String MALE_LABEL = "MaleLabel";

    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(650, 400, new _423_ThemeStylingExample());
    }

    @Override
    public String getDescription() {
        return "This example shows the usage of themes for styling a NatTable and how to switch themes at runtime.  It also shows how to deal with attributes that are not configurable via themes like row heights, column widths and ILayerPainter.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        String[] propertyNames = new String[]{"firstName", "lastName", "gender", "married", "birthday"};
        HashMap<String, String> propertyToLabelMap = new HashMap<String, String>();
        propertyToLabelMap.put("firstName", "Firstname");
        propertyToLabelMap.put("lastName", "Lastname");
        propertyToLabelMap.put("gender", "Gender");
        propertyToLabelMap.put("married", "Married");
        propertyToLabelMap.put("birthday", "Birthday");
        DefaultBodyDataProvider bodyDataProvider = new DefaultBodyDataProvider(PersonService.getPersons((int)10), propertyNames);
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)bodyDataProvider);
        HoverLayer bodyHoverLayer = new HoverLayer((IUniqueIndexLayer)bodyDataLayer);
        SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)bodyHoverLayer);
        ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
        AggregateConfigLabelAccumulator labelAccumulator = new AggregateConfigLabelAccumulator();
        labelAccumulator.add((IConfigLabelAccumulator)new ColumnLabelAccumulator());
        labelAccumulator.add(new IConfigLabelAccumulator((ListDataProvider)bodyDataProvider){
            private final /* synthetic */ ListDataProvider val$bodyDataProvider;
            {
                this.val$bodyDataProvider = listDataProvider;
            }

            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                Person p = (Person)this.val$bodyDataProvider.getRowObject(rowPosition);
                if (p != null) {
                    configLabels.addLabel(p.getGender().equals((Object)Person.Gender.FEMALE) ? _423_ThemeStylingExample.FEMALE_LABEL : _423_ThemeStylingExample.MALE_LABEL);
                }
            }
        });
        bodyDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)labelAccumulator);
        DefaultColumnHeaderDataProvider columnHeaderDataProvider = new DefaultColumnHeaderDataProvider(propertyNames, propertyToLabelMap);
        DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer((IDataProvider)columnHeaderDataProvider);
        HoverLayer columnHoverLayer = new HoverLayer((IUniqueIndexLayer)columnHeaderDataLayer, false);
        ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHoverLayer, (ILayer)viewportLayer, selectionLayer, false);
        columnHeaderLayer.addConfiguration((IConfiguration)new ColumnHeaderHoverLayerConfiguration(columnHoverLayer));
        DefaultRowHeaderDataProvider rowHeaderDataProvider = new DefaultRowHeaderDataProvider((IDataProvider)bodyDataProvider);
        DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer((IDataProvider)rowHeaderDataProvider);
        HoverLayer rowHoverLayer = new HoverLayer((IUniqueIndexLayer)rowHeaderDataLayer, false);
        RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHoverLayer, (ILayer)viewportLayer, selectionLayer, false);
        rowHeaderLayer.addConfiguration((IConfiguration)new RowHeaderHoverLayerConfiguration(rowHoverLayer));
        DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider((IDataProvider)columnHeaderDataProvider, (IDataProvider)rowHeaderDataProvider);
        DataLayer cornerDataLayer = new DataLayer((IDataProvider)cornerDataProvider);
        CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)cornerDataLayer, (ILayer)rowHeaderLayer, (ILayer)columnHeaderLayer);
        GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowHeaderLayer, (ILayer)cornerLayer);
        final NatTable natTable = new NatTable(container, (ILayer)gridLayer);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)natTable);
        natTable.addOverlayPainter((IOverlayPainter)new NatTableBorderOverlayPainter(natTable.getConfigRegistry()));
        Composite buttonPanel = new Composite(container, 0);
        buttonPanel.setLayout((Layout)new GridLayout(3, true));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)buttonPanel);
        DefaultNatTableThemeConfiguration defaultTheme = new DefaultNatTableThemeConfiguration();
        ModernNatTableThemeConfiguration modernTheme = new ModernNatTableThemeConfiguration();
        DarkNatTableThemeConfiguration darkTheme = new DarkNatTableThemeConfiguration();
        DefaultNatTableThemeConfiguration conditionalDefaultTheme = new DefaultNatTableThemeConfiguration();
        conditionalDefaultTheme.addThemeExtension((IThemeExtension)new ConditionalStylingThemeExtension());
        ModernNatTableThemeConfiguration conditionalModernTheme = new ModernNatTableThemeConfiguration();
        conditionalModernTheme.addThemeExtension((IThemeExtension)new ConditionalStylingThemeExtension());
        DarkNatTableThemeConfiguration conditionalDarkTheme = new DarkNatTableThemeConfiguration();
        conditionalDarkTheme.addThemeExtension((IThemeExtension)new ConditionalStylingThemeExtension());
        HoverThemeConfiguration hoverTheme = new HoverThemeConfiguration();
        FontStylingThemeConfiguration fontTheme = new FontStylingThemeConfiguration();
        Button defaultThemeButton = new Button(buttonPanel, 8);
        defaultThemeButton.setText("NatTable Default Theme");
        defaultThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)defaultTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$defaultTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$defaultTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$defaultTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button modernThemeButton = new Button(buttonPanel, 8);
        modernThemeButton.setText("NatTable Modern Theme");
        modernThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)modernTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$modernTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$modernTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$modernTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button darkThemeButton = new Button(buttonPanel, 8);
        darkThemeButton.setText("NatTable Dark Theme");
        darkThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)darkTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$darkTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$darkTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$darkTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button conditionalThemeButton = new Button(buttonPanel, 8);
        conditionalThemeButton.setText("Conditional Default Theme");
        conditionalThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)conditionalDefaultTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$conditionalDefaultTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$conditionalDefaultTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$conditionalDefaultTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button conditionalModernThemeButton = new Button(buttonPanel, 8);
        conditionalModernThemeButton.setText("Conditional Modern Theme");
        conditionalModernThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)conditionalModernTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$conditionalModernTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$conditionalModernTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$conditionalModernTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button conditionalDarkThemeButton = new Button(buttonPanel, 8);
        conditionalDarkThemeButton.setText("Conditional Dark Theme");
        conditionalDarkThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)conditionalDarkTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$conditionalDarkTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$conditionalDarkTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$conditionalDarkTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button hoverThemeButton = new Button(buttonPanel, 8);
        hoverThemeButton.setText("Hover Theme");
        hoverThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)hoverTheme, gridLayer, bodyDataLayer, (DataLayer)columnHeaderDataLayer){
            private final /* synthetic */ ThemeConfiguration val$hoverTheme;
            private final /* synthetic */ GridLayer val$gridLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            {
                this.val$hoverTheme = themeConfiguration;
                this.val$gridLayer = gridLayer;
                this.val$bodyDataLayer = dataLayer;
                this.val$columnHeaderDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$hoverTheme);
                _423_ThemeStylingExample.this.cleanupNonThemeSettings(this.val$gridLayer, this.val$bodyDataLayer, this.val$columnHeaderDataLayer);
            }
        });
        Button fontThemeButton = new Button(buttonPanel, 8);
        fontThemeButton.setText("Increased Font Theme");
        fontThemeButton.addSelectionListener((SelectionListener)new SelectionAdapter((ThemeConfiguration)fontTheme, (DataLayer)columnHeaderDataLayer, bodyDataLayer){
            private final /* synthetic */ ThemeConfiguration val$fontTheme;
            private final /* synthetic */ DataLayer val$columnHeaderDataLayer;
            private final /* synthetic */ DataLayer val$bodyDataLayer;
            {
                this.val$fontTheme = themeConfiguration;
                this.val$columnHeaderDataLayer = dataLayer;
                this.val$bodyDataLayer = dataLayer2;
            }

            public void widgetSelected(SelectionEvent e) {
                natTable.setTheme(this.val$fontTheme);
                this.val$columnHeaderDataLayer.setDefaultRowHeight(30);
                this.val$columnHeaderDataLayer.setDefaultColumnWidth(130);
                this.val$bodyDataLayer.setDefaultRowHeight(30);
                this.val$bodyDataLayer.setDefaultColumnWidth(130);
            }
        });
        return container;
    }

    private void cleanupNonThemeSettings(GridLayer gridLayer, DataLayer bodyDataLayer, DataLayer columnHeaderDataLayer) {
        columnHeaderDataLayer.setDefaultRowHeight(20);
        columnHeaderDataLayer.setDefaultColumnWidth(100);
        bodyDataLayer.setDefaultRowHeight(20);
        bodyDataLayer.setDefaultColumnWidth(100);
    }

    class ConditionalStylingThemeExtension
    implements IThemeExtension {
        ConditionalStylingThemeExtension() {
        }

        public void registerStyles(IConfigRegistry configRegistry) {
            Style femaleStyle = new Style();
            femaleStyle.setAttributeValue(CellStyleAttributes.BACKGROUND_COLOR, (Object)GUIHelper.COLOR_YELLOW);
            femaleStyle.setAttributeValue(CellStyleAttributes.FOREGROUND_COLOR, (Object)GUIHelper.COLOR_BLACK);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_STYLE, (Object)femaleStyle, "NORMAL", _423_ThemeStylingExample.FEMALE_LABEL);
            configRegistry.registerConfigAttribute(CellConfigAttributes.CELL_PAINTER, (Object)new CheckBoxPainter(), "NORMAL", "COLUMN_3");
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultBooleanDisplayConverter(), "NORMAL", "COLUMN_3");
            DateFormat formatter = DateFormat.getDateInstance(2, Locale.getDefault());
            String pattern = ((SimpleDateFormat)formatter).toPattern();
            configRegistry.registerConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, (Object)new DefaultDateDisplayConverter(pattern), "NORMAL", "COLUMN_4");
        }

        public void unregisterStyles(IConfigRegistry configRegistry) {
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_STYLE, "NORMAL", _423_ThemeStylingExample.FEMALE_LABEL);
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.CELL_PAINTER, "NORMAL", "COLUMN_3");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "NORMAL", "COLUMN_3");
            configRegistry.unregisterConfigAttribute(CellConfigAttributes.DISPLAY_CONVERTER, "NORMAL", "COLUMN_4");
        }
    }

    class FontStylingThemeConfiguration
    extends ModernNatTableThemeConfiguration {
        FontStylingThemeConfiguration() {
            this.defaultFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 15, 0)});
            this.defaultSelectionFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 15, 0)});
            this.cHeaderFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 18, 0)});
            this.cHeaderSelectionFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 18, 0)});
            this.rHeaderFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 18, 0)});
            this.rHeaderSelectionFont = GUIHelper.getFont((FontData[])new FontData[]{new FontData("Arial", 18, 0)});
            this.renderCornerGridLines = true;
            this.renderColumnHeaderGridLines = true;
        }
    }

    class HoverThemeConfiguration
    extends DefaultNatTableThemeConfiguration {
        HoverThemeConfiguration() {
            this.bodyHoverBgColor = GUIHelper.COLOR_YELLOW;
            this.bodyHoverSelectionBgColor = GUIHelper.COLOR_GREEN;
            this.rHeaderHoverBgColor = GUIHelper.COLOR_RED;
            this.rHeaderHoverSelectionBgColor = GUIHelper.COLOR_BLUE;
            Image bgImage = GUIHelper.getImageByURL((String)"columnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/column_header_bg.png"));
            Image hoverBgImage = GUIHelper.getImageByURL((String)"hoverColumnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/hovered_column_header_bg.png"));
            Image selectedBgImage = GUIHelper.getImageByURL((String)"selectedColumnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/selected_column_header_bg.png"));
            Image selectedHoveredBgImage = GUIHelper.getImageByURL((String)"selectedHoverColumnHeaderBg", (URL)((Object)((Object)this)).getClass().getResource("/org/eclipse/nebula/widgets/nattable/examples/resources/selected_hovered_column_header_bg.png"));
            TextPainter txtPainter = new TextPainter(false, false);
            BackgroundImagePainter bgImagePainter = new BackgroundImagePainter((ICellPainter)txtPainter, bgImage);
            this.cHeaderCellPainter = bgImagePainter;
            this.cornerCellPainter = bgImagePainter;
            this.cHeaderSelectionCellPainter = new BackgroundImagePainter((ICellPainter)txtPainter, selectedBgImage);
            this.cHeaderHoverCellPainter = new BackgroundImagePainter((ICellPainter)txtPainter, hoverBgImage);
            this.cHeaderHoverSelectionCellPainter = new BackgroundImagePainter((ICellPainter)txtPainter, selectedHoveredBgImage);
            this.renderCornerGridLines = true;
            this.renderColumnHeaderGridLines = true;
        }
    }
}

