/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples._300_Data;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.examples.AbstractNatExample;
import org.eclipse.nebula.widgets.nattable.examples.runner.StandaloneNatExampleRunner;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class _301_CustomDataProviderExample
extends AbstractNatExample {
    public static void main(String[] args) throws Exception {
        StandaloneNatExampleRunner.run(600, 400, new _301_CustomDataProviderExample());
    }

    @Override
    public String getDescription() {
        return "This is an example to show how to implement a custom IDataProvider that operates on a two-dimensional array of Strings.";
    }

    @Override
    public Control createExampleControl(Composite parent) {
        String[][] testData = new String[10][10];
        int i = 0;
        while (i < 10) {
            int j = 0;
            while (j < 10) {
                testData[i][j] = i + "/" + j;
                ++j;
            }
            ++i;
        }
        DataLayer bodyDataLayer = new DataLayer((IDataProvider)new TwoDimensionalArrayDataProvider(testData));
        bodyDataLayer.setDefaultColumnWidth(30);
        NatTable natTable = new NatTable(parent, 538181632, (ILayer)bodyDataLayer);
        return natTable;
    }

    class TwoDimensionalArrayDataProvider
    implements IDataProvider {
        private String[][] data;

        public TwoDimensionalArrayDataProvider(String[][] data) {
            this.data = data;
        }

        public Object getDataValue(int columnIndex, int rowIndex) {
            return this.data[columnIndex][rowIndex];
        }

        public void setDataValue(int columnIndex, int rowIndex, Object newValue) {
            this.data[columnIndex][rowIndex] = newValue != null ? newValue.toString() : null;
        }

        public int getColumnCount() {
            return this.data.length;
        }

        public int getRowCount() {
            return this.data[0] != null ? this.data[0].length : 0;
        }
    }
}

