/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.examples;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.examples.runner.TabbedNatExampleRunner;

public class NatTableExamples {
    public static void main(String[] args) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        if (args.length == 0) {
            List<Object> examples;
            InputStream inputStream = NatTableExamples.class.getResourceAsStream("/examples.index");
            if (inputStream != null) {
                examples = new ArrayList();
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                String line = reader.readLine();
                while (line != null) {
                    examples.add(line);
                    line = reader.readLine();
                }
                reader.close();
            } else {
                System.out.println("examples.index not found, reconstructing");
                examples = NatTableExamples.createExamplesIndex(null);
            }
            TabbedNatExampleRunner.run(examples.toArray(new String[0]));
        } else if (args.length == 2 && "--createIndex".equals(args[0])) {
            System.out.println("Creating examples.index");
            System.out.println("basedir: " + args[1]);
            NatTableExamples.createExamplesIndex(args[1]);
        } else {
            System.out.println("Usage: NatTableExamples [--createIndex <basedir>]");
        }
    }

    private static List<String> createExamplesIndex(String basedir) throws IOException {
        ArrayList<String> examples = new ArrayList<String>();
        File examplesDir = new File(basedir, "src/org/eclipse/nebula/widgets/nattable/examples");
        NatTableExamples.findTutorialExamples(examplesDir, examples);
        examplesDir = new File(basedir, "src/org/eclipse/nebula/widgets/nattable/examples/examples");
        NatTableExamples.findExamples(examplesDir, examples, "Classic Examples/");
        File examplesIndexFile = new File(new File(basedir, "src"), "examples.index");
        BufferedWriter writer = new BufferedWriter(new FileWriter(examplesIndexFile));
        for (String example : examples) {
            writer.write(String.valueOf(example) + "\n");
        }
        writer.flush();
        writer.close();
        return examples;
    }

    private static void findTutorialExamples(File dir, List<String> examples) throws IOException {
        FilenameFilter packageFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.matches("_\\d{3}.*");
            }
        };
        List<String> sortedList = Arrays.asList(dir.list(packageFilter));
        Collections.sort(sortedList);
        for (String packageName : sortedList) {
            File f = new File(dir, packageName);
            if (!f.isDirectory()) continue;
            NatTableExamples.findExamples(f, examples, "Tutorial Examples/");
        }
    }

    private static void findExamples(File dir, List<String> examples, String prefix) throws IOException {
        List<String> sortedList = Arrays.asList(dir.list());
        Collections.sort(sortedList);
        for (String s : sortedList) {
            File f = new File(dir, s);
            if (f.isDirectory()) {
                NatTableExamples.findExamples(f, examples, prefix);
                continue;
            }
            String examplePath = String.valueOf(dir.getCanonicalPath()) + File.separator + s;
            if (!(examplePath = examplePath.replace(File.separator, "/")).endsWith(".java")) continue;
            examplePath = examplePath.replaceAll("^.*/src/", "").replaceAll("\\.java$", "");
            examples.add(String.valueOf(prefix) + examplePath);
        }
    }
}

