/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeRowModel<T>
implements ITreeRowModel<T> {
    private final HashSet<Integer> parentIndexes = new HashSet();
    private final Collection<ITreeRowModelListener> listeners = new HashSet<ITreeRowModelListener>();
    private final ITreeData<T> treeData;

    public TreeRowModel(ITreeData<T> treeData) {
        this.treeData = treeData;
    }

    public void registerRowGroupModelListener(ITreeRowModelListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (ITreeRowModelListener listener : this.listeners) {
            listener.treeRowModelChanged();
        }
    }

    @Override
    public int depth(int index) {
        return this.treeData.getDepthOfData(this.treeData.getDataAtIndex(index));
    }

    @Override
    public boolean isLeaf(int index) {
        return !this.hasChildren(index);
    }

    @Override
    public String getObjectAtIndexAndDepth(int index, int depth) {
        return this.treeData.formatDataForDepth(depth, this.treeData.getDataAtIndex(index));
    }

    @Override
    public boolean hasChildren(int index) {
        return this.treeData.hasChildren(this.treeData.getDataAtIndex(index));
    }

    @Override
    public boolean isCollapsed(int index) {
        return this.parentIndexes.contains(index);
    }

    public void clear() {
        this.parentIndexes.clear();
    }

    public boolean isCollapseable(int index) {
        return this.hasChildren(index);
    }

    @Override
    public List<Integer> collapse(int index) {
        this.parentIndexes.add(index);
        this.notifyListeners();
        return this.getChildIndexes(index);
    }

    @Override
    public List<Integer> expand(int index) {
        this.parentIndexes.remove(index);
        this.notifyListeners();
        List<Integer> children = this.getChildIndexes(index);
        this.parentIndexes.removeAll(children);
        return children;
    }

    public List<Integer> getChildIndexes(int parentIndex) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        List<T> children = this.treeData.getChildren(this.treeData.getDataAtIndex(parentIndex));
        for (T child : children) {
            int index = this.treeData.indexOf(child);
            result.add(index);
            result.addAll(this.getChildIndexes(index));
        }
        return result;
    }
}

