/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.edit;

import java.util.List;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.edit.ActiveCellEditor;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.EditTypeEnum;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.edit.command.UpdateDataCommand;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.event.InlineCellEditEvent;
import org.eclipse.nebula.widgets.nattable.edit.gui.MultiCellEditDialog;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.tickupdate.ITickUpdateHandler;
import org.eclipse.nebula.widgets.nattable.tickupdate.TickUpdateConfigAttributes;
import org.eclipse.swt.widgets.Composite;

public class MultiCellEditController {
    public static boolean editSelectedCells(SelectionLayer selectionLayer, Character initialEditValue, Composite parent, IConfigRegistry configRegistry, boolean useAdjustOnMultiEdit) {
        ILayerCell lastSelectedCell = EditUtils.getLastSelectedCell(selectionLayer);
        if (lastSelectedCell != null) {
            List<String> lastSelectedCellLabelsArray = lastSelectedCell.getConfigLabels().getLabels();
            PositionCoordinate[] selectedCells = selectionLayer.getSelectedCellPositions();
            if (selectedCells.length > 1) {
                ICellEditor lastSelectedCellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
                if (EditUtils.isEditorSame(selectionLayer, configRegistry, lastSelectedCellEditor) && EditUtils.allCellsEditable(selectionLayer, configRegistry)) {
                    ICellEditor cellEditor = configRegistry.getConfigAttribute(EditConfigAttributes.CELL_EDITOR, "EDIT", lastSelectedCellLabelsArray);
                    ITickUpdateHandler tickUpdateHandler = configRegistry.getConfigAttribute(TickUpdateConfigAttributes.UPDATE_HANDLER, "EDIT", lastSelectedCellLabelsArray);
                    boolean allowIncrementDecrement = tickUpdateHandler != null;
                    Object originalCanonicalValue = lastSelectedCell.getDataValue();
                    PositionCoordinate[] positionCoordinateArray = selectedCells;
                    int n = selectedCells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PositionCoordinate selectedCell = positionCoordinateArray[n2];
                        Object cellValue = selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition).getDataValue();
                        boolean bl = allowIncrementDecrement = allowIncrementDecrement && tickUpdateHandler.isApplicableFor(cellValue);
                        if (cellValue != null && !cellValue.equals(originalCanonicalValue)) {
                            originalCanonicalValue = null;
                            break;
                        }
                        ++n2;
                    }
                    MultiCellEditDialog dialog = new MultiCellEditDialog(parent.getShell(), cellEditor, originalCanonicalValue, initialEditValue, allowIncrementDecrement, configRegistry, lastSelectedCell);
                    int returnValue = dialog.open();
                    ActiveCellEditor.close();
                    if (returnValue == 0) {
                        Object editorValue;
                        Object newValue = editorValue = dialog.getEditorValue();
                        PositionCoordinate[] positionCoordinateArray2 = selectedCells;
                        int n3 = selectedCells.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PositionCoordinate selectedCell = positionCoordinateArray2[n4];
                            if (allowIncrementDecrement) {
                                double delta = editorValue instanceof Number ? ((Number)editorValue).doubleValue() : Double.valueOf((String)editorValue).doubleValue();
                                originalCanonicalValue = selectionLayer.getCellByPosition(selectedCell.columnPosition, selectedCell.rowPosition).getDataValue();
                                EditTypeEnum editType = dialog.getEditType();
                                if (editType == EditTypeEnum.ADJUST) {
                                    editType = delta >= 0.0 ? EditTypeEnum.INCREASE : EditTypeEnum.DECREASE;
                                }
                                switch (editType) {
                                    case INCREASE: {
                                        newValue = tickUpdateHandler.getIncrementedValue(originalCanonicalValue, delta);
                                        break;
                                    }
                                    case DECREASE: {
                                        newValue = tickUpdateHandler.getDecrementedValue(originalCanonicalValue, delta);
                                        break;
                                    }
                                }
                            }
                            selectionLayer.doCommand(new UpdateDataCommand(selectionLayer, selectedCell.columnPosition, selectedCell.rowPosition, newValue));
                            ++n4;
                        }
                    }
                }
            } else {
                selectionLayer.fireLayerEvent(new InlineCellEditEvent(selectionLayer, new PositionCoordinate(selectionLayer, lastSelectedCell.getColumnPosition(), lastSelectedCell.getRowPosition()), parent, configRegistry, initialEditValue));
            }
            return true;
        }
        return false;
    }
}

