/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.serializer.acceptor;

import java.util.Stack;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Action;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.serializer.acceptor.DelegatingSequenceAcceptor;
import org.eclipse.xtext.serializer.acceptor.ISequenceAcceptor;

public class WhitespaceAddingSequenceAcceptor
extends DelegatingSequenceAcceptor {
    protected AbstractRule lastWhitespace = null;
    protected Stack<RuleCall> ruleCalls = new Stack();

    @Override
    public void acceptAssignedCrossRefDatatype(RuleCall rc, String token, EObject value, int index, ICompositeNode node) {
        this.writeWhitespace(rc);
        super.acceptAssignedCrossRefDatatype(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefEnum(RuleCall enumRC, String token, EObject value, int index, ICompositeNode node) {
        this.writeWhitespace(enumRC);
        super.acceptAssignedCrossRefEnum(enumRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefKeyword(Keyword kw, String token, EObject value, int index, ILeafNode node) {
        this.writeWhitespace(kw);
        super.acceptAssignedCrossRefKeyword(kw, token, value, index, node);
    }

    @Override
    public void acceptAssignedCrossRefTerminal(RuleCall rc, String token, EObject value, int index, ILeafNode node) {
        this.writeWhitespace(rc);
        super.acceptAssignedCrossRefTerminal(rc, token, value, index, node);
    }

    @Override
    public void acceptAssignedDatatype(RuleCall datatypeRC, String token, Object value, int index, ICompositeNode node) {
        this.writeWhitespace(datatypeRC);
        super.acceptAssignedDatatype(datatypeRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedEnum(RuleCall enumRC, String token, Object value, int index, ICompositeNode node) {
        this.writeWhitespace(enumRC);
        super.acceptAssignedEnum(enumRC, token, value, index, node);
    }

    @Override
    public void acceptAssignedKeyword(Keyword keyword, String token, Object value, int index, ILeafNode node) {
        this.writeWhitespace(keyword);
        super.acceptAssignedKeyword(keyword, token, value, index, node);
    }

    @Override
    public void acceptAssignedTerminal(RuleCall terminalRC, String token, Object value, int index, ILeafNode node) {
        this.writeWhitespace(terminalRC);
        super.acceptAssignedTerminal(terminalRC, token, value, index, node);
    }

    @Override
    public void acceptUnassignedAction(Action action) {
        this.writeWhitespace(action);
        super.acceptUnassignedAction(action);
    }

    @Override
    public void acceptUnassignedDatatype(RuleCall datatypeRC, String value, ICompositeNode node) {
        this.writeWhitespace(datatypeRC);
        super.acceptUnassignedDatatype(datatypeRC, value, node);
    }

    @Override
    public void acceptUnassignedEnum(RuleCall enumRC, String value, ICompositeNode node) {
        this.writeWhitespace(enumRC);
        super.acceptUnassignedEnum(enumRC, value, node);
    }

    @Override
    public void acceptUnassignedKeyword(Keyword keyword, String token, ILeafNode node) {
        this.writeWhitespace(keyword);
        super.acceptUnassignedKeyword(keyword, token, node);
    }

    @Override
    public void acceptUnassignedTerminal(RuleCall terminalRC, String value, ILeafNode node) {
        this.writeWhitespace(terminalRC);
        super.acceptUnassignedTerminal(terminalRC, value, node);
    }

    @Override
    public boolean enterAssignedParserRuleCall(RuleCall rc, EObject newCurrent, ICompositeNode node) {
        this.ruleCalls.push(rc);
        return super.enterAssignedParserRuleCall(rc, newCurrent, node);
    }

    @Override
    public void enterUnassignedParserRuleCall(RuleCall rc) {
        this.ruleCalls.push(rc);
        super.enterUnassignedParserRuleCall(rc);
    }

    protected AbstractRule findWhitespaceRule(AbstractElement ele) {
        int i = this.ruleCalls.size() - 1;
        while (i >= 0) {
            ParserRule pr;
            AbstractRule rule = ((RuleCall)this.ruleCalls.get(i)).getRule();
            if (rule instanceof ParserRule && (pr = (ParserRule)rule).isDefinesHiddenTokens()) {
                for (AbstractRule hidden : pr.getHiddenTokens()) {
                    if (!this.isWhitespaceRule(hidden)) continue;
                    return hidden;
                }
                return null;
            }
            --i;
        }
        if (this.ruleCalls.isEmpty()) {
            return this.findWhitespaceRule(GrammarUtil.getGrammar(ele));
        }
        return this.findWhitespaceRule(GrammarUtil.getGrammar((EObject)this.ruleCalls.get(0)));
    }

    protected AbstractRule findWhitespaceRule(Grammar grammar) {
        for (AbstractRule hidden : grammar.getHiddenTokens()) {
            if (!this.isWhitespaceRule(hidden)) continue;
            return hidden;
        }
        if (!grammar.getUsedGrammars().isEmpty()) {
            return this.findWhitespaceRule((Grammar)grammar.getUsedGrammars().get(0));
        }
        return null;
    }

    protected boolean isWhitespaceRule(AbstractRule rule) {
        return "WS".equals(rule.getName());
    }

    @Override
    public void leaveAssignedParserRuleCall(RuleCall rc, EObject semanticChild) {
        this.ruleCalls.pop();
        super.leaveAssignedParserRuleCall(rc, semanticChild);
    }

    @Override
    public void leaveUnssignedParserRuleCall(RuleCall rc) {
        this.ruleCalls.pop();
        super.leaveUnssignedParserRuleCall(rc);
    }

    protected void writeWhitespace(AbstractElement ele) {
        if (this.lastWhitespace != null) {
            this.lastWhitespace = this.findWhitespaceRule(ele);
            if (this.lastWhitespace != null) {
                ((ISequenceAcceptor)this.getDelegate()).acceptWhitespace(this.lastWhitespace, " ", null);
            }
        } else {
            this.lastWhitespace = this.findWhitespaceRule(ele);
        }
    }
}

