/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.codemining;

import com.google.common.annotations.Beta;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineContentCodeMining;
import org.eclipse.jface.text.codemining.LineHeaderCodeMining;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocumentUtil;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.concurrent.CancelableUnitOfWork;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

@Beta
public abstract class AbstractXtextCodeMiningProvider
extends AbstractCodeMiningProvider {
    @Inject
    private XtextDocumentUtil xtextDocumentUtil;

    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(final ITextViewer viewer, final IProgressMonitor monitor) {
        CompletableFuture<List<? extends ICodeMining>> future = CompletableFuture.supplyAsync(() -> {
            CancelableUnitOfWork<List<ICodeMining>, XtextResource> uow = new CancelableUnitOfWork<List<ICodeMining>, XtextResource>(){

                public List<ICodeMining> exec(XtextResource resource, CancelIndicator uowCancelIndicator) throws Exception {
                    CombinedCancelIndicator indicator = new CombinedCancelIndicator(monitor, uowCancelIndicator);
                    return AbstractXtextCodeMiningProvider.this.createCodeMinings(viewer.getDocument(), resource, indicator);
                }
            };
            return (List)this.xtextDocumentUtil.getXtextDocument(viewer).tryReadOnly((IUnitOfWork)uow, () -> Collections.emptyList());
        });
        return future;
    }

    protected List<ICodeMining> createCodeMinings(IDocument document, XtextResource resource, final CancelIndicator cancelIndicator) throws BadLocationException {
        final ArrayList<ICodeMining> codeMiningList = new ArrayList<ICodeMining>();
        IAcceptor<ICodeMining> acceptor = new IAcceptor<ICodeMining>(){

            public void accept(ICodeMining codeMiningObject) {
                if (cancelIndicator.isCanceled()) {
                    throw new CancellationException();
                }
                codeMiningList.add(codeMiningObject);
            }
        };
        this.createCodeMinings(document, resource, cancelIndicator, (IAcceptor<? super ICodeMining>)acceptor);
        return codeMiningList;
    }

    protected abstract void createCodeMinings(IDocument var1, XtextResource var2, CancelIndicator var3, IAcceptor<? super ICodeMining> var4) throws BadLocationException;

    protected LineContentCodeMining createNewLineContentCodeMining(int beforeCharacter, String contentText) {
        return this.createNewLineContentCodeMining(beforeCharacter, contentText, null);
    }

    protected LineContentCodeMining createNewLineContentCodeMining(int beforeCharacter, final String contentText, Consumer<MouseEvent> action) {
        return new LineContentCodeMining(new Position(beforeCharacter, 1), (ICodeMiningProvider)this, action){

            protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.runAsync(() -> super.setLabel(contentText));
            }
        };
    }

    protected LineHeaderCodeMining createNewLineHeaderCodeMining(int beforeLineNumber, IDocument document, String headerText) throws BadLocationException {
        return this.createNewLineHeaderCodeMining(beforeLineNumber, document, headerText, null);
    }

    protected LineHeaderCodeMining createNewLineHeaderCodeMining(int beforeLineNumber, IDocument document, final String headerText, Consumer<MouseEvent> action) throws BadLocationException {
        return new LineHeaderCodeMining(beforeLineNumber, document, (ICodeMiningProvider)this, action){

            protected CompletableFuture<Void> doResolve(ITextViewer viewer, IProgressMonitor monitor) {
                return CompletableFuture.runAsync(() -> super.setLabel(headerText));
            }
        };
    }

    private static class CombinedCancelIndicator
    implements CancelIndicator {
        private IProgressMonitor monitor;
        private CancelIndicator uowCancelIndicator;

        public CombinedCancelIndicator(IProgressMonitor monitor, CancelIndicator uowCancelIndicator) {
            this.monitor = monitor;
            this.uowCancelIndicator = uowCancelIndicator;
        }

        public boolean isCanceled() {
            return this.uowCancelIndicator != null && this.uowCancelIndicator.isCanceled() || this.monitor != null && this.monitor.isCanceled();
        }
    }
}

