/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.EmfUtilUiPlugin;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ui.choosers.IMetamodelHandler;

public class MetamodelHandlerManager {
    private Map<String, IMetamodelHandler> myHandlers = null;
    private static final MetamodelHandlerManager ourInstance = new MetamodelHandlerManager();
    private static final String POINT = "metamodelHandler";

    private MetamodelHandlerManager() {
    }

    public static MetamodelHandlerManager getInstance() {
        return ourInstance;
    }

    public IMetamodelHandler[] getHandlers() {
        LinkedHashSet<IMetamodelHandler> handlers = new LinkedHashSet<IMetamodelHandler>();
        if (this.myHandlers == null) {
            this.myHandlers = MetamodelHandlerManager.computeHandlers();
        }
        handlers.addAll(this.myHandlers.values());
        return handlers.toArray(new IMetamodelHandler[handlers.size()]);
    }

    public IMetamodelHandler getHandler(EClassifier cls) {
        String uri = EmfUtil.getRootPackage((EPackage)cls.getEPackage()).getNsURI();
        return this.getHandler(uri);
    }

    public IMetamodelHandler getHandler(String uri) {
        IMetamodelHandler handler;
        if (this.myHandlers == null) {
            this.myHandlers = MetamodelHandlerManager.computeHandlers();
        }
        if ((handler = this.myHandlers.get(uri)) == null && (handler = this.myHandlers.get("*")) == null) {
            throw new RuntimeException("No default handler for metamodelHandler");
        }
        return handler;
    }

    private static Map<String, IMetamodelHandler> computeHandlers() {
        String pluginId = EmfUtilUiPlugin.getDefault().getBundle().getSymbolicName();
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(pluginId, POINT);
        if (elements.length == 0) {
            throw new RuntimeException("No extension for " + pluginId + "." + POINT);
        }
        HashMap<String, IMetamodelHandler> handlers = new HashMap<String, IMetamodelHandler>();
        int j = 0;
        while (j < elements.length) {
            try {
                Object instance = elements[j].createExecutableExtension("class");
                if (instance instanceof IMetamodelHandler) {
                    IMetamodelHandler handler = (IMetamodelHandler)instance;
                    IConfigurationElement[] metamodels = elements[j].getChildren("package");
                    int i = 0;
                    while (i < metamodels.length) {
                        IConfigurationElement metamodel = metamodels[i];
                        String uri = metamodel.getAttribute("uri");
                        handlers.put(uri, handler);
                        ++i;
                    }
                }
            }
            catch (Exception e) {
                Logger.getLogger().log(Logger.SEVERE, "Faile to instantiate metamodel handler for " + elements[j], e);
            }
            ++j;
        }
        return handlers;
    }
}

