/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.diagram.common.parser.instance;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.diagram.parser.AbstractToString;
import org.eclipse.uml2.diagram.parser.ExternalToString;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public abstract class InstanceSpecificationToString
extends AbstractToString {
    public String getToString(EObject object, int flags) {
        InstanceSpecification instance = this.asInstanceSpecification(object);
        StringBuffer result = new StringBuffer();
        this.appendName(result, (NamedElement)instance);
        InstanceSpecificationToString.appendType((StringBuffer)result, (String)this.getClassifiers(instance));
        if (result.length() == 0) {
            result.append(":");
        }
        return result.toString();
    }

    protected final String getClassifiers(InstanceSpecification instance) {
        StringBuffer result = new StringBuffer();
        boolean atLeastOneClassifier = false;
        for (Classifier next : instance.getClassifiers()) {
            String nextName;
            if (atLeastOneClassifier) {
                result.append(", ");
            }
            if (InstanceSpecificationToString.isEmpty((String)(nextName = next.getName()))) continue;
            atLeastOneClassifier = true;
            result.append(nextName);
        }
        return result.toString();
    }

    protected InstanceSpecification asInstanceSpecification(EObject object) {
        if (!(object instanceof InstanceSpecification)) {
            throw new IllegalStateException("I can not provide toString for: " + object);
        }
        return (InstanceSpecification)object;
    }

    public static class EDIT
    extends InstanceSpecificationToString {
        public boolean isAffectingFeature(EStructuralFeature feature) {
            throw new UnsupportedOperationException("I am edit toString, I am not expected to be asked");
        }
    }

    public static class VIEW
    extends InstanceSpecificationToString
    implements ExternalToString.WithReferences {
        private static final List AFFECTING = Arrays.asList(UMLPackage.eINSTANCE.getNamedElement_Name(), UMLPackage.eINSTANCE.getInstanceSpecification_Classifier());

        public boolean isAffectingFeature(EStructuralFeature feature) {
            return AFFECTING.contains(feature);
        }

        public List getAdditionalReferencedElements(EObject object) {
            InstanceSpecification instance = this.asInstanceSpecification(object);
            LinkedList<InstanceSpecification> result = new LinkedList<InstanceSpecification>();
            result.add(instance);
            result.addAll((Collection<InstanceSpecification>)instance.getClassifiers());
            return result;
        }
    }
}

