/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.core.internal.transcriber;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractList;
import org.eclipse.papyrus.model2doc.core.builtintypes.AbstractTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicList;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicRow;
import org.eclipse.papyrus.model2doc.core.builtintypes.BasicTable;
import org.eclipse.papyrus.model2doc.core.builtintypes.BuiltInTypesFactory;
import org.eclipse.papyrus.model2doc.core.builtintypes.CellLocation;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextCell;
import org.eclipse.papyrus.model2doc.core.builtintypes.TextListItem;
import org.eclipse.papyrus.model2doc.core.service.DiagramToImageService;
import org.eclipse.papyrus.model2doc.core.service.DiagramToImageServiceImpl;
import org.eclipse.papyrus.model2doc.core.transcriber.Transcriber;
import org.eclipse.papyrus.model2doc.core.transcription.ImageDescription;
import org.eclipse.papyrus.model2doc.core.transcription.Transcription;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

public class UMLTranscriber
implements Transcriber {
    private Package root = null;
    private Transcription transcription = null;
    private List<Class> classes = new ArrayList<Class>();
    private UMLLabelInternationalization umlLabelInternationalization = null;
    private String imageOutputFolder = null;
    private DiagramToImageService diagramToImageService = new DiagramToImageServiceImpl();

    public UMLTranscriber(Package rootPackage, Transcription transcription) {
        this.root = rootPackage;
        this.transcription = transcription;
        this.umlLabelInternationalization = UMLLabelInternationalization.getInstance();
        this.imageOutputFolder = transcription.getGeneratorConfig().getDocumentFolder();
    }

    @Override
    public void transcribe() {
        this.transcription.writeDocumentMainTitle(this.umlLabelInternationalization.getLabel((NamedElement)this.root));
        this.transcription.writeTableOfContents("Table Of Contents");
        List<ImageDescription> images = this.diagramToImageService.getImagesOfDiagrams((Element)this.root, this.imageOutputFolder);
        for (ImageDescription image : images) {
            this.transcription.importImage(image, image.getSubtitle());
        }
        this.transcribeClasses(this.root);
        BasicTable table = BuiltInTypesFactory.eINSTANCE.createBasicTable();
        BasicRow columnHeaderRow = BuiltInTypesFactory.eINSTANCE.createBasicRow();
        table.getRows().add((Object)columnHeaderRow);
        TextCell cornerCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
        cornerCell.setText("");
        cornerCell.setLocation(CellLocation.CORNER);
        columnHeaderRow.getCells().add((Object)cornerCell);
        TextCell columnHeaderPackageCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
        columnHeaderRow.getCells().add((Object)columnHeaderPackageCell);
        columnHeaderPackageCell.setText("Packages");
        columnHeaderPackageCell.setLocation(CellLocation.COLUMN_HEADER);
        TextCell columnHeaderClassedCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
        columnHeaderRow.getCells().add((Object)columnHeaderClassedCell);
        columnHeaderClassedCell.setText("Classes");
        columnHeaderClassedCell.setLocation(CellLocation.COLUMN_HEADER);
        Iterator packIter = this.root.getNestedPackages().iterator();
        int nbRow = 0;
        while (packIter.hasNext()) {
            ++nbRow;
            Package nestedPackage = (Package)packIter.next();
            BasicRow row = BuiltInTypesFactory.eINSTANCE.createBasicRow();
            table.getRows().add((Object)row);
            TextCell rowHeaderCell = BuiltInTypesFactory.eINSTANCE.createTextCell();
            row.getCells().add((Object)rowHeaderCell);
            rowHeaderCell.setText(Integer.toString(nbRow));
            rowHeaderCell.setLocation(CellLocation.ROW_HEADER);
            TextCell packageCellBody = BuiltInTypesFactory.eINSTANCE.createTextCell();
            row.getCells().add((Object)packageCellBody);
            packageCellBody.setText(this.umlLabelInternationalization.getLabel((NamedElement)nestedPackage));
            packageCellBody.setLocation(CellLocation.BODY);
            TextCell classesCellBody = BuiltInTypesFactory.eINSTANCE.createTextCell();
            row.getCells().add((Object)classesCellBody);
            StringBuilder builder = new StringBuilder();
            Iterator classIterator = nestedPackage.getOwnedTypes().stream().filter(Class.class::isInstance).map(Class.class::cast).collect(Collectors.toList()).iterator();
            while (classIterator.hasNext()) {
                Class current = (Class)classIterator.next();
                builder.append(this.umlLabelInternationalization.getLabel((NamedElement)current));
                if (!classIterator.hasNext()) continue;
                builder.append(", ");
            }
            classesCellBody.setText(builder.toString());
            classesCellBody.setLocation(CellLocation.BODY);
        }
        this.transcription.writeTable((AbstractTable)table);
        for (Package nestedPackage : this.root.getNestedPackages()) {
            this.transcribeNestedPackages(nestedPackage, 1);
        }
        this.transcription.refreshTableOfContents();
        this.transcription.save(this.umlLabelInternationalization.getLabel((NamedElement)this.root));
    }

    private void transcribeNestedPackages(Package owner, int level) {
        this.transcription.writeSectionTitle(this.umlLabelInternationalization.getLabel((NamedElement)owner), level);
        List<ImageDescription> images = this.diagramToImageService.getImagesOfDiagrams((Element)owner, this.imageOutputFolder);
        for (ImageDescription image : images) {
            this.transcription.importImage(image, image.getSubtitle());
        }
        this.transcribeClasses(owner);
        for (Package nestedPackage : owner.getNestedPackages()) {
            this.transcribeNestedPackages(nestedPackage, level + 1);
        }
    }

    private void transcribeClasses(Package owner) {
        for (Type type : owner.getOwnedTypes()) {
            if (!(type instanceof Class)) continue;
            this.classes.add((Class)type);
        }
        for (Class clazz : this.classes) {
            this.transcription.writeParagraph(this.umlLabelInternationalization.getLabel((NamedElement)clazz), false);
            this.transcribeProperties(clazz);
            List<ImageDescription> images = this.diagramToImageService.getImagesOfDiagrams((Element)clazz, this.imageOutputFolder);
            for (ImageDescription image : images) {
                this.transcription.importImage(image, image.getSubtitle());
            }
        }
        this.classes.clear();
    }

    private void transcribeProperties(Class owner) {
        ArrayList<TextListItem> items = new ArrayList<TextListItem>();
        for (Property property : owner.getOwnedAttributes()) {
            TextListItem item = BuiltInTypesFactory.eINSTANCE.createTextListItem();
            item.setText(this.umlLabelInternationalization.getLabel((NamedElement)property));
            items.add(item);
        }
        if (items.size() > 0) {
            BasicList list = BuiltInTypesFactory.eINSTANCE.createBasicList();
            list.getItems().addAll(items);
            this.transcription.writeList((AbstractList)list, false);
        }
    }
}

