/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.model2doc.documentview.ui.internal.viewpoint.helper;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.papyrus.infra.architecture.ArchitectureDomainManager;
import org.eclipse.papyrus.infra.architecture.representation.PapyrusRepresentationKind;
import org.eclipse.papyrus.infra.viewpoints.policy.IViewTypeHelper;
import org.eclipse.papyrus.infra.viewpoints.policy.PolicyChecker;
import org.eclipse.papyrus.infra.viewpoints.policy.ViewPrototype;
import org.eclipse.papyrus.model2doc.documentview.Document;
import org.eclipse.papyrus.model2doc.documentview.representation.PapyrusDocument;
import org.eclipse.papyrus.model2doc.documentview.representation.RepresentationPackage;
import org.eclipse.papyrus.model2doc.documentview.ui.Activator;
import org.eclipse.papyrus.model2doc.documentview.ui.internal.viewpoint.prototype.PapyrusDocumentViewPrototype;
import org.eclipse.papyrus.model2doc.documentview.ui.menu.handler.CreateDocumentViewEditorHandler;

public class CreatePapyrusDocumentViewTypeCommandHelper
implements IViewTypeHelper {
    private Map<PapyrusRepresentationKind, PapyrusDocumentViewPrototype> cache;

    public boolean isSupported(EClass type) {
        return EcoreUtil.equals((EObject)type, (EObject)RepresentationPackage.eINSTANCE.getPapyrusDocument());
    }

    public boolean isSupported(EObject view) {
        return view instanceof Document;
    }

    public ViewPrototype getPrototypeFor(PapyrusRepresentationKind kind) {
        CreateDocumentViewEditorHandler command;
        if (!(kind instanceof PapyrusDocument)) {
            return null;
        }
        PapyrusDocument papyrusDocument = (PapyrusDocument)kind;
        if (this.cache == null) {
            this.cache = new HashMap<PapyrusRepresentationKind, PapyrusDocumentViewPrototype>();
        }
        if (this.cache.containsKey(papyrusDocument)) {
            return this.cache.get(papyrusDocument);
        }
        Class creationCommandClass = papyrusDocument.getCreationCommandClass();
        try {
            command = (CreateDocumentViewEditorHandler)((Object)creationCommandClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            Activator.log.error((Throwable)e);
            return null;
        }
        PapyrusDocumentViewPrototype proto = new PapyrusDocumentViewPrototype(papyrusDocument, command);
        this.cache.put((PapyrusRepresentationKind)papyrusDocument, proto);
        return proto;
    }

    public ViewPrototype getPrototypeOf(EObject view) {
        if (!this.isSupported(view)) {
            return null;
        }
        PolicyChecker checker = PolicyChecker.getFor((EObject)view);
        ArchitectureDomainManager manager = ArchitectureDomainManager.getInstance();
        PapyrusDocument repKind = (PapyrusDocument)manager.getRepresentationKindById(((Document)view).getDocumentRepresentationKindId());
        if (repKind != null && checker.isInViewpoint((PapyrusRepresentationKind)repKind)) {
            return this.getPrototypeFor((PapyrusRepresentationKind)repKind);
        }
        return ViewPrototype.UNAVAILABLE_VIEW;
    }
}

