/**
 * Copyright (c) 2018 CEA
 * 
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *   Jrmie Tatibouet (CEA) jeremie.tatibouet@cea.fr - Initial API and implementation
 *   Benoit Maggi (CEA) benoit.maggi@cea.fr - Initial API and implementation
 * 
 */
package  org.eclipse.papyrus.iotml.hardware.actuator;

import org.eclipse.papyrus.MARTE.MARTE_DesignModel.HRM.HwLogical.HwDevice.HWActuator;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Hw Common Actuator</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * </p>
 * <ul>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getEnergyKind <em>Energy Kind</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getMovementKind <em>Movement Kind</em>}</li>
 *   <li>{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#isPowered <em>Is Powered</em>}</li>
 * </ul>
 *
 * @see org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage#getHwCommonActuator()
 * @model
 * @generated
 */
public interface HwCommonActuator extends HWActuator {
	/**
	 * Returns the value of the '<em><b>Energy Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Energy Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Energy Kind</em>' attribute.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind
	 * @see #setEnergyKind(EnergyKind)
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage#getHwCommonActuator_EnergyKind()
	 * @model ordered="false"
	 * @generated
	 */
	EnergyKind getEnergyKind();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getEnergyKind <em>Energy Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Energy Kind</em>' attribute.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.EnergyKind
	 * @see #getEnergyKind()
	 * @generated
	 */
	void setEnergyKind(EnergyKind value);

	/**
	 * Returns the value of the '<em><b>Movement Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.papyrus.iotml.hardware.actuator.MovementKind}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Movement Kind</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Movement Kind</em>' attribute.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.MovementKind
	 * @see #setMovementKind(MovementKind)
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage#getHwCommonActuator_MovementKind()
	 * @model ordered="false"
	 * @generated
	 */
	MovementKind getMovementKind();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#getMovementKind <em>Movement Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Movement Kind</em>' attribute.
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.MovementKind
	 * @see #getMovementKind()
	 * @generated
	 */
	void setMovementKind(MovementKind value);

	/**
	 * Returns the value of the '<em><b>Is Powered</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Is Powered</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Is Powered</em>' attribute.
	 * @see #setIsPowered(boolean)
	 * @see org.eclipse.papyrus.iotml.hardware.actuator.ActuatorPackage#getHwCommonActuator_IsPowered()
	 * @model dataType="org.eclipse.uml2.types.Boolean" required="true" ordered="false"
	 * @generated
	 */
	boolean isPowered();

	/**
	 * Sets the value of the '{@link org.eclipse.papyrus.iotml.hardware.actuator.HwCommonActuator#isPowered <em>Is Powered</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Is Powered</em>' attribute.
	 * @see #isPowered()
	 * @generated
	 */
	void setIsPowered(boolean value);

} // HwCommonActuator
