/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.cpp.reverse.utils;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.model.IParent;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class FileWatcher {
    private ICProject m_cproject;
    private long timestamp;

    public FileWatcher(ICProject project, long timestamp) {
        this.m_cproject = project;
        this.timestamp = timestamp;
    }

    public boolean isModified(ITranslationUnit itu) {
        IFile _file = itu.getFile();
        IPath _rawLocation = _file.getRawLocation();
        IPath _makeAbsolute = _rawLocation.makeAbsolute();
        File file = _makeAbsolute.toFile();
        Path filePath = file.toPath();
        BasicFileAttributes attributes = null;
        try {
            BasicFileAttributes _readAttributes;
            attributes = _readAttributes = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Throwable _t) {
            if (_t instanceof IOException) {
                IOException exception = (IOException)_t;
                String _message = exception.getMessage();
                String _plus = "Exception handled when trying to get file attributes: " + _message;
                System.out.println(_plus);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        FileTime _lastModifiedTime = attributes.lastModifiedTime();
        long seconds = _lastModifiedTime.to(TimeUnit.SECONDS);
        return seconds > Long.MIN_VALUE && seconds < Long.MAX_VALUE && seconds > this.timestamp;
    }

    public List<ITranslationUnit> getModifiledTranslationUnits(IParent parent) {
        try {
            UniqueEList ret = new UniqueEList();
            if (!(parent instanceof ITranslationUnit)) {
                ICElement[] _children = parent.getChildren();
                Iterable _filter = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children)), ITranslationUnit.class);
                Functions.Function1<ITranslationUnit, Boolean> _function = new Functions.Function1<ITranslationUnit, Boolean>(){

                    public Boolean apply(ITranslationUnit it) {
                        return FileWatcher.this.isModified(it);
                    }
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
                Iterables.addAll((Collection)ret, (Iterable)_filter_1);
                ICElement[] _children_1 = parent.getChildren();
                Iterable _filter_2 = Iterables.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)_children_1)), IParent.class);
                Consumer<IParent> _function_1 = new Consumer<IParent>((List)ret){
                    private final /* synthetic */ List val$ret;
                    {
                        this.val$ret = list;
                    }

                    @Override
                    public void accept(IParent it) {
                        List<ITranslationUnit> _modifiledTranslationUnits = FileWatcher.this.getModifiledTranslationUnits(it);
                        this.val$ret.addAll(_modifiledTranslationUnits);
                    }
                };
                _filter_2.forEach(_function_1);
            }
            return ret;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }
}

