/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class TransformationUtil {
    public static Map<Class, StateMachine> getStateMachineClass(Package pack) {
        final HashMap<Class, StateMachine> map = new HashMap<Class, StateMachine>();
        EList _ownedElements = pack.getOwnedElements();
        Iterable _filter = Iterables.filter((Iterable)_ownedElements, Class.class);
        Consumer<Class> _function = new Consumer<Class>(){

            @Override
            public void accept(Class it) {
                boolean _notEquals;
                EList _ownedBehaviors = it.getOwnedBehaviors();
                Iterable _filter = Iterables.filter((Iterable)_ownedBehaviors, StateMachine.class);
                StateMachine behavior = (StateMachine)IterableExtensions.head((Iterable)_filter);
                boolean bl = _notEquals = !Objects.equal((Object)behavior, null);
                if (_notEquals) {
                    map.put(it, behavior);
                }
            }
        };
        _filter.forEach(_function);
        return map;
    }

    public static Pseudostate firstPseudoState(Region region, PseudostateKind kind) {
        EList _subvertices = region.getSubvertices();
        for (Vertex vertex : _subvertices) {
            Pseudostate pseudoState;
            PseudostateKind _kind;
            boolean _equals;
            if (!(vertex instanceof Pseudostate) || !(_equals = Objects.equal((Object)(_kind = (pseudoState = (Pseudostate)vertex).getKind()), (Object)kind))) continue;
            return pseudoState;
        }
        return null;
    }

    public static List<State> findCompositeStatesInRegion(Vertex des1, Vertex des2) {
        ArrayList<State> ret = new ArrayList<State>();
        ArrayList<State> path1 = new ArrayList<State>();
        if (des1 instanceof State) {
            path1.add((State)des1);
        }
        Region _container = des1.getContainer();
        State owner1 = _container.getState();
        while (!Objects.equal((Object)owner1, null)) {
            State _state;
            path1.add(owner1);
            Region _container_1 = owner1.getContainer();
            owner1 = _state = _container_1.getState();
        }
        Vertex owner2 = des2;
        while (!Objects.equal((Object)owner2, null) && ret.isEmpty()) {
            for (State s : path1) {
                Region _container_2;
                boolean _and = false;
                Region _container_1 = s.getContainer();
                boolean _equals = Objects.equal((Object)_container_1, (Object)(_container_2 = owner2.getContainer()));
                _and = !_equals ? false : owner2 instanceof State;
                if (!_and) continue;
                ret.add(s);
                ret.add((State)owner2);
            }
            Region _container_3 = owner2.getContainer();
            State _state = _container_3.getState();
            owner2 = _state;
        }
        return ret;
    }

    public static State findInitialState(Region r) {
        boolean _notEquals;
        Pseudostate pseudoDefault = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        boolean bl = _notEquals = !Objects.equal((Object)pseudoDefault, null);
        if (_notEquals) {
            EList _outgoings = pseudoDefault.getOutgoings();
            Transition _head = (Transition)IterableExtensions.head((Iterable)_outgoings);
            Vertex _target = _head.getTarget();
            return (State)_target;
        }
        return null;
    }

    public static String getInitialEffect(Region r) {
        boolean _notEquals;
        Pseudostate pseudoDefault = TransformationUtil.firstPseudoState(r, PseudostateKind.INITIAL_LITERAL);
        boolean bl = _notEquals = !Objects.equal((Object)pseudoDefault, null);
        if (_notEquals) {
            boolean _notEquals_1;
            EList _outgoings = pseudoDefault.getOutgoings();
            Transition t = (Transition)IterableExtensions.head((Iterable)_outgoings);
            boolean _and = false;
            Behavior _effect = t.getEffect();
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_effect, null);
            if (!_notEquals_1) {
                _and = false;
            } else {
                Behavior _effect_1 = t.getEffect();
                _and = _effect_1 instanceof OpaqueBehavior;
            }
            if (_and) {
                Behavior _effect_2 = t.getEffect();
                EList _bodies = ((OpaqueBehavior)_effect_2).getBodies();
                return (String)IterableExtensions.head((Iterable)_bodies);
            }
        }
        return "//no initial effect is defined";
    }

    public static String getTransitionEffect(Transition t) {
        boolean _notEquals;
        boolean _and = false;
        Behavior _effect = t.getEffect();
        boolean bl = _notEquals = !Objects.equal((Object)_effect, null);
        if (!_notEquals) {
            _and = false;
        } else {
            Behavior _effect_1 = t.getEffect();
            _and = _effect_1 instanceof OpaqueBehavior;
        }
        if (_and) {
            Behavior _effect_2 = t.getEffect();
            EList _bodies = ((OpaqueBehavior)_effect_2).getBodies();
            return (String)IterableExtensions.head((Iterable)_bodies);
        }
        StringConcatenation _builder = new StringConcatenation();
        return _builder.toString();
    }

    public static List<State> transitiveSubStates(State parent) {
        final ArrayList<State> ret = new ArrayList<State>();
        boolean _isComposite = parent.isComposite();
        if (_isComposite) {
            EList _regions = parent.getRegions();
            for (Region r : _regions) {
                EList _subvertices = r.getSubvertices();
                Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
                Iterables.addAll(ret, (Iterable)_filter);
                EList _subvertices_1 = r.getSubvertices();
                Iterable _filter_1 = Iterables.filter((Iterable)_subvertices_1, State.class);
                Consumer<State> _function = new Consumer<State>(){

                    @Override
                    public void accept(State it) {
                        List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(it);
                        ret.addAll(_transitiveSubStates);
                    }
                };
                _filter_1.forEach(_function);
            }
        }
        return ret;
    }

    public static List<State> transitiveSubStates(Region parent) {
        final ArrayList<State> ret = new ArrayList<State>();
        EList _subvertices = parent.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, State.class);
        Functions.Function1<State, Boolean> _function = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                return !(it instanceof FinalState);
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)_function);
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                ret.add(it);
                List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(it);
                ret.addAll(_transitiveSubStates);
            }
        };
        _filter_1.forEach(_function_1);
        return ret;
    }

    public static String eventName(Event event) {
        char[] _charArray;
        String _xblockexpression = null;
        String name = "";
        boolean repeat = false;
        String _name = event.getName();
        char[] cArray = _charArray = _name.toCharArray();
        int n = _charArray.length;
        int n2 = 0;
        while (n2 < n) {
            boolean _isDigit;
            char c = cArray[n2];
            boolean _or = false;
            boolean _isAlphabetic = Character.isAlphabetic(c);
            _or = _isAlphabetic ? true : (_isDigit = Character.isDigit(c));
            if (_or) {
                String _name_1 = name;
                name = String.valueOf(_name_1) + Character.valueOf(c);
                repeat = false;
            } else if (!repeat) {
                String _name_2 = name;
                name = String.valueOf(_name_2) + "_";
                repeat = true;
            }
            ++n2;
        }
        _xblockexpression = name;
        return _xblockexpression;
    }

    public static String eventID(Event event) {
        String _eventName = TransformationUtil.eventName(event);
        String _upperCase = _eventName.toUpperCase();
        return String.valueOf(_upperCase) + "_ID";
    }

    public static boolean isSavehistory(Region topRegion, Region r) {
        boolean _greaterThan;
        Functions.Function1<Pseudostate, Boolean> _function;
        EList _subvertices = r.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, Pseudostate.class);
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.SHALLOW_HISTORY_LITERAL);
            }
        }));
        int _size = IterableExtensions.size((Iterable)_filter_1);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return true;
        }
        return TransformationUtil.isSaveDeepHistory(topRegion, r);
    }

    public static boolean isBehaviorExist(Behavior b) {
        boolean ret = false;
        boolean _and = false;
        boolean _notEquals = !Objects.equal((Object)b, null);
        _and = !_notEquals ? false : b instanceof OpaqueBehavior;
        if (_and) {
            boolean _not;
            EList _bodies = ((OpaqueBehavior)b).getBodies();
            String _head = (String)IterableExtensions.head((Iterable)_bodies);
            String _trim = _head.trim();
            boolean _isEmpty = _trim.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (_not) {
                ret = true;
            }
        }
        return ret;
    }

    public static boolean hasTriggerlessTransition(State s) {
        Functions.Function1<Transition, Boolean> _function;
        EList _outgoings = s.getOutgoings();
        Iterable _filter = IterableExtensions.filter((Iterable)_outgoings, (Functions.Function1)(_function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                EList _triggers = it.getTriggers();
                Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

                    public Event apply(Trigger it) {
                        return it.getEvent();
                    }
                };
                List _map = ListExtensions.map((List)_triggers, (Functions.Function1)_function);
                return _map.isEmpty();
            }
        }));
        int _size = IterableExtensions.size((Iterable)_filter);
        return _size > 0;
    }

    public static boolean isSaveDeepHistory(Region topRegion, Region r) {
        boolean _notEquals;
        boolean _greaterThan;
        Functions.Function1<Pseudostate, Boolean> _function;
        EList _subvertices = r.getSubvertices();
        Iterable _filter = Iterables.filter((Iterable)_subvertices, Pseudostate.class);
        Iterable _filter_1 = IterableExtensions.filter((Iterable)_filter, (Functions.Function1)(_function = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.DEEP_HISTORY_LITERAL);
            }
        }));
        int _size = IterableExtensions.size((Iterable)_filter_1);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            return true;
        }
        boolean bl2 = _notEquals = !Objects.equal((Object)r, (Object)topRegion);
        if (_notEquals) {
            State _state = r.getState();
            Region nextRegion = _state.getContainer();
            return TransformationUtil.isSaveDeepHistory(topRegion, nextRegion);
        }
        return false;
    }
}

