/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ref;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.CDefinitions;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SM2ClassesTransformationCore;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.SMCodeGeneratorConstants;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransformationUtil;
import org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine.TransitionGraph;
import org.eclipse.papyrus.designer.transformation.library.xtend.BehaviorUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.TransitionKind;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.Vertex;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class EventTransformation {
    @Extension
    protected CDefinitions cdefs;
    private SM2ClassesTransformationCore core;
    private Class superContext;
    private Package targetPack;
    private List<Pseudostate> joins = new ArrayList<Pseudostate>();

    public EventTransformation(SM2ClassesTransformationCore core) {
        Package _targetPacket;
        this.core = core;
        this.superContext = core.superContext;
        this.targetPack = _targetPacket = core.getTargetPacket();
    }

    public List<Event> getDeferredEvents(State s) {
        EList _deferrableTriggers = s.getDeferrableTriggers();
        Functions.Function1<Trigger, Event> _function = new Functions.Function1<Trigger, Event>(){

            public Event apply(Trigger it) {
                return it.getEvent();
            }
        };
        List _map = ListExtensions.map((List)_deferrableTriggers, (Functions.Function1)_function);
        return IterableExtensions.toList((Iterable)_map);
    }

    public String completionEventCheck(String eventName, String stateId) {
        boolean _equals = Objects.equal((Object)eventName, (Object)"CompletionEvent");
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            _builder.append("&& (currentEvent->associatedState == ");
            _builder.append(stateId, " ");
            _builder.append(")");
            return _builder.toString();
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        return _builder_1.toString();
    }

    public Operation createEventMethod(final String eventName, List<Transition> transitions) {
        boolean _greaterThan_4;
        Operation method = this.superContext.createOwnedOperation("process" + eventName, null, null);
        Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

            public Vertex apply(Transition it) {
                return it.getSource();
            }
        };
        List _map = ListExtensions.map(transitions, (Functions.Function1)_function);
        Iterable _filter = Iterables.filter((Iterable)_map, State.class);
        List tempSources = IterableExtensions.toList((Iterable)_filter);
        final ArrayList<State> sources = new ArrayList<State>();
        Consumer<State> _function_1 = new Consumer<State>(){

            @Override
            public void accept(State it) {
                boolean _not;
                boolean _contains = sources.contains(it);
                boolean bl = _not = !_contains;
                if (_not) {
                    sources.add(it);
                }
            }
        };
        tempSources.forEach(_function_1);
        HashMap map = new HashMap();
        for (State source : sources) {
            boolean _not;
            boolean _notEquals;
            Region _container = source.getContainer();
            State _state = _container.getState();
            boolean bl = _notEquals = !Objects.equal((Object)_state, null);
            if (!_notEquals) continue;
            Region _container_1 = source.getContainer();
            State _state_1 = _container_1.getState();
            boolean _containsKey = map.containsKey(_state_1);
            boolean bl2 = _not = !_containsKey;
            if (_not) {
                Region _container_2 = source.getContainer();
                State _state_2 = _container_2.getState();
                ArrayList _arrayList = new ArrayList();
                map.put(_state_2, _arrayList);
            }
            Region _container_3 = source.getContainer();
            State _state_3 = _container_3.getState();
            List _get = (List)map.get(_state_3);
            _get.add(source);
        }
        Set _keySet = map.keySet();
        List arraySet = IterableExtensions.toList(_keySet);
        int size = arraySet.size();
        int i = 0;
        while (i < size) {
            int j = i + 1;
            while (j < size) {
                State _get_2;
                int _calculateDepth_1;
                boolean _lessEqualsThan;
                State _get_1 = (State)arraySet.get(i);
                int _calculateDepth = this.core.calculateDepth(_get_1);
                boolean bl = _lessEqualsThan = _calculateDepth <= (_calculateDepth_1 = this.core.calculateDepth(_get_2 = (State)arraySet.get(j)));
                if (_lessEqualsThan) {
                    State tmp = (State)arraySet.remove(j);
                    arraySet.add(i, tmp);
                }
                ++j;
            }
            ++i;
        }
        List<State> rootSourceStates = this.core.getRootStates(sources);
        final ArrayList<Transition> passeds = new ArrayList<Transition>();
        Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                Functions.Function1<Event, Boolean> _function;
                List<Event> _deferredEvents = EventTransformation.this.getDeferredEvents(it);
                Iterable _filter = IterableExtensions.filter(_deferredEvents, (Functions.Function1)(_function = new Functions.Function1<Event, Boolean>(){

                    public Boolean apply(Event it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)eventName);
                    }
                }));
                int _size = IterableExtensions.size((Iterable)_filter);
                return _size > 0;
            }
        };
        Iterable statesDeferredEvent = IterableExtensions.filter(this.core.states, (Functions.Function1)_function_2);
        Functions.Function1<State, Boolean> _function_3 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _contains = sources.contains(it);
                return !_contains;
            }
        };
        Iterable notInSources = IterableExtensions.filter((Iterable)statesDeferredEvent, (Functions.Function1)_function_3);
        Functions.Function1<State, Boolean> _function_4 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _or = false;
                Region _container = it.getContainer();
                State _state = _container.getState();
                boolean _equals = Objects.equal((Object)_state, null);
                if (_equals) {
                    _or = true;
                } else {
                    boolean _isOrthogonal;
                    Region _container_1 = it.getContainer();
                    State _state_1 = _container_1.getState();
                    _or = _isOrthogonal = _state_1.isOrthogonal();
                }
                return _or;
            }
        };
        Iterable _filter_1 = IterableExtensions.filter((Iterable)notInSources, (Functions.Function1)_function_4);
        final List notInConcurrentState = IterableExtensions.toList((Iterable)_filter_1);
        Functions.Function1<State, Boolean> _function_5 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State it) {
                boolean _contains = notInConcurrentState.contains(it);
                return !_contains;
            }
        };
        Iterable inConcurrentState = IterableExtensions.filter((Iterable)notInSources, (Functions.Function1)_function_5);
        Functions.Function1<CallEvent, Boolean> _function_6 = new Functions.Function1<CallEvent, Boolean>(){

            public Boolean apply(CallEvent it) {
                String _eventName = TransformationUtil.eventName((Event)it);
                return Objects.equal((Object)_eventName, (Object)eventName);
            }
        };
        Iterable _filter_2 = IterableExtensions.filter(this.core.callEvents, (Functions.Function1)_function_6);
        int _size = IterableExtensions.size((Iterable)_filter_2);
        boolean isCallEvent = _size > 0;
        StringConcatenation _builder = new StringConcatenation();
        if (isCallEvent) {
            String _name = this.superContext.getName();
            String _upperCase = _name.toUpperCase();
            _builder.append(_upperCase, "");
            _builder.append("_GET_CONTROL");
            _builder.newLineIfNotEmpty();
        }
        _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
        _builder.append(" = statemachine::EVENT_PROCESSING;");
        _builder.newLineIfNotEmpty();
        for (State s : arraySet) {
            boolean _isOrthogonal = s.isOrthogonal();
            if (_isOrthogonal) {
                List _get_1 = (List)map.get(s);
                List<State> _actualStateList = this.getActualStateList(_get_1, transitions);
                for (final State sub : _actualStateList) {
                    boolean _greaterThan_2;
                    Functions.Function1<Transition, Boolean> _function_9;
                    Iterable _filter_5;
                    int _size_2;
                    boolean _greaterThan_1;
                    boolean _greaterThan;
                    Functions.Function1<Transition, Boolean> _function_8;
                    Functions.Function1<Transition, Boolean> _function_7 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)sub);
                        }
                    };
                    Iterable _filter_3 = IterableExtensions.filter(transitions, (Functions.Function1)_function_7);
                    Iterable _filter_4 = IterableExtensions.filter((Iterable)_filter_3, (Functions.Function1)(_function_8 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            boolean _contains = passeds.contains(it);
                            return !_contains;
                        }
                    }));
                    int _size_1 = IterableExtensions.size((Iterable)_filter_4);
                    boolean bl = _greaterThan = _size_1 > 0;
                    if (!_greaterThan) continue;
                    boolean _and = false;
                    boolean _equals = Objects.equal((Object)eventName, (Object)"CompletionEvent");
                    _and = !_equals ? false : (_greaterThan_1 = (_size_2 = IterableExtensions.size((Iterable)(_filter_5 = IterableExtensions.filter(transitions, (Functions.Function1)(_function_9 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            boolean _and = false;
                            boolean _and_1 = false;
                            Vertex _source = it.getSource();
                            boolean _equals = Objects.equal((Object)_source, (Object)sub);
                            if (!_equals) {
                                _and_1 = false;
                            } else {
                                Vertex _target = it.getTarget();
                                _and_1 = _target instanceof Pseudostate;
                            }
                            if (!_and_1) {
                                _and = false;
                            } else {
                                boolean _equals_1;
                                Vertex _target_1 = it.getTarget();
                                PseudostateKind _kind = ((Pseudostate)_target_1).getKind();
                                _and = _equals_1 = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
                            }
                            return _and;
                        }
                    }))))) > 0);
                    if (_and) {
                        Functions.Function1<Transition, Boolean> _function_10 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _and = false;
                                boolean _and_1 = false;
                                Vertex _source = it.getSource();
                                boolean _equals = Objects.equal((Object)_source, (Object)sub);
                                if (!_equals) {
                                    _and_1 = false;
                                } else {
                                    Vertex _target = it.getTarget();
                                    _and_1 = _target instanceof Pseudostate;
                                }
                                if (!_and_1) {
                                    _and = false;
                                } else {
                                    boolean _equals_1;
                                    Vertex _target_1 = it.getTarget();
                                    PseudostateKind _kind = ((Pseudostate)_target_1).getKind();
                                    _and = _equals_1 = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
                                }
                                return _and;
                            }
                        };
                        Iterable trans = IterableExtensions.filter(transitions, (Functions.Function1)_function_10);
                        _builder.newLineIfNotEmpty();
                        Functions.Function1<Transition, Boolean> _function_11 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                Vertex _target = it.getTarget();
                                boolean _contains = EventTransformation.this.joins.contains(_target);
                                return !_contains;
                            }
                        };
                        Iterable _filter_6 = IterableExtensions.filter((Iterable)trans, (Functions.Function1)_function_11);
                        Functions.Function1<Transition, Vertex> _function_12 = new Functions.Function1<Transition, Vertex>(){

                            public Vertex apply(Transition it) {
                                return it.getTarget();
                            }
                        };
                        Iterable _map_1 = IterableExtensions.map((Iterable)_filter_6, (Functions.Function1)_function_12);
                        Vertex join = (Vertex)IterableExtensions.head((Iterable)_map_1);
                        _builder.newLineIfNotEmpty();
                        EList _incomings = join.getIncomings();
                        Functions.Function1<Transition, Vertex> _function_13 = new Functions.Function1<Transition, Vertex>(){

                            public Vertex apply(Transition it) {
                                return it.getSource();
                            }
                        };
                        List sourcesOfJoin = ListExtensions.map((List)_incomings, (Functions.Function1)_function_13);
                        _builder.newLineIfNotEmpty();
                        _builder.append("if (");
                        boolean _hasElements = false;
                        for (Vertex src : sourcesOfJoin) {
                            if (!_hasElements) {
                                _hasElements = true;
                            } else {
                                _builder.appendImmediate((Object)" || ", "");
                            }
                            _builder.append("(currentEvent->associatedState == ");
                            String _name_1 = src.getName();
                            String _upperCase_1 = _name_1.toUpperCase();
                            _builder.append(_upperCase_1, "");
                            _builder.append("_ID)");
                        }
                        _builder.append(") {");
                        _builder.newLineIfNotEmpty();
                        Functions.Function1<Transition, Boolean> _function_14 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                Vertex _source = it.getSource();
                                return Objects.equal((Object)_source, (Object)sub);
                            }
                        };
                        Iterable _filter_7 = IterableExtensions.filter(transitions, (Functions.Function1)_function_14);
                        Functions.Function1<Transition, Boolean> _function_15 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _contains = passeds.contains(it);
                                return !_contains;
                            }
                        };
                        Iterable _filter_8 = IterableExtensions.filter((Iterable)_filter_7, (Functions.Function1)_function_15);
                        for (Transition t : _filter_8) {
                            _builder.append("\t");
                            boolean b = passeds.add(t);
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode = this.generateTransitionCode(sub, t);
                            _builder.append(_generateTransitionCode, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append("}");
                        _builder.newLine();
                        continue;
                    }
                    _builder.append("if (");
                    String _hasSubstatesAcceptingEvent = this.core.hasSubstatesAcceptingEvent(sub, sources);
                    _builder.append(_hasSubstatesAcceptingEvent, "");
                    _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder.append("[");
                    String _name_2 = s.getName();
                    String _upperCase_2 = _name_2.toUpperCase();
                    _builder.append(_upperCase_2, "");
                    _builder.append("_ID].");
                    _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder.append("[");
                    int _regionNumber = this.core.getRegionNumber(sub);
                    _builder.append((Object)_regionNumber, "");
                    _builder.append("] == ");
                    String _name_3 = sub.getName();
                    String _upperCase_3 = _name_3.toUpperCase();
                    _builder.append(_upperCase_3, "");
                    _builder.append("_ID");
                    String _name_4 = sub.getName();
                    String _upperCase_4 = _name_4.toUpperCase();
                    String _plus = String.valueOf(_upperCase_4) + "_ID";
                    String _completionEventCheck = this.completionEventCheck(eventName, _plus);
                    _builder.append(_completionEventCheck, "");
                    _builder.append(") {");
                    _builder.newLineIfNotEmpty();
                    List<Event> _deferredEvents = this.getDeferredEvents(sub);
                    Functions.Function1<Event, Boolean> _function_16 = new Functions.Function1<Event, Boolean>(){

                        public Boolean apply(Event it) {
                            String _name = it.getName();
                            return Objects.equal((Object)_name, (Object)eventName);
                        }
                    };
                    Iterable _filter_9 = IterableExtensions.filter(_deferredEvents, (Functions.Function1)_function_16);
                    int _size_3 = IterableExtensions.size((Iterable)_filter_9);
                    boolean bl3 = _greaterThan_2 = _size_3 > 0;
                    if (_greaterThan_2) {
                        _builder.append("\t");
                        _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
                        _builder.append(" = statemachine::EVENT_DEFERRED;");
                        _builder.newLineIfNotEmpty();
                    } else {
                        Functions.Function1<Transition, Boolean> _function_17 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                Vertex _source = it.getSource();
                                return Objects.equal((Object)_source, (Object)sub);
                            }
                        };
                        Iterable _filter_10 = IterableExtensions.filter(transitions, (Functions.Function1)_function_17);
                        Functions.Function1<Transition, Boolean> _function_18 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _contains = passeds.contains(it);
                                return !_contains;
                            }
                        };
                        Iterable _filter_11 = IterableExtensions.filter((Iterable)_filter_10, (Functions.Function1)_function_18);
                        for (Transition t_1 : _filter_11) {
                            _builder.append("\t");
                            boolean b_1 = passeds.add(t_1);
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            String _generateTransitionCode_1 = this.generateTransitionCode(sub, t_1);
                            _builder.append(_generateTransitionCode_1, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                    }
                    _builder.append("}");
                    _builder.newLine();
                }
                continue;
            }
            List _get_2 = (List)map.get(s);
            boolean _hasElements_1 = false;
            for (final State sub_1 : _get_2) {
                boolean _greaterThan_3;
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder.appendImmediate((Object)" else ", "");
                }
                _builder.append("if (");
                String _hasSubstatesAcceptingEvent_1 = this.core.hasSubstatesAcceptingEvent(sub_1, sources);
                _builder.append(_hasSubstatesAcceptingEvent_1, "");
                _builder.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder.append("[");
                String _name_5 = s.getName();
                String _upperCase_5 = _name_5.toUpperCase();
                _builder.append(_upperCase_5, "");
                _builder.append("_ID].");
                _builder.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder.append("[0] == ");
                String _name_6 = sub_1.getName();
                String _upperCase_6 = _name_6.toUpperCase();
                _builder.append(_upperCase_6, "");
                _builder.append("_ID");
                String _name_7 = sub_1.getName();
                String _upperCase_7 = _name_7.toUpperCase();
                String _plus_1 = String.valueOf(_upperCase_7) + "_ID";
                String _completionEventCheck_1 = this.completionEventCheck(eventName, _plus_1);
                _builder.append(_completionEventCheck_1, "");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                List<Event> _deferredEvents_1 = this.getDeferredEvents(sub_1);
                Functions.Function1<Event, Boolean> _function_19 = new Functions.Function1<Event, Boolean>(){

                    public Boolean apply(Event it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)eventName);
                    }
                };
                Iterable _filter_12 = IterableExtensions.filter(_deferredEvents_1, (Functions.Function1)_function_19);
                int _size_4 = IterableExtensions.size((Iterable)_filter_12);
                boolean bl = _greaterThan_3 = _size_4 > 0;
                if (_greaterThan_3) {
                    _builder.append("\t");
                    _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t");
                    _builder.append(" = statemachine::EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append("\t");
                    Functions.Function1<Transition, Boolean> _function_20 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Constraint _guard;
                            boolean _notEquals;
                            boolean _and = false;
                            Vertex _source = it.getSource();
                            boolean _equals = Objects.equal((Object)_source, (Object)sub_1);
                            _and = !_equals ? false : (_notEquals = !Objects.equal((Object)(_guard = it.getGuard()), null));
                            return _and;
                        }
                    };
                    Iterable hasGuards = IterableExtensions.filter(transitions, (Functions.Function1)_function_20);
                    _builder.newLineIfNotEmpty();
                    Functions.Function1<Transition, Boolean> _function_21 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Constraint _guard;
                            boolean _notEquals;
                            boolean _and = false;
                            Vertex _source = it.getSource();
                            boolean _equals = Objects.equal((Object)_source, (Object)sub_1);
                            _and = !_equals ? false : (_notEquals = !Objects.equal((Object)(_guard = it.getGuard()), null));
                            return _and;
                        }
                    };
                    Iterable _filter_13 = IterableExtensions.filter(transitions, (Functions.Function1)_function_21);
                    boolean _hasElements_2 = false;
                    for (Transition t_2 : _filter_13) {
                        if (!_hasElements_2) {
                            _hasElements_2 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t");
                        }
                        _builder.append("\t");
                        String _generateTransitionCode_2 = this.generateTransitionCode(sub_1, t_2);
                        _builder.append(_generateTransitionCode_2, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                    boolean _isEmpty = IterableExtensions.isEmpty((Iterable)hasGuards);
                    if (_isEmpty) {
                        _builder.append("\t");
                        Functions.Function1<Transition, Boolean> _function_22 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _and = false;
                                Vertex _source = it.getSource();
                                boolean _equals = Objects.equal((Object)_source, (Object)sub_1);
                                if (!_equals) {
                                    _and = false;
                                } else {
                                    boolean _equals_1;
                                    Constraint _guard = it.getGuard();
                                    _and = _equals_1 = Objects.equal((Object)_guard, null);
                                }
                                return _and;
                            }
                        };
                        Iterable _filter_14 = IterableExtensions.filter(transitions, (Functions.Function1)_function_22);
                        Transition _head = (Transition)IterableExtensions.head((Iterable)_filter_14);
                        String _generateTransitionCode_3 = this.generateTransitionCode(sub_1, _head);
                        _builder.append(_generateTransitionCode_3, "\t");
                        _builder.newLineIfNotEmpty();
                    } else {
                        boolean _notEquals_1;
                        Functions.Function1<Transition, Boolean> _function_23 = new Functions.Function1<Transition, Boolean>(){

                            public Boolean apply(Transition it) {
                                boolean _and = false;
                                Vertex _source = it.getSource();
                                boolean _equals = Objects.equal((Object)_source, (Object)sub_1);
                                if (!_equals) {
                                    _and = false;
                                } else {
                                    boolean _equals_1;
                                    Constraint _guard = it.getGuard();
                                    _and = _equals_1 = Objects.equal((Object)_guard, null);
                                }
                                return _and;
                            }
                        };
                        Iterable _filter_15 = IterableExtensions.filter(transitions, (Functions.Function1)_function_23);
                        Transition _head_1 = (Transition)IterableExtensions.head((Iterable)_filter_15);
                        boolean bl4 = _notEquals_1 = !Objects.equal((Object)_head_1, null);
                        if (_notEquals_1) {
                            _builder.append("\t");
                            _builder.append("else {");
                            _builder.newLine();
                            _builder.append("\t");
                            _builder.append("\t");
                            Functions.Function1<Transition, Boolean> _function_24 = new Functions.Function1<Transition, Boolean>(){

                                public Boolean apply(Transition it) {
                                    boolean _and = false;
                                    Vertex _source = it.getSource();
                                    boolean _equals = Objects.equal((Object)_source, (Object)sub_1);
                                    if (!_equals) {
                                        _and = false;
                                    } else {
                                        boolean _equals_1;
                                        Constraint _guard = it.getGuard();
                                        _and = _equals_1 = Objects.equal((Object)_guard, null);
                                    }
                                    return _and;
                                }
                            };
                            Iterable _filter_16 = IterableExtensions.filter(transitions, (Functions.Function1)_function_24);
                            Transition _head_2 = (Transition)IterableExtensions.head((Iterable)_filter_16);
                            String _generateTransitionCode_4 = this.generateTransitionCode(sub_1, _head_2);
                            _builder.append(_generateTransitionCode_4, "\t\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append("\t");
                            _builder.append("}");
                            _builder.newLine();
                        }
                    }
                }
                _builder.append("}");
                _builder.newLine();
            }
        }
        int _size_5 = rootSourceStates.size();
        boolean bl = _greaterThan_4 = _size_5 > 0;
        if (_greaterThan_4) {
            _builder.append("if (");
            _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
            _builder.append(" == statemachine::EVENT_PROCESSING");
            String _completionEventCheck_2 = this.completionEventCheck(eventName, SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID);
            _builder.append(_completionEventCheck_2, "");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("switch(");
            _builder.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "\t");
            _builder.append(") {");
            _builder.newLineIfNotEmpty();
            for (final State root : rootSourceStates) {
                boolean _greaterThan_5;
                _builder.append("\t\t");
                _builder.append("case ");
                String _name_8 = root.getName();
                String _upperCase_8 = _name_8.toUpperCase();
                _builder.append(_upperCase_8, "\t\t");
                _builder.append("_ID: ");
                _builder.newLineIfNotEmpty();
                List<Event> _deferredEvents_2 = this.getDeferredEvents(root);
                Functions.Function1<Event, Boolean> _function_25 = new Functions.Function1<Event, Boolean>(){

                    public Boolean apply(Event it) {
                        String _name = it.getName();
                        return Objects.equal((Object)_name, (Object)eventName);
                    }
                };
                Iterable _filter_17 = IterableExtensions.filter(_deferredEvents_2, (Functions.Function1)_function_25);
                int _size_6 = IterableExtensions.size((Iterable)_filter_17);
                boolean bl5 = _greaterThan_5 = _size_6 > 0;
                if (_greaterThan_5) {
                    _builder.append("\t\t");
                    _builder.append("\t");
                    _builder.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "\t\t\t");
                    _builder.append(" = statemachine::EVENT_DEFERRED;");
                    _builder.newLineIfNotEmpty();
                } else {
                    Functions.Function1<Transition, Boolean> _function_26 = new Functions.Function1<Transition, Boolean>(){

                        public Boolean apply(Transition it) {
                            Vertex _source = it.getSource();
                            return Objects.equal((Object)_source, (Object)root);
                        }
                    };
                    Iterable _filter_18 = IterableExtensions.filter(transitions, (Functions.Function1)_function_26);
                    boolean _hasElements_3 = false;
                    for (Transition t_3 : _filter_18) {
                        if (!_hasElements_3) {
                            _hasElements_3 = true;
                        } else {
                            _builder.appendImmediate((Object)" else ", "\t\t\t");
                        }
                        _builder.append("\t\t");
                        _builder.append("\t");
                        String _generateTransitionCode_5 = this.generateTransitionCode(root, t_3);
                        _builder.append(_generateTransitionCode_5, "\t\t\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
                _builder.append("\t\t");
                _builder.append("\t");
                _builder.append("break;");
                _builder.newLine();
            }
            _builder.append("\t\t");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("//do nothing");
            _builder.newLine();
            _builder.append("\t\t\t");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        }
        if (isCallEvent) {
            String _name_9 = this.superContext.getName();
            String _upperCase_9 = _name_9.toUpperCase();
            _builder.append(_upperCase_9, "");
            _builder.append("_RELEASE_CONTROL");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        String body = _builder.toString();
        this.core.createOpaqueBehavior(this.superContext, method, body);
        return method;
    }

    private List<State> getActualStateList(List<State> l, List<Transition> trans) {
        boolean _greaterThan;
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                boolean _and = false;
                Vertex _target = it.getTarget();
                if (!(_target instanceof Pseudostate)) {
                    _and = false;
                } else {
                    boolean _equals;
                    Vertex _target_1 = it.getTarget();
                    PseudostateKind _kind = ((Pseudostate)_target_1).getKind();
                    _and = _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
                }
                return _and;
            }
        };
        Iterable transComingToJoin = IterableExtensions.filter(trans, (Functions.Function1)_function);
        final ArrayList<State> ret = new ArrayList<State>();
        ret.addAll(l);
        int _size = IterableExtensions.size((Iterable)transComingToJoin);
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            final ArrayList<Pseudostate> joins = new ArrayList<Pseudostate>();
            Functions.Function1<Transition, Vertex> _function_1 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getTarget();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)transComingToJoin, (Functions.Function1)_function_1);
            Iterable _filter = Iterables.filter((Iterable)_map, Pseudostate.class);
            Consumer<Pseudostate> _function_2 = new Consumer<Pseudostate>(){

                @Override
                public void accept(Pseudostate it) {
                    boolean _not;
                    boolean _contains = joins.contains(it);
                    boolean bl = _not = !_contains;
                    if (_not) {
                        joins.add(it);
                    }
                }
            };
            _filter.forEach(_function_2);
            Consumer<Pseudostate> _function_3 = new Consumer<Pseudostate>(){

                @Override
                public void accept(Pseudostate it) {
                    EList _incomings = it.getIncomings();
                    Functions.Function1<Transition, Vertex> _function = new Functions.Function1<Transition, Vertex>(){

                        public Vertex apply(Transition it) {
                            return it.getSource();
                        }
                    };
                    List _map = ListExtensions.map((List)_incomings, (Functions.Function1)_function);
                    Iterable _filter = Iterables.filter((Iterable)_map, State.class);
                    List toRemoveds = IterableExtensions.toList((Iterable)_filter);
                    State _head = (State)IterableExtensions.head((Iterable)toRemoveds);
                    toRemoveds.remove(_head);
                    ret.removeAll(toRemoveds);
                }
            };
            joins.forEach(_function_3);
        }
        return ret;
    }

    public String generateTransitionCode(State s, Transition t) {
        StringConcatenation _builder = new StringConcatenation();
        String ret = _builder.toString();
        Constraint _guard = t.getGuard();
        boolean hasGuard = !Objects.equal((Object)_guard, null);
        Vertex _target = t.getTarget();
        if (_target instanceof State) {
            TransitionKind _kind;
            boolean _equals_1;
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("process");
            _builder_1.append(SMCodeGeneratorConstants.COMPLETION_EVENT, "");
            _builder_1.append("();");
            String callCompletionEvent = _builder_1.toString();
            Vertex _target_1 = t.getTarget();
            if (_target_1 instanceof FinalState) {
                Vertex _target_2 = t.getTarget();
                Region _container = _target_2.getContainer();
                State composite = _container.getState();
                boolean _equals = Objects.equal((Object)composite, null);
                if (_equals) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    callCompletionEvent = _builder_2.toString();
                } else {
                    StringConcatenation _builder_3 = new StringConcatenation();
                    _builder_3.append("if (");
                    EList _regions = composite.getRegions();
                    boolean _hasElements = false;
                    for (Region r : _regions) {
                        if (!_hasElements) {
                            _hasElements = true;
                        } else {
                            _builder_3.appendImmediate((Object)" && ", "");
                        }
                        _builder_3.append("(");
                        _builder_3.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                        _builder_3.append("[");
                        String _name = composite.getName();
                        String _upperCase = _name.toUpperCase();
                        _builder_3.append(_upperCase, "");
                        _builder_3.append("_ID].");
                        _builder_3.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                        _builder_3.append("[");
                        EList _regions_1 = composite.getRegions();
                        int _indexOf = _regions_1.indexOf((Object)r);
                        _builder_3.append((Object)_indexOf, "");
                        _builder_3.append("] == ");
                        _builder_3.append(SMCodeGeneratorConstants.STATE_MAX, "");
                        _builder_3.append(")");
                    }
                    _builder_3.append(") {");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("\t");
                    _builder_3.append(SMCodeGeneratorConstants.EVENT_QUEUE, "\t");
                    _builder_3.append(".push(statemachine::PRIORITY_1, NULL, COMPLETIONEVENT_ID, statemachine::COMPLETION_EVENT, ");
                    String _name_1 = composite.getName();
                    String _upperCase_1 = _name_1.toUpperCase();
                    _builder_3.append(_upperCase_1, "\t");
                    _builder_3.append("_ID);");
                    _builder_3.newLineIfNotEmpty();
                    _builder_3.append("}");
                    callCompletionEvent = _builder_3.toString();
                }
            }
            if (_equals_1 = Objects.equal((Object)(_kind = t.getKind()), (Object)TransitionKind.INTERNAL_LITERAL)) {
                boolean _notEquals;
                StringConcatenation _builder_4 = new StringConcatenation();
                Behavior _effect = t.getEffect();
                boolean bl = _notEquals = !Objects.equal((Object)_effect, null);
                if (_notEquals) {
                    Behavior _effect_1 = t.getEffect();
                    EList _bodies = ((OpaqueBehavior)_effect_1).getBodies();
                    String _head = (String)IterableExtensions.head((Iterable)_bodies);
                    _builder_4.append(_head, "");
                    _builder_4.newLineIfNotEmpty();
                }
                ret = _builder_4.toString();
            } else {
                TransitionKind _kind_1 = t.getKind();
                boolean _equals_2 = Objects.equal((Object)_kind_1, (Object)TransitionKind.LOCAL_LITERAL);
                if (_equals_2) {
                    Vertex _target_3;
                    State parent = null;
                    State child = null;
                    List<State> _transitiveSubStates = TransformationUtil.transitiveSubStates(s);
                    boolean _contains = _transitiveSubStates.contains(_target_3 = t.getTarget());
                    if (_contains) {
                        parent = s;
                        Vertex _target_4 = t.getTarget();
                        final State finalChild = child = (State)_target_4;
                        StringConcatenation _builder_5 = new StringConcatenation();
                        String _generateExitingSubStates = this.core.generateExitingSubStates(s, false);
                        _builder_5.append(_generateExitingSubStates, "");
                        _builder_5.newLineIfNotEmpty();
                        String _transitionEffect = TransformationUtil.getTransitionEffect(t);
                        _builder_5.append(_transitionEffect, "");
                        _builder_5.newLineIfNotEmpty();
                        Vertex _target_5 = t.getTarget();
                        if (_target_5 instanceof FinalState) {
                            Vertex _target_6 = t.getTarget();
                            Region _container_1 = _target_6.getContainer();
                            boolean _equals_3 = Objects.equal((Object)_container_1, (Object)this.core.topRegion);
                            if (_equals_3) {
                                _builder_5.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
                                _builder_5.append(" = ");
                                _builder_5.append(SMCodeGeneratorConstants.STATE_MAX, "");
                                _builder_5.append(";");
                                _builder_5.newLineIfNotEmpty();
                            } else {
                                _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                                _builder_5.append("[");
                                Vertex _target_7 = t.getTarget();
                                Region _container_2 = _target_7.getContainer();
                                State _state = _container_2.getState();
                                String _name_2 = _state.getName();
                                String _upperCase_2 = _name_2.toUpperCase();
                                _builder_5.append(_upperCase_2, "");
                                _builder_5.append("_ID].");
                                _builder_5.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                                _builder_5.append("[");
                                Vertex _target_8 = t.getTarget();
                                Region _container_3 = _target_8.getContainer();
                                State _state_1 = _container_3.getState();
                                EList _regions_2 = _state_1.getRegions();
                                Vertex _target_9 = t.getTarget();
                                Region _container_4 = _target_9.getContainer();
                                int _indexOf_1 = _regions_2.indexOf((Object)_container_4);
                                _builder_5.append((Object)_indexOf_1, "");
                                _builder_5.append("] = ");
                                _builder_5.append(SMCodeGeneratorConstants.STATE_MAX, "");
                                _builder_5.append(";");
                                _builder_5.newLineIfNotEmpty();
                            }
                            _builder_5.append(callCompletionEvent, "");
                            _builder_5.append(";");
                            _builder_5.newLineIfNotEmpty();
                        } else {
                            EList _regions_3 = parent.getRegions();
                            Functions.Function1<Region, Boolean> _function = new Functions.Function1<Region, Boolean>(){

                                public Boolean apply(Region it) {
                                    List<Vertex> _allSubVertexes = EventTransformation.this.core.allSubVertexes(it);
                                    return _allSubVertexes.contains(finalChild);
                                }
                            };
                            Iterable _filter = IterableExtensions.filter((Iterable)_regions_3, (Functions.Function1)_function);
                            Region region = (Region)IterableExtensions.head((Iterable)_filter);
                            _builder_5.newLineIfNotEmpty();
                            String _regionMethodName = this.core.getRegionMethodName(region);
                            _builder_5.append(_regionMethodName, "");
                            _builder_5.append("(");
                            String _vertexMacroName = this.core.getVertexMacroName((Vertex)child);
                            _builder_5.append(_vertexMacroName, "");
                            _builder_5.append(");");
                            _builder_5.newLineIfNotEmpty();
                        }
                        ret = _builder_5.toString();
                    } else {
                        Vertex _target_10 = t.getTarget();
                        List<State> _transitiveSubStates_1 = TransformationUtil.transitiveSubStates((State)_target_10);
                        boolean _contains_1 = _transitiveSubStates_1.contains(s);
                        if (_contains_1) {
                            Vertex _target_11 = t.getTarget();
                            parent = (State)_target_11;
                            final State finalChild_1 = child = s;
                            StringConcatenation _builder_6 = new StringConcatenation();
                            String _generateExitingSubStates_1 = this.core.generateExitingSubStates(s, false);
                            _builder_6.append(_generateExitingSubStates_1, "");
                            _builder_6.newLineIfNotEmpty();
                            String _transitionEffect_1 = TransformationUtil.getTransitionEffect(t);
                            _builder_6.append(_transitionEffect_1, "");
                            _builder_6.newLineIfNotEmpty();
                            Vertex _target_12 = t.getTarget();
                            if (_target_12 instanceof FinalState) {
                                Vertex _target_13 = t.getTarget();
                                Region _container_5 = _target_13.getContainer();
                                boolean _equals_4 = Objects.equal((Object)_container_5, (Object)this.core.topRegion);
                                if (_equals_4) {
                                    _builder_6.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
                                    _builder_6.append(" = ");
                                    _builder_6.append(SMCodeGeneratorConstants.STATE_MAX, "");
                                    _builder_6.append(";");
                                    _builder_6.newLineIfNotEmpty();
                                } else {
                                    _builder_6.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                                    _builder_6.append("[");
                                    Vertex _target_14 = t.getTarget();
                                    Region _container_6 = _target_14.getContainer();
                                    State _state_2 = _container_6.getState();
                                    String _name_3 = _state_2.getName();
                                    String _upperCase_3 = _name_3.toUpperCase();
                                    _builder_6.append(_upperCase_3, "");
                                    _builder_6.append("_ID].");
                                    _builder_6.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                                    _builder_6.append("[");
                                    Vertex _target_15 = t.getTarget();
                                    Region _container_7 = _target_15.getContainer();
                                    State _state_3 = _container_7.getState();
                                    EList _regions_4 = _state_3.getRegions();
                                    Vertex _target_16 = t.getTarget();
                                    Region _container_8 = _target_16.getContainer();
                                    int _indexOf_2 = _regions_4.indexOf((Object)_container_8);
                                    _builder_6.append((Object)_indexOf_2, "");
                                    _builder_6.append("] = ");
                                    _builder_6.append(SMCodeGeneratorConstants.STATE_MAX, "");
                                    _builder_6.append(";");
                                    _builder_6.newLineIfNotEmpty();
                                }
                                _builder_6.append(callCompletionEvent, "");
                                _builder_6.append(";");
                                _builder_6.newLineIfNotEmpty();
                            } else {
                                EList _regions_5 = parent.getRegions();
                                Functions.Function1<Region, Boolean> _function_1 = new Functions.Function1<Region, Boolean>(){

                                    public Boolean apply(Region it) {
                                        List<Vertex> _allSubVertexes = EventTransformation.this.core.allSubVertexes(it);
                                        return _allSubVertexes.contains(finalChild_1);
                                    }
                                };
                                Iterable _filter_1 = IterableExtensions.filter((Iterable)_regions_5, (Functions.Function1)_function_1);
                                Region region_1 = (Region)IterableExtensions.head((Iterable)_filter_1);
                                _builder_6.newLineIfNotEmpty();
                                String _regionMethodName_1 = this.core.getRegionMethodName(region_1);
                                _builder_6.append(_regionMethodName_1, "");
                                _builder_6.append("(");
                                String _initialMacroName = this.core.getInitialMacroName(region_1);
                                _builder_6.append(_initialMacroName, "");
                                _builder_6.append(");");
                                _builder_6.newLineIfNotEmpty();
                            }
                            ret = _builder_6.toString();
                        }
                    }
                } else {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    Vertex _target_17 = t.getTarget();
                    String _generateBetweenVertex = this.core.pseudostateGenerator.generateBetweenVertex((Vertex)s, _target_17, t);
                    _builder_7.append(_generateBetweenVertex, "");
                    ret = _builder_7.toString();
                }
            }
            StringConcatenation _builder_8 = new StringConcatenation();
            _builder_8.append("//from ");
            Vertex _source = t.getSource();
            String _name_4 = _source.getName();
            _builder_8.append(_name_4, "");
            _builder_8.append(" to ");
            Vertex _target_18 = t.getTarget();
            String _name_5 = _target_18.getName();
            _builder_8.append(_name_5, "");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("if (");
            if (hasGuard) {
                String _guard_1 = this.core.getGuard(t);
                _builder_8.append(_guard_1, "");
            } else {
                _builder_8.append("true");
            }
            _builder_8.append(") {");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append(ret, "");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
            _builder_8.append(" = statemachine::EVENT_CONSUMED;");
            _builder_8.newLineIfNotEmpty();
            String _generateTransitionCode = this.core.monitoringTransformation.generateTransitionCode(t);
            _builder_8.append(_generateTransitionCode, "");
            _builder_8.newLineIfNotEmpty();
            _builder_8.append("}");
            ret = _builder_8.toString();
        } else {
            StringConcatenation _builder_9 = new StringConcatenation();
            _builder_9.append("//from ");
            Vertex _source_1 = t.getSource();
            String _name_6 = _source_1.getName();
            _builder_9.append(_name_6, "");
            _builder_9.append(" to ");
            Vertex _target_19 = t.getTarget();
            String _name_7 = _target_19.getName();
            _builder_9.append(_name_7, "");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("if (");
            if (hasGuard) {
                String _guard_2 = this.core.getGuard(t);
                _builder_9.append(_guard_2, "");
            } else {
                _builder_9.append("true");
            }
            _builder_9.append(") {");
            _builder_9.newLineIfNotEmpty();
            String _generateTransitionGraphCode = this.generateTransitionGraphCode(s, t);
            _builder_9.append(_generateTransitionGraphCode, "");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append(SMCodeGeneratorConstants.SYSTEM_STATE_ATTR, "");
            _builder_9.append(" = statemachine::EVENT_CONSUMED;");
            _builder_9.newLineIfNotEmpty();
            String _generateTransitionCode_1 = this.core.monitoringTransformation.generateTransitionCode(t);
            _builder_9.append(_generateTransitionCode_1, "");
            _builder_9.newLineIfNotEmpty();
            _builder_9.append("}");
            ret = _builder_9.toString();
        }
        return ret;
    }

    public int getIndexOfUnguardTransition(Pseudostate junction) {
        int _size;
        boolean _greaterThan;
        EList _outgoings = junction.getOutgoings();
        Functions.Function1<Transition, Boolean> _function = new Functions.Function1<Transition, Boolean>(){

            public Boolean apply(Transition it) {
                Constraint _guard = it.getGuard();
                return Objects.equal((Object)_guard, null);
            }
        };
        Iterable ungaurds = IterableExtensions.filter((Iterable)_outgoings, (Functions.Function1)_function);
        boolean _or = false;
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)ungaurds);
        _or = _isEmpty ? true : (_greaterThan = (_size = IterableExtensions.size((Iterable)ungaurds)) > 1);
        Transition unguard = (Transition)IterableExtensions.head((Iterable)ungaurds);
        EList _outgoings_1 = junction.getOutgoings();
        return _outgoings_1.indexOf((Object)unguard);
    }

    public OpaqueBehavior createEventMethod(Event e, List<Transition> transitions) {
        OpaqueBehavior _xblockexpression = null;
        String _eventName = TransformationUtil.eventName(e);
        Operation evMethod = this.createEventMethod(_eventName, transitions);
        OpaqueBehavior _xifexpression = null;
        if (e instanceof CallEvent) {
            boolean _notEquals;
            EList _methods_1;
            Behavior existingMethod;
            String _body;
            boolean _equals;
            boolean _greaterThan;
            OpaqueBehavior _xblockexpression_1 = null;
            Operation op = ((CallEvent)e).getOperation();
            this.core.copyParameters(op, evMethod, false);
            EList params = evMethod.getOwnedParameters();
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("this->process");
            String _eventName_1 = TransformationUtil.eventName(e);
            _builder.append(_eventName_1, "");
            _builder.append("(");
            boolean _hasElements = false;
            for (Parameter p : params) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                String _name = p.getName();
                _builder.append(_name, "");
            }
            _builder.append(");");
            String body = _builder.toString();
            String existingBody = null;
            EList _methods = op.getMethods();
            int _size = _methods.size();
            boolean bl = _greaterThan = _size > 0;
            if (_greaterThan && (_equals = Objects.equal((Object)(existingBody = (_body = BehaviorUtil.body((Behavior)(existingMethod = (Behavior)(_methods_1 = op.getMethods()).get(0)), (String)"C++"))), null))) {
                String _body_1;
                existingBody = _body_1 = BehaviorUtil.body((Behavior)existingMethod, (String)"C/C++");
            }
            boolean bl2 = _notEquals = !Objects.equal(existingBody, null);
            if (_notEquals) {
                String _body_2 = body;
                body = String.valueOf(_body_2) + "\n// original method code\n" + existingBody;
            }
            _xifexpression = _xblockexpression_1 = this.core.createOpaqueBehavior(this.superContext, op, body);
        } else {
            OpaqueBehavior _xifexpression_1 = null;
            if (e instanceof SignalEvent) {
                boolean _notEquals_2;
                boolean _notEquals_1;
                boolean _notEquals;
                OpaqueBehavior _xblockexpression_2 = null;
                String _name = ((SignalEvent)e).getName();
                String _plus = "send" + _name;
                Operation send = this.superContext.createOwnedOperation(_plus, null, null);
                Signal _signal = ((SignalEvent)e).getSignal();
                boolean bl = _notEquals = !Objects.equal((Object)_signal, null);
                if (_notEquals) {
                    Signal _signal_1 = ((SignalEvent)e).getSignal();
                    Parameter _createOwnedParameter = send.createOwnedParameter("sig", (Type)_signal_1);
                    StereotypeUtil.apply((Element)_createOwnedParameter, Ref.class);
                    Signal _signal_2 = ((SignalEvent)e).getSignal();
                    Parameter _createOwnedParameter_1 = evMethod.createOwnedParameter("sig", (Type)_signal_2);
                    StereotypeUtil.apply((Element)_createOwnedParameter_1, Ref.class);
                }
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(SMCodeGeneratorConstants.EVENT_QUEUE, "");
                _builder.append(".push(statemachine::PRIORITY_2, ");
                Signal _signal_3 = ((SignalEvent)e).getSignal();
                boolean bl3 = _notEquals_1 = !Objects.equal((Object)_signal_3, null);
                if (_notEquals_1) {
                    _builder.append("&sig");
                } else {
                    _builder.append("NULL");
                }
                _builder.append(", ");
                String _name_1 = ((SignalEvent)e).getName();
                String _upperCase = _name_1.toUpperCase();
                _builder.append(_upperCase, "");
                _builder.append("_ID, statemachine::SIGNAL_EVENT, 0");
                Signal _signal_4 = ((SignalEvent)e).getSignal();
                boolean bl4 = _notEquals_2 = !Objects.equal((Object)_signal_4, null);
                if (_notEquals_2) {
                    _builder.append(", sizeof(");
                    Signal _signal_5 = ((SignalEvent)e).getSignal();
                    String _cppQualifiedName = CppGenUtils.cppQualifiedName((NamedElement)_signal_5);
                    _builder.append(_cppQualifiedName, "");
                    _builder.append(")");
                }
                _builder.append(");");
                _xifexpression_1 = _xblockexpression_2 = this.core.createOpaqueBehavior(this.superContext, send, _builder.toString());
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public String generateTransitionGraphCode(State s, Transition t) {
        boolean _notEquals_3;
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _contains;
        TransitionGraph graph = this.core.calculateTransitionGraphs(s, t);
        Vertex _target = t.getTarget();
        Pseudostate target = (Pseudostate)_target;
        Functions.Function1<Pseudostate, Boolean> _function = new Functions.Function1<Pseudostate, Boolean>(){

            public Boolean apply(Pseudostate it) {
                PseudostateKind _kind = it.getKind();
                return Objects.equal((Object)_kind, (Object)PseudostateKind.JUNCTION_LITERAL);
            }
        };
        Iterable _filter = IterableExtensions.filter(graph.P, (Functions.Function1)_function);
        List junctions = IterableExtensions.toList((Iterable)_filter);
        Pseudostate join = null;
        PseudostateKind _kind = target.getKind();
        boolean _equals = Objects.equal((Object)_kind, (Object)PseudostateKind.JOIN_LITERAL);
        if (_equals) {
            join = target;
        }
        boolean _and = false;
        boolean _notEquals = !Objects.equal((Object)join, null);
        _and = !_notEquals ? false : (_contains = this.joins.contains(join));
        if (_and) {
            StringConcatenation _builder = new StringConcatenation();
            return _builder.toString();
        }
        this.joins.add(join);
        StringConcatenation _builder_1 = new StringConcatenation();
        String ret = _builder_1.toString();
        ArrayList<Vertex> exits = new ArrayList<Vertex>();
        ArrayList<Vertex> enters = new ArrayList<Vertex>();
        this.calculateExitsEnters(t, exits, enters);
        Vertex cpEx = (Vertex)IterableExtensions.last(exits);
        Vertex cpEn = (Vertex)IterableExtensions.last(enters);
        StringConcatenation _builder_2 = new StringConcatenation();
        for (Pseudostate junction : junctions) {
            String _name = junction.getName();
            _builder_2.append(_name, "");
            _builder_2.append(" = ");
            int _indexOfUnguardTransition = this.getIndexOfUnguardTransition(junction);
            _builder_2.append((Object)_indexOfUnguardTransition, "");
            _builder_2.append(";");
            _builder_2.newLineIfNotEmpty();
            EList _outgoings = junction.getOutgoings();
            Functions.Function1<Transition, Boolean> _function_1 = new Functions.Function1<Transition, Boolean>(){

                public Boolean apply(Transition it) {
                    Constraint _guard = it.getGuard();
                    return !Objects.equal((Object)_guard, null);
                }
            };
            Iterable _filter_1 = IterableExtensions.filter((Iterable)_outgoings, (Functions.Function1)_function_1);
            boolean _hasElements = false;
            for (Transition tr : _filter_1) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder_2.appendImmediate((Object)" else ", "");
                }
                _builder_2.append("if (");
                String _guard = this.core.getGuard(tr);
                _builder_2.append(_guard, "");
                _builder_2.append(") {");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("\t");
                String _name_1 = junction.getName();
                _builder_2.append(_name_1, "\t");
                _builder_2.append(" = ");
                EList _outgoings_1 = junction.getOutgoings();
                int _indexOf = _outgoings_1.indexOf((Object)tr);
                _builder_2.append((Object)_indexOf, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
                _builder_2.append("}");
                _builder_2.newLine();
            }
        }
        _builder_2.append(ret, "");
        _builder_2.newLineIfNotEmpty();
        if (cpEx instanceof State) {
            String _generateExitingSubStates = this.core.generateExitingSubStates((State)cpEx, true);
            _builder_2.append(_generateExitingSubStates, "");
            _builder_2.newLineIfNotEmpty();
        }
        boolean bl = _notEquals_1 = !Objects.equal((Object)join, null);
        if (_notEquals_1) {
            _builder_2.append("//TODO: concurrency");
            _builder_2.newLine();
            EList _incomings = join.getIncomings();
            for (Transition in : _incomings) {
                String _transitionEffect = TransformationUtil.getTransitionEffect(in);
                _builder_2.append(_transitionEffect, "");
                _builder_2.newLineIfNotEmpty();
            }
        } else {
            String _transitionEffect_1 = TransformationUtil.getTransitionEffect(t);
            _builder_2.append(_transitionEffect_1, "");
            _builder_2.newLineIfNotEmpty();
            _builder_2.append("\t\t");
        }
        String bodyInside = _builder_2.toString();
        Vertex innermost = (Vertex)IterableExtensions.head(enters);
        if (innermost instanceof State) {
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append(bodyInside, "");
            _builder_3.newLineIfNotEmpty();
            if (innermost instanceof FinalState) {
                Region _container = ((FinalState)innermost).getContainer();
                boolean _equals_1 = Objects.equal((Object)_container, (Object)this.core.topRegion);
                if (_equals_1) {
                    _builder_3.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
                    _builder_3.append(" = ");
                    _builder_3.append(SMCodeGeneratorConstants.STATE_MAX, "");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                } else {
                    _builder_3.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                    _builder_3.append("[");
                    _builder_3.append(SMCodeGeneratorConstants.ACTIVE_ROOT_STATE_ID, "");
                    _builder_3.append("].");
                    _builder_3.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                    _builder_3.append("[");
                    Region _container_1 = ((FinalState)innermost).getContainer();
                    State _state = _container_1.getState();
                    EList _regions = _state.getRegions();
                    Region _container_2 = ((FinalState)innermost).getContainer();
                    int _indexOf_1 = _regions.indexOf((Object)_container_2);
                    _builder_3.append((Object)_indexOf_1, "");
                    _builder_3.append("] = ");
                    _builder_3.append(SMCodeGeneratorConstants.STATE_MAX, "");
                    _builder_3.append(";");
                    _builder_3.newLineIfNotEmpty();
                    String _generateCompletionCall = this.core.generateCompletionCall((State)innermost);
                    _builder_3.append(_generateCompletionCall, "");
                    _builder_3.newLineIfNotEmpty();
                }
            } else {
                String _generateEnteringOnSubVertex = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_3.append(_generateEnteringOnSubVertex, "");
                _builder_3.newLineIfNotEmpty();
                _builder_3.append("\t\t\t");
            }
            bodyInside = _builder_3.toString();
        } else {
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append(bodyInside, "");
            _builder_4.newLineIfNotEmpty();
            if (cpEn instanceof State) {
                String _generateEnteringOnSubVertex_1 = this.core.generateEnteringOnSubVertex((State)cpEn, innermost);
                _builder_4.append(_generateEnteringOnSubVertex_1, "");
                _builder_4.newLineIfNotEmpty();
            } else {
                String _generatePseudo = this.core.pseudostateGenerator.generatePseudo((Pseudostate)innermost);
                _builder_4.append(_generatePseudo, "");
                _builder_4.newLineIfNotEmpty();
                _builder_4.append("\t\t\t");
            }
            bodyInside = _builder_4.toString();
        }
        StringConcatenation _builder_5 = new StringConcatenation();
        boolean bl2 = _notEquals_2 = !Objects.equal((Object)join, null);
        if (_notEquals_2) {
            _builder_5.append("if (");
            EList _incomings_1 = join.getIncomings();
            Functions.Function1<Transition, Vertex> _function_2 = new Functions.Function1<Transition, Vertex>(){

                public Vertex apply(Transition it) {
                    return it.getSource();
                }
            };
            List _map = ListExtensions.map((List)_incomings_1, (Functions.Function1)_function_2);
            boolean _hasElements_1 = false;
            for (Vertex src : _map) {
                if (!_hasElements_1) {
                    _hasElements_1 = true;
                } else {
                    _builder_5.appendImmediate((Object)" && ", "");
                }
                _builder_5.append("(");
                _builder_5.append(SMCodeGeneratorConstants.STATE_ARRAY_ATTRIBUTE, "");
                _builder_5.append("[");
                Region _container_3 = src.getContainer();
                State _state_1 = _container_3.getState();
                String _name_2 = _state_1.getName();
                String _upperCase = _name_2.toUpperCase();
                _builder_5.append(_upperCase, "");
                _builder_5.append("_ID].");
                _builder_5.append(SMCodeGeneratorConstants.ACTIVE_SUB_STATES, "");
                _builder_5.append("[");
                Region _container_4 = src.getContainer();
                State _state_2 = _container_4.getState();
                EList _regions_1 = _state_2.getRegions();
                Region _container_5 = src.getContainer();
                int _indexOf_2 = _regions_1.indexOf((Object)_container_5);
                _builder_5.append((Object)_indexOf_2, "");
                _builder_5.append("] == ");
                String _name_3 = src.getName();
                String _upperCase_1 = _name_3.toUpperCase();
                _builder_5.append(_upperCase_1, "");
                _builder_5.append("_ID)");
            }
            _builder_5.append(") {");
            _builder_5.newLineIfNotEmpty();
        }
        _builder_5.append("\t");
        _builder_5.append(bodyInside, "\t");
        _builder_5.newLineIfNotEmpty();
        boolean bl3 = _notEquals_3 = !Objects.equal((Object)join, null);
        if (_notEquals_3) {
            _builder_5.append("}");
            _builder_5.newLine();
        }
        ret = _builder_5.toString();
        return ret;
    }

    public boolean calculateExitsEnters(Transition t, List<Vertex> exits, List<Vertex> enters) {
        boolean _xblockexpression = false;
        ArrayList<Object> tp1 = new ArrayList<Object>();
        Vertex _source = t.getSource();
        List<State> _transitiveParentStates = this.core.getTransitiveParentStates(_source);
        tp1.addAll(_transitiveParentStates);
        Vertex _source_1 = t.getSource();
        tp1.add(0, _source_1);
        ArrayList<Object> tp2 = new ArrayList<Object>();
        Vertex _target = t.getTarget();
        List<State> _transitiveParentStates_1 = this.core.getTransitiveParentStates(_target);
        tp2.addAll(_transitiveParentStates_1);
        Vertex _target_1 = t.getTarget();
        tp2.add(0, _target_1);
        Vertex bound1 = null;
        Vertex bound2 = null;
        for (final Vertex vertex : tp1) {
            boolean _notEquals;
            boolean _equals_1;
            Functions.Function1<Vertex, Boolean> _function = new Functions.Function1<Vertex, Boolean>(){

                public Boolean apply(Vertex it) {
                    Region _container = it.getContainer();
                    Region _container_1 = vertex.getContainer();
                    return Objects.equal((Object)_container, (Object)_container_1);
                }
            };
            Iterable _filter = IterableExtensions.filter(tp2, (Functions.Function1)_function);
            Vertex tp = (Vertex)IterableExtensions.head((Iterable)_filter);
            boolean _and = false;
            boolean _and_1 = false;
            boolean _equals = Objects.equal(bound1, null);
            _and_1 = !_equals ? false : (_equals_1 = Objects.equal(bound2, null));
            _and = !_and_1 ? false : (_notEquals = !Objects.equal((Object)tp, null));
            if (!_and) continue;
            bound1 = vertex;
            bound2 = tp;
        }
        int n = tp1.indexOf(bound1);
        int index2 = tp2.indexOf(bound2);
        List _subList = tp1.subList(0, n + 1);
        exits.addAll(_subList);
        List _subList_1 = tp2.subList(0, index2 + 1);
        _xblockexpression = enters.addAll(_subList_1);
        return _xblockexpression;
    }
}

