/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.core.templates;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.extensions.ITextTemplate;
import org.eclipse.papyrus.designer.transformation.extensions.TextTemplateExt;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class TextTemplateBinding {
    public static final String TEMPLATE_MAGIC = "!template";
    private static final String NAME_IN_BRACKETS = "[name/]";
    private static final String NAME_IN_BRACKETS_SIMPLE = "[name]";

    public static String bind(String templateStr, Element element) throws TransformationException {
        return TextTemplateBinding.bind(templateStr, element, null);
    }

    public static String bind(String templateStr, Element element, Object[] args) throws TransformationException {
        if (templateStr.startsWith(TEMPLATE_MAGIC)) {
            return TextTemplateBinding.bindTemplate(templateStr, element, args);
        }
        if (element instanceof NamedElement) {
            String name = ((NamedElement)element).getName();
            if (templateStr.contains(NAME_IN_BRACKETS)) {
                return templateStr.replace(NAME_IN_BRACKETS, name);
            }
            if (templateStr.contains(NAME_IN_BRACKETS_SIMPLE)) {
                return templateStr.replace(NAME_IN_BRACKETS_SIMPLE, name);
            }
        }
        return templateStr;
    }

    public static String bindTemplate(String templateStr, Element element, Object[] args) throws TransformationException {
        String[] templateRef = templateStr.substring(TEMPLATE_MAGIC.length() + 1).split("\\.");
        String templateId = templateRef[0].trim();
        String methodName = templateRef[1].trim();
        ITextTemplate generator = TextTemplateExt.getTextTemplate((String)templateId);
        if (generator == null) {
            throw new TransformationException(String.format(Messages.TextTemplateBinding_TemplateNotFound, templateId, methodName));
        }
        try {
            Object result;
            if (args != null) {
                Method method = TextTemplateBinding.getMethod(generator, methodName, 1 + args.length);
                result = method.invoke((Object)generator, element, args);
            } else {
                Method method = TextTemplateBinding.getMethod(generator, methodName, 1);
                result = method.invoke((Object)generator, element);
            }
            if (result instanceof String) {
                return (String)result;
            }
            if (result instanceof CharSequence) {
                return result.toString();
            }
            throw new TransformationException(Messages.TextTemplateBinding_TemplateResultIsNotAString);
        }
        catch (IllegalAccessException | IllegalArgumentException | NullPointerException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static Method getMethod(ITextTemplate generator, String methodName, int numberOfArguments) {
        Method[] methodArray = generator.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && method.getParameterTypes().length == numberOfArguments) {
                return method;
            }
            ++n2;
        }
        return null;
    }
}

