/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.transformation.cpp.xtend;

import com.google.common.base.Objects;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.papyrus.designer.components.transformation.PortInfo;
import org.eclipse.papyrus.designer.components.transformation.PortUtils;
import org.eclipse.papyrus.designer.components.transformation.component.PrefixConstants;
import org.eclipse.papyrus.designer.components.transformation.cpp.Messages;
import org.eclipse.papyrus.designer.components.transformation.cpp.xtend.CppUtils;
import org.eclipse.papyrus.designer.components.transformation.extensions.IOOTrafo;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Ptr;
import org.eclipse.papyrus.designer.transformation.base.utils.CopyUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.PartsUtil;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.uml.tools.utils.ConnectorUtil;
import org.eclipse.papyrus.uml.tools.utils.PackageUtil;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.BehavioralFeature;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.EncapsulatedClassifier;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.xtend2.lib.StringConcatenation;

public class DynamicCppToOO
implements IOOTrafo {
    protected LazyCopier copier;
    private static final String PART_MANAGER = "services::PartManager";
    private static final String INIT_PARTS = "initParts";
    private static final String PARTS = "parts";
    private static final String progLang = "C/C++";
    protected Class bootloader;

    public void init(LazyCopier copier, Class bootloader) {
        PrefixConstants.init((PrefixConstants.CIFvariant)PrefixConstants.CIFvariant.UML);
        this.copier = copier;
        this.bootloader = bootloader;
    }

    public void addPortOperations(Class implementation) {
        this.addGetPortOperation(implementation);
        DynamicCppToOO.addConnectPortOperation(implementation);
    }

    public void addGetPortOperation(Class implementation) {
        EList _allPorts2 = PortUtils.getAllPorts2((EncapsulatedClassifier)implementation);
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)_allPorts2);
        for (PortInfo portInfo : _flattenExtendedPorts) {
            boolean _notEquals_3;
            Operation _createOwnedOperation;
            boolean _notEquals_1;
            boolean _notEquals;
            Interface providedIntf = portInfo.getProvided();
            boolean bl = _notEquals = !Objects.equal((Object)providedIntf, null);
            if (!_notEquals) continue;
            String _name = portInfo.getName();
            String opName = String.valueOf(PrefixConstants.getP_Prefix) + _name;
            Operation op = implementation.getOwnedOperation(opName, null, null);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)op, null);
            if (_notEquals_1) {
                boolean _notEquals_2;
                Type _type = op.getType();
                boolean bl3 = _notEquals_2 = !Objects.equal((Object)_type, (Object)providedIntf);
                if (!_notEquals_2) continue;
                op.createOwnedParameter("ret", (Type)providedIntf);
                continue;
            }
            op = _createOwnedOperation = implementation.createOwnedOperation(opName, null, null, (Type)providedIntf);
            EList _ownedParameters = op.getOwnedParameters();
            Parameter retParam = (Parameter)_ownedParameters.get(0);
            retParam.setName("ret");
            StereotypeUtil.apply((Element)retParam, Ptr.class);
            EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, _opaqueBehavior);
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            EList _methods = op.getMethods();
            _methods.add((Object)behavior);
            Port _modelPort = portInfo.getModelPort();
            ConnectorEnd ce = ConnectorUtil.getDelegation((Class)implementation, (Port)_modelPort);
            String body = null;
            boolean bl4 = _notEquals_3 = !Objects.equal((Object)ce, null);
            if (_notEquals_3) {
                Property part = ce.getPartWithPort();
                ConnectableElement role = ce.getRole();
                body = "return ";
                if (role instanceof Port) {
                    String _body = body;
                    StringConcatenation _builder = new StringConcatenation();
                    String _nameRef = CppUtils.nameRef(part);
                    _builder.append(_nameRef, "");
                    _builder.append(PrefixConstants.getP_Prefix, "");
                    String _name_1 = ((Port)role).getName();
                    _builder.append(_name_1, "");
                    _builder.append("();");
                    body = String.valueOf(_body) + _builder;
                } else {
                    String _body_1 = body;
                    String _name_2 = role.getName();
                    body = String.valueOf(_body_1) + _name_2;
                }
            } else {
                boolean implementsIntf;
                InterfaceRealization _interfaceRealization = implementation.getInterfaceRealization(null, providedIntf);
                boolean bl5 = implementsIntf = !Objects.equal((Object)_interfaceRealization, null);
                if (!implementsIntf) {
                    boolean _notEquals_4;
                    Interface providedIntfInCopy = (Interface)this.copier.getCopy((Element)providedIntf);
                    InterfaceRealization _interfaceRealization_1 = implementation.getInterfaceRealization(null, providedIntfInCopy);
                    implementsIntf = _notEquals_4 = !Objects.equal((Object)_interfaceRealization_1, null);
                }
                if (implementsIntf) {
                    body = "return this;";
                } else {
                    String _name_3 = providedIntf.getName();
                    Port _port = portInfo.getPort();
                    String _name_4 = _port.getName();
                    String _name_5 = implementation.getName();
                    String _format = String.format(Messages.CompImplTrafos_IntfNotImplemented, _name_3, _name_4, _name_5);
                    throw new RuntimeException(_format);
                }
            }
            EList _languages = behavior.getLanguages();
            _languages.add((Object)progLang);
            EList _bodies = behavior.getBodies();
            _bodies.add((Object)body);
        }
    }

    public static void addConnectPortOperation(Class implementation) {
        EList _allPorts2 = PortUtils.getAllPorts2((EncapsulatedClassifier)implementation);
        EList _flattenExtendedPorts = PortUtils.flattenExtendedPorts((EList)_allPorts2);
        for (PortInfo portInfo : _flattenExtendedPorts) {
            boolean _notEquals_3;
            boolean _greaterThan_2;
            boolean _notEquals_2;
            int _upper_1;
            boolean _equals;
            boolean _greaterThan;
            boolean _notEquals_1;
            boolean _notEquals;
            Interface requiredIntf = portInfo.getRequired();
            boolean bl = _notEquals = !Objects.equal((Object)requiredIntf, null);
            if (!_notEquals) continue;
            String _name = portInfo.getName();
            String opName = String.valueOf(PrefixConstants.connectQ_Prefix) + _name;
            Operation _ownedOperation = implementation.getOwnedOperation(opName, null, null);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)_ownedOperation, null);
            if (_notEquals_1) continue;
            Operation op = implementation.createOwnedOperation(opName, null, null);
            boolean _or = false;
            int _upper = portInfo.getUpper();
            boolean bl3 = _greaterThan = _upper > 1;
            _or = _greaterThan ? true : (_equals = (_upper_1 = portInfo.getUpper()) == -1);
            boolean multiPort = _or;
            if (multiPort) {
                Package _rootPackage = PackageUtil.getRootPackage((Element)implementation);
                NamedElement eLong = ElementUtils.getQualifiedElementFromRS((Element)_rootPackage, (String)"PrimitiveTypes::Integer");
                if (eLong instanceof Type) {
                    op.createOwnedParameter("index", (Type)eLong);
                } else {
                    String _format = String.format(Messages.CompImplTrafos_CannotFindType, "PrimitiveTypes::Integer");
                    throw new RuntimeException(_format);
                }
            }
            Parameter refParam = op.createOwnedParameter("ref", (Type)requiredIntf);
            StereotypeUtil.apply((Element)refParam, Ptr.class);
            EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior = implementation.createOwnedBehavior(opName, _opaqueBehavior);
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            EList _methods = op.getMethods();
            _methods.add((Object)behavior);
            Port _modelPort = portInfo.getModelPort();
            ConnectorEnd ce = ConnectorUtil.getDelegation((Class)implementation, (Port)_modelPort);
            String body = null;
            boolean bl4 = _notEquals_2 = !Objects.equal((Object)ce, null);
            if (_notEquals_2) {
                String _name_1;
                Property part = ce.getPartWithPort();
                body = _name_1 = part.getName();
                ConnectableElement role = ce.getRole();
                if (role instanceof Port) {
                    int _upper_3;
                    boolean _equals_1;
                    boolean _greaterThan_1;
                    String _name_2 = ((Port)role).getName();
                    String targetOpName = String.valueOf(PrefixConstants.connectQ_Prefix) + _name_2;
                    StringConcatenation _builder = new StringConcatenation();
                    String _nameRef = CppUtils.nameRef(part);
                    _builder.append(_nameRef, "");
                    _builder.append(targetOpName, "");
                    body = _builder.toString();
                    boolean _or_1 = false;
                    int _upper_2 = portInfo.getUpper();
                    boolean bl5 = _greaterThan_1 = _upper_2 > 1;
                    _or_1 = _greaterThan_1 ? true : (_equals_1 = (_upper_3 = portInfo.getUpper()) == -1);
                    if (_or_1) {
                        String _body = body;
                        body = String.valueOf(_body) + "(index, ref);";
                    } else {
                        String _body_1 = body;
                        body = String.valueOf(_body_1) + "(ref);";
                    }
                } else {
                    String _body_2 = body;
                    StringConcatenation _builder_1 = new StringConcatenation();
                    String _name_3 = part.getName();
                    _builder_1.append(_name_3, "");
                    _builder_1.append(";");
                    body = String.valueOf(_body_2) + _builder_1;
                }
            } else {
                String _name_4 = portInfo.getName();
                String attributeName = String.valueOf(PrefixConstants.attributePrefix) + _name_4;
                Property attr = implementation.getOwnedAttribute(attributeName, null);
                boolean _or_2 = false;
                boolean _equals_2 = Objects.equal((Object)attr, null);
                _or_2 = _equals_2 ? true : attr instanceof Port;
                if (_or_2) {
                    Property _createOwnedAttribute;
                    attr = _createOwnedAttribute = implementation.createOwnedAttribute(attributeName, (Type)requiredIntf);
                    Port _port = portInfo.getPort();
                    CopyUtils.copyMultElemModifiers((MultiplicityElement)_port, (MultiplicityElement)attr);
                    attr.setAggregation(AggregationKind.SHARED_LITERAL);
                }
                body = attributeName;
                if (multiPort) {
                    String _body_3 = body;
                    body = String.valueOf(_body_3) + "[index]";
                }
                String _body_4 = body;
                body = String.valueOf(_body_4) + " = ref;";
            }
            EList _languages = behavior.getLanguages();
            _languages.add((Object)progLang);
            EList _bodies = behavior.getBodies();
            _bodies.add((Object)body);
            boolean _and = false;
            int _length = PrefixConstants.getConnQ_Prefix.length();
            boolean bl6 = _greaterThan_2 = _length > 0;
            _and = !_greaterThan_2 ? false : (_notEquals_3 = !Objects.equal((Object)ce, null));
            if (!_and) continue;
            String _name_5 = portInfo.getName();
            String getConnOpName = String.valueOf(PrefixConstants.getConnQ_Prefix) + _name_5;
            Operation getConnOp = implementation.getOwnedOperation(getConnOpName, null, null);
            boolean _equals_3 = Objects.equal((Object)getConnOp, null);
            if (_equals_3) {
                Operation _createOwnedOperation;
                getConnOp = _createOwnedOperation = implementation.createOwnedOperation(getConnOpName, null, null, (Type)requiredIntf);
                EList _ownedParameters = op.getOwnedParameters();
                Parameter retParam = (Parameter)_ownedParameters.get(0);
                retParam.setName("ret");
                StereotypeUtil.apply((Element)retParam, Ptr.class);
            }
            EClass _opaqueBehavior_1 = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior_1 = implementation.createOwnedBehavior(getConnOpName, _opaqueBehavior_1);
            OpaqueBehavior getConnBehavior = (OpaqueBehavior)_createOwnedBehavior_1;
            EList _methods_1 = getConnOp.getMethods();
            _methods_1.add((Object)getConnBehavior);
            String _name_6 = portInfo.getName();
            String name = String.valueOf(PrefixConstants.attributePrefix) + _name_6;
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("return ");
            _builder_2.append(name, "");
            _builder_2.append(";");
            body = _builder_2.toString();
            EList _languages_1 = behavior.getLanguages();
            _languages_1.add((Object)progLang);
            EList _bodies_1 = behavior.getBodies();
            _bodies_1.add((Object)body);
        }
    }

    public void addConnectionOperation(Class compositeImplementation) throws TransformationException {
        boolean _greaterThan;
        String createConnBody = "";
        HashMap<ConnectorEnd, Integer> indexMap = new HashMap<ConnectorEnd, Integer>();
        EList _ownedConnectors = compositeImplementation.getOwnedConnectors();
        for (Connector connector : _ownedConnectors) {
            boolean _notEquals;
            boolean _isAssembly = ConnectorUtil.isAssembly((Connector)connector);
            if (!_isAssembly) continue;
            EList _ends = connector.getEnds();
            int _size = _ends.size();
            boolean bl = _notEquals = _size != 2;
            if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Connector <");
                String _name = connector.getName();
                _builder.append(_name, "");
                _builder.append("> does not have two ends. This is currently not supported");
                throw new TransformationException(_builder.toString());
            }
            EList _ends_1 = connector.getEnds();
            ConnectorEnd end1 = (ConnectorEnd)_ends_1.get(0);
            EList _ends_2 = connector.getEnds();
            ConnectorEnd end2 = (ConnectorEnd)_ends_2.get(1);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("// realization of connector <");
            String _name_1 = connector.getName();
            _builder_1.append(_name_1, "");
            _builder_1.append(">\\n");
            String cmd = _builder_1.toString();
            boolean _and = false;
            ConnectableElement _role = end1.getRole();
            if (!(_role instanceof Port)) {
                _and = false;
            } else {
                boolean _isExtendedPort;
                ConnectableElement _role_1 = end1.getRole();
                _and = _isExtendedPort = PortUtils.isExtendedPort((Port)((Port)_role_1));
            }
            if (_and) {
                ConnectableElement _role_2 = end1.getRole();
                Port port = (Port)_role_2;
                EList subPorts = PortUtils.flattenExtendedPort((Port)port);
                for (PortInfo subPort : subPorts) {
                    String _cmd = cmd;
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("  ");
                    _builder_2.append("// realization of connection for sub-port ");
                    Port _port = subPort.getPort();
                    String _name_2 = _port.getName();
                    _builder_2.append(_name_2, "  ");
                    _builder_2.append("\\n");
                    String _cmd_1 = cmd = String.valueOf(_cmd) + _builder_2;
                    Port _port_1 = subPort.getPort();
                    String _connectPorts = DynamicCppToOO.connectPorts(indexMap, connector, end1, end2, _port_1);
                    String _cmd_2 = cmd = String.valueOf(_cmd_1) + _connectPorts;
                    Port _port_2 = subPort.getPort();
                    String _connectPorts_1 = DynamicCppToOO.connectPorts(indexMap, connector, end2, end1, _port_2);
                    cmd = String.valueOf(_cmd_2) + _connectPorts_1;
                }
            } else {
                String _cmd = cmd;
                String _connectPorts = DynamicCppToOO.connectPorts(indexMap, connector, end1, end2, null);
                String _cmd_1 = cmd = String.valueOf(_cmd) + _connectPorts;
                String _connectPorts_1 = DynamicCppToOO.connectPorts(indexMap, connector, end2, end1, null);
                cmd = String.valueOf(_cmd_1) + _connectPorts_1;
            }
            String _createConnBody = createConnBody;
            createConnBody = String.valueOf(_createConnBody) + cmd + "\n";
        }
        int _length = createConnBody.length();
        boolean bl = _greaterThan = _length > 0;
        if (_greaterThan) {
            Operation operation = compositeImplementation.createOwnedOperation("createConnections", null, null);
            String _name_2 = operation.getName();
            EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
            Behavior _createOwnedBehavior = compositeImplementation.createOwnedBehavior(_name_2, _opaqueBehavior);
            OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
            EList _languages = behavior.getLanguages();
            _languages.add((Object)progLang);
            EList _bodies = behavior.getBodies();
            _bodies.add((Object)createConnBody);
            behavior.setSpecification((BehavioralFeature)operation);
        }
    }

    public static String connectPorts(Map<ConnectorEnd, Integer> indexMap, Connector connector, ConnectorEnd receptacleEnd, ConnectorEnd facetEnd, Port subPort) throws TransformationException {
        Association association = connector.getType();
        boolean _and = false;
        ConnectableElement _role = receptacleEnd.getRole();
        if (!(_role instanceof Port)) {
            _and = false;
        } else {
            ConnectableElement _role_1 = facetEnd.getRole();
            _and = _role_1 instanceof Port;
        }
        if (_and) {
            Interface _required;
            boolean _notEquals_1;
            boolean _notEquals;
            ConnectableElement _role_2 = facetEnd.getRole();
            Port facetPort = (Port)_role_2;
            ConnectableElement _role_3 = receptacleEnd.getRole();
            Port receptaclePort = (Port)_role_3;
            PortInfo facetPI = PortInfo.fromSubPort((Port)facetPort, (Port)subPort);
            PortInfo receptaclePI = PortInfo.fromSubPort((Port)receptaclePort, (Port)subPort);
            boolean _and_1 = false;
            Interface _provided = facetPI.getProvided();
            boolean bl = _notEquals = !Objects.equal((Object)_provided, null);
            _and_1 = !_notEquals ? false : (_notEquals_1 = !Objects.equal((Object)(_required = receptaclePI.getRequired()), null));
            if (_and_1) {
                boolean _notEquals_2;
                Property facetPart = facetEnd.getPartWithPort();
                Property receptaclePart = receptacleEnd.getPartWithPort();
                String subPortName = "";
                boolean bl2 = _notEquals_2 = !Objects.equal((Object)subPort, null);
                if (_notEquals_2) {
                    String _subPortName = subPortName;
                    String _name = subPort.getName();
                    String _plus = "_" + _name;
                    subPortName = String.valueOf(_subPortName) + _plus;
                }
                String indexName = DynamicCppToOO.getIndexName(indexMap, receptaclePort, receptacleEnd);
                StringConcatenation _builder = new StringConcatenation();
                String _nameRef = CppUtils.nameRef(receptaclePart);
                _builder.append(_nameRef, "");
                _builder.append("connect_");
                String _name_1 = receptaclePort.getName();
                _builder.append(_name_1, "");
                _builder.append(" ");
                _builder.append(subPortName, "");
                _builder.append(";");
                String setter = _builder.toString();
                StringConcatenation _builder_1 = new StringConcatenation();
                String _nameRef_1 = CppUtils.nameRef(facetPart);
                _builder_1.append(_nameRef_1, "");
                _builder_1.append("get_");
                String _name_2 = facetPort.getName();
                _builder_1.append(_name_2, "");
                _builder_1.append(" ");
                _builder_1.append(subPortName, "");
                _builder_1.append("()");
                String getter = _builder_1.toString();
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(setter, "");
                _builder_2.append("(");
                _builder_2.append(indexName, "");
                _builder_2.append(getter, "");
                _builder_2.append(");\\n");
                return _builder_2.toString();
            }
        } else {
            ConnectableElement _role_4 = receptacleEnd.getRole();
            if (_role_4 instanceof Port) {
                boolean _notEquals_3;
                ConnectableElement _role_5 = receptacleEnd.getRole();
                Port receptaclePort_1 = (Port)_role_5;
                Interface _required_1 = PortUtils.getRequired((Port)receptaclePort_1);
                boolean bl = _notEquals_3 = !Objects.equal((Object)_required_1, null);
                if (_notEquals_3) {
                    ConnectableElement _role_6 = facetEnd.getRole();
                    Property facetPart_1 = (Property)_role_6;
                    Property receptaclePart_1 = facetEnd.getPartWithPort();
                    String indexName_1 = DynamicCppToOO.getIndexName(indexMap, receptaclePort_1, receptacleEnd);
                    StringConcatenation _builder_3 = new StringConcatenation();
                    String _nameRef_2 = CppUtils.nameRef(receptaclePart_1);
                    _builder_3.append(_nameRef_2, "");
                    _builder_3.append("connect_");
                    String _name_3 = receptaclePort_1.getName();
                    _builder_3.append(_name_3, "");
                    String setter_1 = _builder_3.toString();
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("&");
                    String _name_4 = facetPart_1.getName();
                    _builder_4.append(_name_4, "");
                    String getter_1 = _builder_4.toString();
                    StringConcatenation _builder_5 = new StringConcatenation();
                    _builder_5.append(setter_1, "");
                    _builder_5.append("(");
                    _builder_5.append(indexName_1, "");
                    _builder_5.append(getter_1, "");
                    _builder_5.append(");\\n");
                    return _builder_5.toString();
                }
            } else {
                ConnectableElement _role_7 = facetEnd.getRole();
                if (_role_7 instanceof Port) {
                    boolean _notEquals_4;
                    ConnectableElement _role_8 = facetEnd.getRole();
                    Port facetPort_1 = (Port)_role_8;
                    Interface _provided_1 = PortUtils.getProvided((Port)facetPort_1);
                    boolean bl = _notEquals_4 = !Objects.equal((Object)_provided_1, null);
                    if (_notEquals_4) {
                        Property facetPart_2 = facetEnd.getPartWithPort();
                        ConnectableElement _role_9 = facetEnd.getRole();
                        Property receptaclePart_2 = (Property)_role_9;
                        String setter_2 = receptaclePart_2.getName();
                        StringConcatenation _builder_6 = new StringConcatenation();
                        String _nameRef_3 = CppUtils.nameRef(facetPart_2);
                        _builder_6.append(_nameRef_3, "");
                        _builder_6.append("get_");
                        String _name_5 = facetPort_1.getName();
                        _builder_6.append(_name_5, "");
                        _builder_6.append("();");
                        String getter_2 = _builder_6.toString();
                        StringConcatenation _builder_7 = new StringConcatenation();
                        _builder_7.append(setter_2, "");
                        _builder_7.append(" = ");
                        _builder_7.append(getter_2, "");
                        _builder_7.append(";\\n");
                        return _builder_7.toString();
                    }
                } else {
                    boolean _notEquals_5;
                    boolean bl = _notEquals_5 = !Objects.equal((Object)association, null);
                    if (_notEquals_5) {
                        boolean _isNavigable;
                        ConnectableElement _role_10 = facetEnd.getRole();
                        Property facetPart_3 = (Property)_role_10;
                        ConnectableElement _role_11 = receptacleEnd.getRole();
                        Property receptaclePart_3 = (Property)_role_11;
                        Type _type = facetPart_3.getType();
                        Property assocProp1 = association.getMemberEnd(null, _type);
                        boolean _and_2 = false;
                        boolean _notEquals_6 = !Objects.equal((Object)assocProp1, null);
                        _and_2 = !_notEquals_6 ? false : (_isNavigable = assocProp1.isNavigable());
                        if (_and_2) {
                            StringConcatenation _builder_8 = new StringConcatenation();
                            String _nameRef_4 = CppUtils.nameRef(receptaclePart_3);
                            _builder_8.append(_nameRef_4, "");
                            String _name_6 = assocProp1.getName();
                            _builder_8.append(_name_6, "");
                            String setter_3 = _builder_8.toString();
                            StringConcatenation _builder_9 = new StringConcatenation();
                            _builder_9.append("&");
                            String _name_7 = facetPart_3.getName();
                            _builder_9.append(_name_7, "");
                            String getter_3 = _builder_9.toString();
                            StringConcatenation _builder_10 = new StringConcatenation();
                            _builder_10.append(setter_3, "");
                            _builder_10.append(" = ");
                            _builder_10.append(getter_3, "");
                            _builder_10.append(";\\n");
                            return _builder_10.toString();
                        }
                    } else {
                        String _name_8 = connector.getName();
                        String _plus_1 = "Connector <" + _name_8;
                        String _plus_2 = String.valueOf(_plus_1) + "> does not use ports, but it is not typed (only connectors between ports should not be typed)";
                        throw new TransformationException(_plus_2);
                    }
                }
            }
        }
        return "";
    }

    public static String getIndexName(Map<ConnectorEnd, Integer> indexMap, Port port, ConnectorEnd end) {
        int _upper_1;
        boolean _equals;
        boolean _greaterThan;
        boolean _or = false;
        int _upper = port.getUpper();
        boolean bl = _greaterThan = _upper > 1;
        _or = _greaterThan ? true : (_equals = (_upper_1 = port.getUpper()) == -1);
        if (_or) {
            Integer indexValue = indexMap.get(end);
            boolean _equals_1 = Objects.equal((Object)indexValue, null);
            if (_equals_1) {
                indexValue = 0;
                indexMap.put(end, indexValue);
            }
            String index = indexValue + ", ";
            indexValue = indexValue + 1;
            indexMap.put(end, indexValue);
            return index;
        }
        return "";
    }

    public void transformParts(Class compositeImplementation) {
        String initPartsBody = "";
        EList _parts = PartsUtil.getParts((Class)compositeImplementation);
        for (Property attribute : _parts) {
            Type type = attribute.getType();
            if (!(type instanceof Class)) continue;
            String _initPartsBody = initPartsBody;
            String _initPartBody = this.initPartBody(attribute);
            initPartsBody = String.valueOf(_initPartsBody) + _initPartBody;
            attribute.destroy();
        }
        NamedElement partManager = ElementUtils.getQualifiedElementFromRS((Element)compositeImplementation, (String)PART_MANAGER);
        if (partManager instanceof Type) {
            compositeImplementation.createOwnedAttribute(PARTS, (Type)partManager);
        }
        Operation operation = compositeImplementation.createOwnedOperation(INIT_PARTS, null, null);
        String _name = operation.getName();
        String _plus = "b:" + _name;
        EClass _opaqueBehavior = UMLPackage.eINSTANCE.getOpaqueBehavior();
        Behavior _createOwnedBehavior = compositeImplementation.createOwnedBehavior(_plus, _opaqueBehavior);
        OpaqueBehavior behavior = (OpaqueBehavior)_createOwnedBehavior;
        EList _languages = behavior.getLanguages();
        _languages.add((Object)progLang);
        EList _bodies = behavior.getBodies();
        _bodies.add((Object)initPartsBody);
    }

    public String initPartBody(Property part) {
        String _name = part.getName();
        String _plus = "parts.add(" + _name;
        String _plus_1 = String.valueOf(_plus) + ", ";
        Type _type = part.getType();
        String _plus_2 = String.valueOf(_plus_1) + _type;
        return String.valueOf(_plus_2) + ")";
    }
}

