/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.transformation.languages.java.library;

import java.util.List;
import java.util.Stack;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.languages.common.base.ElementUtils;
import org.eclipse.papyrus.designer.languages.java.profile.PapyrusJava.Import;
import org.eclipse.papyrus.designer.transformation.base.utils.LibraryUtils;
import org.eclipse.papyrus.designer.transformation.base.utils.ModelManagement;
import org.eclipse.papyrus.designer.transformation.base.utils.TransformationException;
import org.eclipse.papyrus.designer.transformation.core.Messages;
import org.eclipse.papyrus.designer.transformation.core.m2minterfaces.IM2MTrafoCDP;
import org.eclipse.papyrus.designer.transformation.core.transformations.LazyCopier;
import org.eclipse.papyrus.designer.transformation.core.transformations.TransformationContext;
import org.eclipse.papyrus.designer.transformation.library.transformations.AbstractBootLoaderGen;
import org.eclipse.papyrus.designer.transformation.profile.Transformation.M2MTrafo;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.LiteralInteger;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class BootLoaderGenJava
extends AbstractBootLoaderGen
implements IM2MTrafoCDP {
    public static final URI JAVA_BOOTLOADER_URI = URI.createURI((String)"pathmap://DML_TRAFOS_JAVA/BootLoaderJava.uml");
    public static final String JAVA_BOOTLOADER_QNAME = "BootLoaderJava::BootLoader";
    public static final String JAVA_NODEINFO_QNAME = "BootLoaderJava::NodeInfo";

    public void init(LazyCopier copier, int nodeIndex, int numberOfNodes) throws TransformationException {
        super.init(copier, nodeIndex, numberOfNodes);
        Element _content = LibraryUtils.getContent((URI)JAVA_BOOTLOADER_URI, (ResourceSet)ModelManagement.getResourceSet());
        Package bootloader_ml = (Package)_content;
        NamedElement _qualifiedElement = ElementUtils.getQualifiedElement((Package)bootloader_ml, (String)JAVA_BOOTLOADER_QNAME);
        Class template = (Class)_qualifiedElement;
        if (template == null) {
            String _format = String.format(Messages.BootLoaderGen_CannotRetrieveTemplate, JAVA_BOOTLOADER_QNAME);
            throw new TransformationException(_format);
        }
        this.m_bootLoader = (Class)copier.getCopy((Element)template);
        Import javaImport = (Import)StereotypeUtil.applyApp((Element)this.m_bootLoader, Import.class);
        if (javaImport == null) {
            throw new TransformationException("Cannot apply javaImport stereotype. Make sure that the Java profile is applied to your model.");
        }
        NamedElement _qualifiedElement_1 = ElementUtils.getQualifiedElement((Package)bootloader_ml, (String)JAVA_NODEINFO_QNAME);
        Class nodeInfo = (Class)_qualifiedElement_1;
        Class nodeInfoCopy = (Class)copier.getCopy((Element)nodeInfo);
        Property nodeIndexElem = nodeInfoCopy.getAttribute("nodeIndex", null);
        Property numberOfNodesElem = nodeInfoCopy.getAttribute("numberOfNodes", null);
        ValueSpecification _defaultValue = nodeIndexElem.getDefaultValue();
        ((LiteralInteger)_defaultValue).setValue(nodeIndex + 0);
        ValueSpecification _defaultValue_1 = numberOfNodesElem.getDefaultValue();
        ((LiteralInteger)_defaultValue_1).setValue(numberOfNodes);
    }

    public String languageCreateInstance(InstanceSpecification is, Class implementation) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = is.getName();
        _builder.append(_name);
        _builder.append(" = new ");
        String _name_1 = implementation.getName();
        _builder.append(_name_1);
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String languageCreateConn(String varName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(varName);
        _builder.append(".");
        _builder.append("createConnections");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public String languageRunStart(String varName, boolean useOO) {
        StringConcatenation _builder = new StringConcatenation();
        if (useOO) {
            _builder.append(varName);
            _builder.append(".run();");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append(varName);
            _builder.append(".get_start().run();");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    public String languageAssignRef(String accessName, String referenceVarName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(accessName);
        _builder.append(" = ");
        _builder.append(referenceVarName);
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }

    public void instanceConfig(Stack<Slot> slotPath, InstanceSpecification instance) throws TransformationException {
        Slot slot = slotPath.peek();
        StructuralFeature sf = slot.getDefiningFeature();
        if (sf == null) {
            String _format = String.format("A slot for instance %s has no defining feature", instance.getName());
            throw new TransformationException(_format);
        }
        Classifier implementation = DepUtils.getClassifier((InstanceSpecification)instance);
        boolean _instantiateViaBootloader = this.instantiateViaBootloader(sf);
        if (_instantiateViaBootloader) {
            String _m_initCodeCConfig = this.m_initCodeCConfig;
            StringConcatenation _builder = new StringConcatenation();
            String _name = instance.getName();
            _builder.append(_name);
            _builder.append(" = new ");
            String _replace = implementation.getQualifiedName().replace("::", ".");
            _builder.append(_replace);
            _builder.append("();");
            String _plus = String.valueOf(_builder.toString()) + "\n";
            this.m_initCodeCConfig = String.valueOf(_m_initCodeCConfig) + _plus;
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        String _name_1 = instance.getName();
        _builder_1.append(_name_1);
        _builder_1.append(".");
        String _name_2 = sf.getName();
        _builder_1.append(_name_2);
        String varName = _builder_1.toString();
        EList _values = slot.getValues();
        for (ValueSpecification value : _values) {
            boolean _tripleNotEquals;
            String _stringValue = value.stringValue();
            boolean bl = _tripleNotEquals = _stringValue != null;
            if (!_tripleNotEquals) continue;
            String _m_initCodeCConfig_1 = this.m_initCodeCConfig;
            String _stringValue_1 = value.stringValue();
            String _plus_1 = String.valueOf(varName) + " = " + _stringValue_1;
            String _plus_2 = String.valueOf(_plus_1) + ";\n";
            this.m_initCodeCConfig = String.valueOf(_m_initCodeCConfig_1) + _plus_2;
        }
    }

    public void applyTrafo(M2MTrafo trafo, Package deploymentPlan) throws TransformationException {
        this.init(TransformationContext.current.copier, 0, 0);
        Stack slotPath = new Stack();
        EList _topLevelInstances = DepUtils.getTopLevelInstances((Package)deploymentPlan);
        for (InstanceSpecification is : _topLevelInstances) {
            this.addInstance(is, slotPath);
        }
        this.addInit("Java");
    }

    public void languageInit() {
    }

    public String languageActivation(Class[] activationKeys) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("// activation code");
        _builder.newLine();
        Class[] classArray = activationKeys;
        int n = activationKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Class implementation = classArray[n2];
            EList varNameList = (EList)this.m_activation.get(implementation);
            _builder.newLineIfNotEmpty();
            for (String varName : varNameList) {
                _builder.append(varName);
                _builder.append(".activate();");
                _builder.newLineIfNotEmpty();
            }
            ++n2;
        }
        return _builder.toString();
    }

    public String languageDeactivation(Class[] activationKeys) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.newLine();
        _builder.append("// deactivation code (reverse order)");
        _builder.newLine();
        List _reverse = ListExtensions.reverse((List)((List)Conversions.doWrapArray((Object)activationKeys)));
        for (Class implementation : _reverse) {
            EList varNameList = (EList)this.m_activation.get(implementation);
            _builder.newLineIfNotEmpty();
            for (String varName : varNameList) {
                _builder.append(varName);
                _builder.append(".deactivate();");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder.toString();
    }

    public String languageDefaultExecCode() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Thread.sleep();");
        _builder.newLine();
        return _builder.toString();
    }
}

