/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.monitoring.sm.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Pseudostate;
import org.eclipse.uml2.uml.PseudostateKind;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Vertex;

public class StateMachineModel {
    private Map<String, Transition> transitionMap = new HashMap<String, Transition>();
    private Map<String, State> stateMap = new HashMap<String, State>();
    private List<State> initialStates = new ArrayList<State>();
    private Set<StateMachine> stateMachines = new HashSet<StateMachine>();

    public StateMachineModel(Model model) {
        for (Element element : model.allOwnedElements()) {
            Pseudostate pseudoState;
            if (!(element instanceof NamedElement)) continue;
            String qualifiedName = ((NamedElement)element).getQualifiedName();
            if (element instanceof Transition) {
                if (qualifiedName != null && !qualifiedName.isEmpty()) {
                    this.transitionMap.put(qualifiedName, (Transition)element);
                }
                this.stateMachines.add(((Transition)element).containingStateMachine());
            }
            if (element instanceof State) {
                if (qualifiedName != null && !qualifiedName.isEmpty()) {
                    this.stateMap.put(qualifiedName, (State)element);
                }
                this.stateMachines.add(((State)element).containingStateMachine());
            }
            if (!(element instanceof Pseudostate) || !(pseudoState = (Pseudostate)element).getKind().equals((Object)PseudostateKind.INITIAL_LITERAL)) continue;
            for (Transition transition : pseudoState.getOutgoings()) {
                Vertex target = transition.getTarget();
                if (!(target instanceof State)) continue;
                this.initialStates.add((State)target);
                this.stateMachines.add(((State)target).containingStateMachine());
            }
        }
    }

    public Map<String, Transition> getTransitionMap() {
        return this.transitionMap;
    }

    public void setTransitionMap(HashMap<String, Transition> transitionMap) {
        this.transitionMap = transitionMap;
    }

    public Map<String, State> getStateMap() {
        return this.stateMap;
    }

    public void setStateMap(HashMap<String, State> stateMap) {
        this.stateMap = stateMap;
    }

    public List<State> getInitialStates() {
        return this.initialStates;
    }

    public void setInitialStates(List<State> initialStates) {
        this.initialStates = initialStates;
    }

    public Set<StateMachine> getStateMachines() {
        return this.stateMachines;
    }

    public void setStateMachines(HashSet<StateMachine> stateMachines) {
        this.stateMachines = stateMachines;
    }
}

