/**
 * Copyright (c) 2019 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.ListHint;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.TemplateBinding;
import org.eclipse.papyrus.designer.languages.common.profile.TemplateBindingConstants;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.Modifier;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.TypedElement;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * Produce the string for a typed element, taking the ListHint and TemplateBinding stereotype
 * into account
 */
@SuppressWarnings("all")
public class CppTypedElement {
  /**
   * Handle list types
   * @see Modifier (modArray) - in addition to this method. modArray is handling
   * 	multiplicity via modifiers after the variable declaration (e.g. A a[]) if listHint
   *  is NOT applied
   * TODO: refactor code that both aspects (listHint applied or default handling) are done
   *        in the same place
   * @param propertyOrParameter
   *            a property or parameter (in both cases a typed element)
   * @return a string representation of the type of a property or parameter. The function takes
   *         list hints into account in case of non 1 multiplicity
   */
  public static String cppType(final TypedElement propertyOrParameter) {
    String type = null;
    String defaultType = CppGenUtils.cgu(propertyOrParameter).cppQualifiedName(propertyOrParameter.getType());
    final TemplateBinding binding = UMLUtil.<TemplateBinding>getStereotypeApplication(propertyOrParameter, TemplateBinding.class);
    if ((binding != null)) {
      String _defaultType = defaultType;
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("<");
      {
        EList<Type> _actuals = binding.getActuals();
        boolean _hasElements = false;
        for(final Type actual : _actuals) {
          if (!_hasElements) {
            _hasElements = true;
          } else {
            _builder.appendImmediate(",", "");
          }
          String _cppQualifiedName = CppGenUtils.cgu(propertyOrParameter).cppQualifiedName(actual);
          _builder.append(_cppQualifiedName);
        }
      }
      _builder.append(">");
      defaultType = (_defaultType + _builder);
    }
    final ListHint listHint = GenUtils.<ListHint>getApplicationTree(propertyOrParameter, ListHint.class);
    final int lower = ((MultiplicityElement) propertyOrParameter).getLower();
    final int upper = ((MultiplicityElement) propertyOrParameter).getUpper();
    if ((listHint != null)) {
      if ((upper == (-1))) {
        type = listHint.getVariable();
      } else {
        if ((upper > 1)) {
          if ((upper == lower)) {
            type = listHint.getFixed();
          } else {
            type = listHint.getBounded();
          }
        }
      }
    }
    if ((type != null)) {
      return type.replace(TemplateBindingConstants.TYPE_NAME_TAG, defaultType).replace(TemplateBindingConstants.LOWER, String.format("%d", Integer.valueOf(lower))).replace(TemplateBindingConstants.UPPER, String.format("%d", Integer.valueOf(upper)));
    } else {
      return defaultType;
    }
  }
}
