/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import java.util.regex.Pattern;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.StateMachineScript;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtend2.lib.StringConcatenation;

public class AcslScript {
    public static String ACSL = "ACSL";

    public static String getACSLConstraint(Constraint constraint) {
        String constraintText = "";
        ValueSpecification _specification = constraint.getSpecification();
        if (_specification instanceof OpaqueExpression) {
            int _size_1;
            boolean _equals;
            ValueSpecification _specification_1 = constraint.getSpecification();
            OpaqueExpression opaqueExpression = (OpaqueExpression)_specification_1;
            int _size = opaqueExpression.getBodies().size();
            boolean bl = _equals = _size == (_size_1 = opaqueExpression.getLanguages().size());
            if (_equals) {
                int i = 0;
                while (i < opaqueExpression.getLanguages().size()) {
                    boolean _equalsIgnoreCase = ((String)opaqueExpression.getLanguages().get(i)).equalsIgnoreCase(ACSL);
                    if (_equalsIgnoreCase) {
                        String _constraintText = constraintText;
                        String _cleanCR = GenUtils.cleanCR((String)((String)opaqueExpression.getBodies().get(i)));
                        String _plus = String.valueOf(_cleanCR) + "\n";
                        constraintText = String.valueOf(_constraintText) + _plus;
                    }
                    ++i;
                }
            }
        }
        return constraintText;
    }

    public static String genPrePostConditions(Operation operation) {
        boolean _not;
        String _xblockexpression = null;
        String specificationText = "";
        EList _preconditions = operation.getPreconditions();
        for (Constraint constraint : _preconditions) {
            String _specificationText = specificationText;
            String _aCSLConstraint = AcslScript.getACSLConstraint(constraint);
            specificationText = String.valueOf(_specificationText) + _aCSLConstraint;
        }
        EList _postconditions = operation.getPostconditions();
        for (Constraint constraint_1 : _postconditions) {
            String _specificationText_1 = specificationText;
            String _aCSLConstraint_1 = AcslScript.getACSLConstraint(constraint_1);
            specificationText = String.valueOf(_specificationText_1) + _aCSLConstraint_1;
        }
        String _xifexpression = null;
        boolean _isEmpty = specificationText.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return AcslScript.getACSLComment(specificationText);
        }
        _xblockexpression = _xifexpression = "";
        return _xblockexpression;
    }

    public static String getACSLComment(String acslSpecification) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("/*@");
        _builder.newLine();
        _builder.append("\t");
        _builder.append(acslSpecification, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        return _builder.toString();
    }

    public static String getGuard(Transition transition) {
        boolean _not;
        Pattern selectedLanguages = Pattern.compile(ACSL);
        String guard = StateMachineScript.getGuard(transition, selectedLanguages);
        boolean _isEmpty = guard.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return AcslScript.getACSLComment(guard);
        }
        return "";
    }
}

