/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.deployment.tools;

import java.util.Iterator;
import java.util.Stack;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.ImplementationProperties;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.Singleton;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.Target;
import org.eclipse.papyrus.designer.deployment.tools.Activator;
import org.eclipse.papyrus.designer.deployment.tools.ImplementationChooser;
import org.eclipse.papyrus.designer.languages.common.base.HintUtils;
import org.eclipse.papyrus.designer.transformation.base.ElementFilter;
import org.eclipse.papyrus.uml.tools.utils.StereotypeUtil;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DirectedRelationship;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.InstanceValue;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Slot;
import org.eclipse.uml2.uml.StructuralFeature;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.util.UMLUtil;

public class DepUtils {
    public static boolean isImplEligible(Class implemCandidate, EList<InstanceSpecification> nodes) {
        if (implemCandidate.isAbstract()) {
            return false;
        }
        if (nodes != null) {
            for (InstanceSpecification nodeInstance : nodes) {
                Target target = (Target)UMLUtil.getStereotypeApplication((Element)nodeInstance, Target.class);
                if (target == null) {
                    target = (Target)UMLUtil.getStereotypeApplication((Element)DepUtils.getClassifier(nodeInstance), Target.class);
                }
                if (target == null) continue;
                ImplementationProperties implementationProperties = (ImplementationProperties)UMLUtil.getStereotypeApplication((Element)implemCandidate, ImplementationProperties.class);
            }
        }
        return true;
    }

    public static InstanceSpecification getNamedSubInstance(InstanceSpecification owningInstance, String name) {
        Element cdp = owningInstance.getOwner();
        String candidateName = String.valueOf(owningInstance.getName()) + "." + name;
        if (cdp instanceof Package) {
            for (PackageableElement instance : ((Package)cdp).getPackagedElements()) {
                if (!(instance instanceof InstanceSpecification)) continue;
                InstanceSpecification candidate = (InstanceSpecification)instance;
                if (candidateName == null || !candidateName.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }

    public static Class chooseImplementation(Class componentType, EList<InstanceSpecification> nodes, ImplementationChooser chooser) {
        return DepUtils.chooseImplementation((EList<Class>)new BasicEList(), componentType, nodes, chooser);
    }

    public static Class chooseImplementation(EList<Class> implList, Class componentType, EList<InstanceSpecification> nodes, ImplementationChooser chooser) {
        if (!componentType.isAbstract()) {
            return componentType;
        }
        for (DirectedRelationship relship : componentType.getTargetDirectedRelationships()) {
            Class implClass;
            Classifier source;
            if (!(relship instanceof Generalization) || !((source = ((Generalization)relship).getSpecific()) instanceof Class) || !DepUtils.isImplEligible(implClass = (Class)source, nodes)) continue;
            implList.add((Object)implClass);
        }
        if (implList.size() == 0) {
            return null;
        }
        if (implList.size() == 1) {
            return (Class)implList.get(0);
        }
        if (chooser != null) {
            Class impl = chooser.chooseImplementation(componentType, implList);
            if (impl != null) {
                return impl;
            }
        } else if (implList.size() > 0) {
            return (Class)implList.get(0);
        }
        return null;
    }

    public static EList<InstanceSpecification> getInstances(Package cdp) {
        BasicEList list = new BasicEList();
        for (PackageableElement pe : cdp.getPackagedElements()) {
            if (!(pe instanceof InstanceSpecification)) continue;
            InstanceSpecification is = (InstanceSpecification)pe;
            list.add((Object)is);
        }
        return list;
    }

    public static EList<InstanceSpecification> getTopLevelInstances(Package cdp) {
        BasicEList list = new BasicEList();
        for (PackageableElement pe : cdp.getPackagedElements()) {
            InstanceSpecification is;
            if (!(pe instanceof InstanceSpecification) || !DepUtils.isTopLevelInstance(is = (InstanceSpecification)pe)) continue;
            list.add((Object)is);
        }
        return list;
    }

    public static boolean isTopLevelInstance(InstanceSpecification is) {
        return DepUtils.getReferencingSlots(is).size() == 0;
    }

    public static Class getImplementation(InstanceSpecification instance) {
        Classifier cl = DepUtils.getClassifier(instance);
        if (cl instanceof Class) {
            return (Class)cl;
        }
        return null;
    }

    public static Classifier getClassifier(InstanceSpecification instance) {
        Iterator classifierIt = instance.getClassifiers().iterator();
        if (classifierIt.hasNext()) {
            return (Classifier)classifierIt.next();
        }
        return null;
    }

    public static InstanceSpecification getInstanceForClassifier(Package cdp, Classifier cl) {
        for (PackageableElement pe : cdp.getPackagedElements()) {
            InstanceSpecification is;
            if (!(pe instanceof InstanceSpecification) || DepUtils.getClassifier(is = (InstanceSpecification)pe) != cl) continue;
            return is;
        }
        return null;
    }

    public static EList<Classifier> getContainedImplementations(InstanceSpecification is) {
        Iterator instances = DepUtils.getContainedInstances(is).iterator();
        UniqueEList list = new UniqueEList();
        while (instances.hasNext()) {
            Classifier implementation = DepUtils.getClassifier((InstanceSpecification)instances.next());
            list.add((Object)implementation);
        }
        return list;
    }

    public static Slot getSlot(InstanceSpecification is, Property property) {
        for (Slot slot : is.getSlots()) {
            if (slot.getDefiningFeature() != property) continue;
            return slot;
        }
        return null;
    }

    public static InstanceSpecification getInstance(Slot slot) {
        for (ValueSpecification value : slot.getValues()) {
            if (!(value instanceof InstanceValue)) continue;
            return ((InstanceValue)value).getInstance();
        }
        return null;
    }

    public static EList<InstanceSpecification> getContainedInstances(InstanceSpecification is) {
        BasicEList contained = new BasicEList();
        for (Slot slot : is.getSlots()) {
            InstanceSpecification instance = DepUtils.getInstance(slot);
            if (instance == null) continue;
            contained.add((Object)instance);
        }
        return contained;
    }

    public static EList<InstanceSpecification> getContainedNonSharedInstances(InstanceSpecification is) {
        BasicEList contained = new BasicEList();
        for (Slot slot : is.getSlots()) {
            InstanceSpecification instance = DepUtils.getInstance(slot);
            if (instance == null || DepUtils.isShared(slot)) continue;
            contained.add((Object)instance);
        }
        return contained;
    }

    public static EList<Slot> getReferencingSlots(InstanceSpecification is) {
        BasicEList list = new BasicEList();
        for (EStructuralFeature.Setting setting : UML2Util.getNonNavigableInverseReferences((EObject)is)) {
            ValueSpecification vs;
            Element owner;
            EObject eObj = setting.getEObject();
            if (!(eObj instanceof ValueSpecification) || !((owner = (vs = (ValueSpecification)eObj).getOwner()) instanceof Slot)) continue;
            list.add((Object)((Slot)owner));
        }
        return list;
    }

    public static Slot getParentSlot(InstanceSpecification is) {
        for (Slot slot : DepUtils.getReferencingSlots(is)) {
            if (!(slot.getDefiningFeature() instanceof Property) || ((Property)slot.getDefiningFeature()).getAggregation() != AggregationKind.COMPOSITE_LITERAL) continue;
            return slot;
        }
        return null;
    }

    public static InstanceSpecification getParentIS(InstanceSpecification is) {
        Slot parentSlot = DepUtils.getParentSlot(is);
        if (parentSlot != null) {
            return parentSlot.getOwningInstance();
        }
        return null;
    }

    public static Stack<Slot> getAccessPath(InstanceSpecification is) {
        Stack<Slot> path = new Stack<Slot>();
        while (is != null) {
            Slot parentSlot = DepUtils.getParentSlot(is);
            if (parentSlot == null) break;
            path.insertElementAt(parentSlot, 0);
            is = parentSlot.getOwningInstance();
        }
        return path;
    }

    public static boolean isShared(Slot slot) {
        StructuralFeature df = slot.getDefiningFeature();
        if (df instanceof Property) {
            return ((Property)df).getAggregation() == AggregationKind.SHARED_LITERAL;
        }
        return false;
    }

    public static String getTargetLanguage(InstanceSpecification mainInstance) {
        Classifier cl = DepUtils.getClassifier(mainInstance);
        return HintUtils.getLanguageFromElement((Element)cl);
    }

    public static void getAllInstances(Package pkg, EList<InstanceSpecification> instanceList, ElementFilter filter) {
        for (PackageableElement el : pkg.getPackagedElements()) {
            InstanceSpecification instance;
            if (el instanceof Package) {
                DepUtils.getAllInstances((Package)el, instanceList, filter);
                continue;
            }
            if (!(el instanceof InstanceSpecification) || !filter.acceptElement((Element)(instance = (InstanceSpecification)el))) continue;
            instanceList.add((Object)instance);
        }
    }

    public static ValueSpecification firstValue(Slot slot) {
        if (slot.getValues().size() > 0) {
            return (ValueSpecification)slot.getValues().get(0);
        }
        return null;
    }

    public static boolean treatNoneAsComposite() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("treatNoneAsComposite");
    }

    public static boolean allAttributesAreConfigAttributs() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("allAttributesAreConfigAttributes");
    }

    public static EList<Property> getParts(Class implementation) {
        if (DepUtils.treatNoneAsComposite()) {
            BasicEList parts = new BasicEList();
            for (Property part : implementation.getAttributes()) {
                if (part.getAggregation() == AggregationKind.SHARED_LITERAL) continue;
                parts.add((Object)part);
            }
            return parts;
        }
        return implementation.getParts();
    }

    public static boolean isComposite(Class implementation) {
        return DepUtils.getParts(implementation).size() > 0;
    }

    public static boolean isComposition(Property attribute) {
        if (DepUtils.treatNoneAsComposite()) {
            return attribute.getAggregation() != AggregationKind.SHARED_LITERAL;
        }
        return attribute.getAggregation() == AggregationKind.COMPOSITE_LITERAL;
    }

    public static boolean isSingleton(Class component) {
        return StereotypeUtil.isApplied((Element)component, Singleton.class);
    }

    public static boolean isDeploymentPlan(Package deploymentPlanCandidate) {
        return StereotypeUtil.isApplied((Element)deploymentPlanCandidate, DeploymentPlan.class);
    }
}

