/**
 * Copyright (c) 2016 CEA LIST.
 * 
 * 
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *  Van Cam Pham        <VanCam.PHAM@cea.fr>
 */
package org.eclipse.papyrus.designer.transformation.languages.cpp.library.statemachine;

@SuppressWarnings("all")
public class CDefinitions {
  public CDefinitions(final org.eclipse.uml2.uml.Class contextClass) {
    this.contextClass = contextClass;
  }
  
  private org.eclipse.uml2.uml.Class contextClass;
  
  public String TIME_EVENT_LOWER_BOUND() {
    return this.macro("TIME_EVENT_LOWER_BOUND");
  }
  
  public String CHANGE_EVENT_LOWER_BOUND() {
    return this.macro("CHANGE_EVENT_LOWER_BOUND");
  }
  
  public String TE_INDEX() {
    return this.macro("TE_INDEX");
  }
  
  public String CHE_INDEX() {
    return this.macro("CHE_INDEX");
  }
  
  /**
   * return "qualified" macro name, i.e. macro name prefixed with class name
   */
  public String macro(final String shortMacroName) {
    String _upperCase = this.contextClass.getName().toUpperCase();
    String _plus = (_upperCase + "_");
    return (_plus + shortMacroName);
  }
}
