/**
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.papyrus.designer.languages.common.validation;

import org.eclipse.emf.validation.model.IClientSelector;
import org.eclipse.uml2.uml.Element;

public class ValidationDelegateClientSelector implements IClientSelector {

	/**
	 * Queries whether to select the specified object, which indicates that it
	 * belongs to this client context.
	 *
	 * @param object
	 *            a model element of some kind
	 * @return <code>true</code> if the <code>object</code> matches my client
	 *         context; <code>false</code>, otherwise
	 */
	@Override
	public boolean selects(Object object) {
		return (object instanceof Element);
	}
}
