/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.languages.common.base;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import org.eclipse.papyrus.designer.languages.common.base.Activator;
import org.eclipse.papyrus.designer.languages.common.base.Messages;

public class ProcessWrapper {
    public static void process(List<String> arguments) {
        BufferedReader results = null;
        BufferedReader errors = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(arguments);
            Process p = null;
            try {
                String s;
                p = pb.start();
                results = new BufferedReader(new InputStreamReader(p.getInputStream()));
                boolean error = false;
                String errorMsg = "";
                errors = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                while ((s = errors.readLine()) != null) {
                    errorMsg = String.valueOf(errorMsg) + s;
                    error = true;
                }
                while ((s = results.readLine()) != null) {
                    errorMsg = String.valueOf(errorMsg) + s;
                    error = true;
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (error) {
                    throw new RuntimeException(String.format(Messages.ProcessWrapper_ERROR_DURING_EXECUTION, errorMsg));
                }
            }
            catch (IOException exp) {
                Activator.log.error((Throwable)exp);
            }
        }
        finally {
            try {
                if (results != null) {
                    results.close();
                }
                if (errors != null) {
                    errors.close();
                }
            }
            catch (IOException exp) {
                Activator.log.error((Throwable)exp);
            }
        }
    }
}

