/**
 * Copyright (c) 2015 CEA LIST.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 * 
 * Contributors:
 *     CEA LIST - initial API and implementation
 */
package org.eclipse.papyrus.designer.languages.c.codegen.lib;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.CommonScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.FunctionScript;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.TransformationUtil;
import org.eclipse.papyrus.designer.languages.c.codegen.lib.variableScript;
import org.eclipse.papyrus.designer.languages.c.codegen.services.UmlCommentServices;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.DefaultConstructor;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.FinalState;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.InterfaceRealization;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Reception;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.profile.standard.Create;
import org.eclipse.uml2.uml.profile.standard.Destroy;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ClassScript {
  public static CharSequence genDynamicInstanciationOperationPrototypes(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    String _partComment = UmlCommentServices.partComment(clazz, "Default constructor & destructor prototypes");
    _builder.append(_partComment);
    _builder.newLineIfNotEmpty();
    CharSequence _genConstructorPrototype = ClassScript.genConstructorPrototype(clazz);
    _builder.append(_genConstructorPrototype);
    _builder.newLineIfNotEmpty();
    CharSequence _genDestructorPrototype = ClassScript.genDestructorPrototype(clazz);
    _builder.append(_genDestructorPrototype);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static CharSequence genConstructorPrototype(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOwnedOperations(), new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(GenUtils.hasStereotype(it, Create.class));
        }
      })) == 0) && GenUtils.hasStereotype(clazz, DefaultConstructor.class))) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dynamic instantiation of a ");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName, " ");
        _builder.append(" structure");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return ");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1, " ");
        _builder.append(" instance pointer");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        CharSequence _genName_2 = CommonScript.genName(clazz);
        _builder.append(_genName_2);
        _builder.append("* ");
        CharSequence _genName_3 = CommonScript.genName(clazz);
        _builder.append(_genName_3);
        _builder.append("_create();");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence genDestructorPrototype(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOwnedOperations(), new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(GenUtils.hasStereotype(it, Destroy.class));
        }
      })) == 0) && GenUtils.hasStereotype(clazz, DefaultConstructor.class))) {
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Dynamic destruction of a ");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName, " ");
        _builder.append(" structure instantiation");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @param Pointer to an instance of the ");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1, " ");
        _builder.append(" structure");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return void");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        CharSequence _genName_2 = CommonScript.genName(clazz);
        _builder.append(_genName_2);
        _builder.append("_destroy(");
        CharSequence _genName_3 = CommonScript.genName(clazz);
        _builder.append(_genName_3);
        _builder.append("*);");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence genDynamicInstanciationOperations(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    String _partComment = UmlCommentServices.partComment(clazz, "Default constructor & destructor implementations");
    _builder.append(_partComment);
    _builder.newLineIfNotEmpty();
    CharSequence _genConstructor = ClassScript.genConstructor(clazz);
    _builder.append(_genConstructor);
    _builder.newLineIfNotEmpty();
    CharSequence _genDestructor = ClassScript.genDestructor(clazz);
    _builder.append(_genDestructor);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static CharSequence genConstructor(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOwnedOperations(), new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(GenUtils.hasStereotype(it, Create.class));
        }
      })) == 0) && GenUtils.hasStereotype(clazz, DefaultConstructor.class))) {
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName);
        _builder.append("* ");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1);
        _builder.append("_create() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _genName_2 = CommonScript.genName(clazz);
        _builder.append(_genName_2, "\t");
        _builder.append("* self = (");
        CharSequence _genName_3 = CommonScript.genName(clazz);
        _builder.append(_genName_3, "\t");
        _builder.append("*) malloc(sizeof(");
        CharSequence _genName_4 = CommonScript.genName(clazz);
        _builder.append(_genName_4, "\t");
        _builder.append("));");
        _builder.newLineIfNotEmpty();
        {
          if (((!IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class))) || (IterableExtensions.size(IterableExtensions.<Property>filter(clazz.getAllAttributes(), new Function1<Property, Boolean>() {
            @Override
            public Boolean apply(final Property it) {
              ValueSpecification _defaultValue = it.getDefaultValue();
              return Boolean.valueOf((_defaultValue != null));
            }
          })) > 0))) {
            _builder.append("\t");
            CharSequence _genName_5 = CommonScript.genName(clazz);
            _builder.append(_genName_5, "\t");
            _builder.append("_init(self);");
            _builder.newLineIfNotEmpty();
          }
        }
        _builder.append("\t");
        _builder.append("return self;");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public static CharSequence genDestructor(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOwnedOperations(), new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(GenUtils.hasStereotype(it, Destroy.class));
        }
      })) == 0) && GenUtils.hasStereotype(clazz, DefaultConstructor.class))) {
        _builder.append("// default destructor");
        _builder.newLine();
        _builder.append("void ");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName);
        _builder.append("_destroy(");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1);
        _builder.append("* self) {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("free(self);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public static CharSequence genDefaultInitialisationProtoype(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class))) || (IterableExtensions.size(IterableExtensions.<Property>filter(clazz.getAllAttributes(), new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          ValueSpecification _defaultValue = it.getDefaultValue();
          return Boolean.valueOf((_defaultValue != null));
        }
      })) > 0))) {
        String _partComment = UmlCommentServices.partComment(clazz, "Default value initialization prototypes");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
        _builder.append("/**");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* Default value initialization");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("* @param ");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName, " ");
        _builder.append(" structure instance pointer");
        _builder.newLineIfNotEmpty();
        _builder.append(" ");
        _builder.append("* @return void");
        _builder.newLine();
        _builder.append(" ");
        _builder.append("*/");
        _builder.newLine();
        _builder.append("void ");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1);
        _builder.append("_init(");
        CharSequence _genName_2 = CommonScript.genName(clazz);
        _builder.append(_genName_2);
        _builder.append("* self);");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public static CharSequence genDefaultIntialisationOperation(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      if (((!IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class))) || (IterableExtensions.size(IterableExtensions.<Property>filter(clazz.getAllAttributes(), new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          ValueSpecification _defaultValue = it.getDefaultValue();
          return Boolean.valueOf((_defaultValue != null));
        }
      })) > 0))) {
        _builder.newLine();
        _builder.append("void ");
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName);
        _builder.append("_init(");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1);
        _builder.append("* self) {");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        {
          boolean _isEmpty = IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class));
          boolean _not = (!_isEmpty);
          if (_not) {
            _builder.append("\t");
            _builder.append("//Default value initialization implementation");
            _builder.newLine();
            {
              EList<Property> _allAttributes = clazz.getAllAttributes();
              for(final Property attribute : _allAttributes) {
                {
                  if ((((attribute.getDefaultValue() != null) && (!attribute.isStatic())) && (attribute.getType() != null))) {
                    _builder.append("\t");
                    CharSequence _genInitDefaultValue = variableScript.genInitDefaultValue(attribute);
                    _builder.append(_genInitDefaultValue, "\t");
                    _builder.newLineIfNotEmpty();
                  }
                }
              }
            }
          }
        }
        _builder.newLine();
        {
          boolean _isEmpty_1 = IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class));
          boolean _not_1 = (!_isEmpty_1);
          if (_not_1) {
            _builder.append("\t");
            StateMachine sm = IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class));
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            final Function1<State, Boolean> _function = new Function1<State, Boolean>() {
              @Override
              public Boolean apply(final State it) {
                return Boolean.valueOf((!(it instanceof FinalState)));
              }
            };
            Iterable<State> states = IterableExtensions.<State>filter(Iterables.<State>filter(IterableExtensions.<Region>head(sm.getRegions()).getSubvertices(), State.class), _function);
            _builder.newLineIfNotEmpty();
            {
              boolean _isEmpty_2 = IterableExtensions.isEmpty(states);
              boolean _not_2 = (!_isEmpty_2);
              if (_not_2) {
                _builder.append("\t");
                _builder.append("// initialization of state internal behaviors if exists");
                _builder.newLine();
                {
                  for(final State s : states) {
                    {
                      boolean _isBehaviorExist = TransformationUtil.isBehaviorExist(s.getEntry());
                      if (_isBehaviorExist) {
                        _builder.append("\t");
                        _builder.append("self->states[");
                        String _name = s.getName();
                        _builder.append(_name, "\t");
                        _builder.append("].entry= &");
                        String _name_1 = s.getName();
                        _builder.append(_name_1, "\t");
                        _builder.append("_entry;");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("self->states[");
                        String _name_2 = s.getName();
                        _builder.append(_name_2, "\t");
                        _builder.append("].entry= NULL;");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    {
                      boolean _isBehaviorExist_1 = TransformationUtil.isBehaviorExist(s.getExit());
                      if (_isBehaviorExist_1) {
                        _builder.append("\t");
                        _builder.append("self->states[");
                        String _name_3 = s.getName();
                        _builder.append(_name_3, "\t");
                        _builder.append("].exit= &");
                        String _name_4 = s.getName();
                        _builder.append(_name_4, "\t");
                        _builder.append("_exit;");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("self->states[");
                        String _name_5 = s.getName();
                        _builder.append(_name_5, "\t");
                        _builder.append("].exit= NULL;");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                    {
                      boolean _isBehaviorExist_2 = TransformationUtil.isBehaviorExist(s.getDoActivity());
                      if (_isBehaviorExist_2) {
                        _builder.append("\t");
                        _builder.append("self->states[");
                        String _name_6 = s.getName();
                        _builder.append(_name_6, "\t");
                        _builder.append("].doActivity= &");
                        String _name_7 = s.getName();
                        _builder.append(_name_7, "\t");
                        _builder.append("_doActivity;");
                        _builder.newLineIfNotEmpty();
                      } else {
                        _builder.append("\t");
                        _builder.append("self->states[");
                        String _name_8 = s.getName();
                        _builder.append(_name_8, "\t");
                        _builder.append("].doActivity= NULL;");
                        _builder.newLineIfNotEmpty();
                      }
                    }
                  }
                }
                _builder.newLine();
                _builder.append("\t");
                State initialState = TransformationUtil.findInitialState(IterableExtensions.<Region>head(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)).getRegions()));
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("// set the activeStateID and call initial state entry and do Activity");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("self->activeStateID = ");
                String _name_9 = initialState.getName();
                _builder.append(_name_9, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("if (self->states[");
                String _name_10 = initialState.getName();
                _builder.append(_name_10, "\t");
                _builder.append("].entry != NULL) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("self->states[");
                String _name_11 = initialState.getName();
                _builder.append(_name_11, "\t\t");
                _builder.append("].entry();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("if (self->states[");
                String _name_12 = initialState.getName();
                _builder.append(_name_12, "\t");
                _builder.append("].doActivity != NULL) {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("self->states[");
                String _name_13 = initialState.getName();
                _builder.append(_name_13, "\t\t");
                _builder.append("].doActivity();");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
              }
            }
          }
        }
        _builder.append("}");
        _builder.newLine();
      }
    }
    return _builder;
  }
  
  public static CharSequence defaultIntialisationCall(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Property, Boolean> _function = new Function1<Property, Boolean>() {
        @Override
        public Boolean apply(final Property it) {
          ValueSpecification _defaultValue = it.getDefaultValue();
          return Boolean.valueOf((_defaultValue != null));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<Property>filter(clazz.getAllAttributes(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        _builder.append("/* Default value initialization */");
        _builder.newLine();
        CharSequence _genName = CommonScript.genName(clazz);
        _builder.append(_genName);
        _builder.append("_init(&");
        CharSequence _genName_1 = CommonScript.genName(clazz);
        _builder.append(_genName_1);
        _builder.append(");");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public static CharSequence genClassStructDeclarations(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("/* Class Macro definition */");
    _builder.newLine();
    _builder.append("#define ");
    CharSequence _genName = CommonScript.genName(clazz);
    _builder.append(_genName);
    _builder.append("(OBJ) ((");
    CharSequence _genName_1 = CommonScript.genName(clazz);
    _builder.append(_genName_1);
    _builder.append("*)OBJ)");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<Comment> _ownedComments = clazz.getOwnedComments();
      for(final Comment comment : _ownedComments) {
        CharSequence _genComment = CommonScript.genComment(comment);
        _builder.append(_genComment);
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("typedef struct ");
    CharSequence _genName_2 = CommonScript.genName(clazz);
    _builder.append(_genName_2);
    _builder.append(" ");
    CharSequence _genName_3 = CommonScript.genName(clazz);
    _builder.append(_genName_3);
    _builder.append(";");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("struct ");
    CharSequence _genName_4 = CommonScript.genName(clazz);
    _builder.append(_genName_4);
    _builder.append(" {");
    _builder.newLineIfNotEmpty();
    {
      Iterable<Property> _classStructAttributes = ClassScript.getClassStructAttributes(clazz);
      for(final Property attribute : _classStructAttributes) {
        {
          boolean _isStatic = attribute.isStatic();
          boolean _not = (!_isStatic);
          if (_not) {
            _builder.append("\t");
            CharSequence _genVariableDeclaration = variableScript.genVariableDeclaration(attribute);
            _builder.append(_genVariableDeclaration, "\t");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    {
      boolean _isEmpty = IterableExtensions.isEmpty(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class));
      boolean _not_1 = (!_isEmpty);
      if (_not_1) {
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t\t");
        CharSequence _genStateVariableDeclaration = variableScript.genStateVariableDeclaration(clazz);
        _builder.append(_genStateVariableDeclaration, "\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("\t\t\t\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("\t\t\t\t");
        CharSequence _genStateArrayDeclaration = variableScript.genStateArrayDeclaration(IterableExtensions.<StateMachine>head(Iterables.<StateMachine>filter(clazz.getOwnedBehaviors(), StateMachine.class)));
        _builder.append(_genStateArrayDeclaration, "\t\t\t\t\t");
        _builder.newLineIfNotEmpty();
      }
    }
    _builder.append("\t");
    _builder.newLine();
    _builder.append("};");
    _builder.newLine();
    return _builder;
  }
  
  public static Iterable<Property> getClassStructAttributes(final org.eclipse.uml2.uml.Class clazz) {
    Property[] _clone = ((Property[])Conversions.unwrapArray(clazz.getAllAttributes(), Property.class)).clone();
    final Function1<InterfaceRealization, Interface> _function = new Function1<InterfaceRealization, Interface>() {
      @Override
      public Interface apply(final InterfaceRealization it) {
        return it.getContract();
      }
    };
    final Function1<Interface, EList<Property>> _function_1 = new Function1<Interface, EList<Property>>() {
      @Override
      public EList<Property> apply(final Interface it) {
        return it.getOwnedAttributes();
      }
    };
    Iterable<Property> _flatten = Iterables.<Property>concat(ListExtensions.<Interface, EList<Property>>map(ListExtensions.<InterfaceRealization, Interface>map(clazz.getInterfaceRealizations(), _function), _function_1));
    return Iterables.<Property>concat(((Iterable<? extends Property>)Conversions.doWrapArray(_clone)), _flatten);
  }
  
  public static CharSequence genNonStaticFunctionDeclarations(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Operation, Boolean> _function = new Function1<Operation, Boolean>() {
        @Override
        public Boolean apply(final Operation it) {
          return Boolean.valueOf(((!it.isStatic()) && Objects.equal(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL)));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<Operation>filter(clazz.getOwnedOperations(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _partComment = UmlCommentServices.partComment(clazz, "Function Declarations");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Operation> _allOperations = clazz.getAllOperations();
      for(final Operation operation : _allOperations) {
        {
          if (((!operation.isStatic()) && Objects.equal(operation.getVisibility(), VisibilityKind.PUBLIC_LITERAL))) {
            CharSequence _genFunctionPrototype = FunctionScript.genFunctionPrototype(operation);
            _builder.append(_genFunctionPrototype);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
  
  public static CharSequence genReceptionDeclarations(final org.eclipse.uml2.uml.Class clazz) {
    StringConcatenation _builder = new StringConcatenation();
    {
      final Function1<Reception, Boolean> _function = new Function1<Reception, Boolean>() {
        @Override
        public Boolean apply(final Reception it) {
          return Boolean.valueOf((((it.getSignal() != null) && (!it.isStatic())) && Objects.equal(it.getVisibility(), VisibilityKind.PUBLIC_LITERAL)));
        }
      };
      int _size = IterableExtensions.size(IterableExtensions.<Reception>filter(clazz.getOwnedReceptions(), _function));
      boolean _greaterThan = (_size > 0);
      if (_greaterThan) {
        String _partComment = UmlCommentServices.partComment(clazz, "Reception Declarations");
        _builder.append(_partComment);
        _builder.newLineIfNotEmpty();
      }
    }
    {
      EList<Reception> _ownedReceptions = clazz.getOwnedReceptions();
      for(final Reception reception : _ownedReceptions) {
        {
          if (((!reception.isStatic()) && Objects.equal(reception.getVisibility(), VisibilityKind.PUBLIC_LITERAL))) {
            CharSequence _genFunctionPrototype = FunctionScript.genFunctionPrototype(reception);
            _builder.append(_genFunctionPrototype);
            _builder.newLineIfNotEmpty();
          }
        }
      }
    }
    return _builder;
  }
}
