/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.designer.components.validation.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.papyrus.designer.deployment.profile.Deployment.DeploymentPlan;
import org.eclipse.papyrus.designer.deployment.tools.DepUtils;
import org.eclipse.papyrus.designer.transformation.library.transformations.AbstractBootLoaderGen;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.util.UMLUtil;

public class InitialEntryPoints
extends AbstractModelConstraint {
    private EList<String> entryPoints;

    public IStatus validate(IValidationContext ctx) {
        Package pkg = (Package)ctx.getTarget();
        DeploymentPlan cdp = (DeploymentPlan)UMLUtil.getStereotypeApplication((Element)pkg, DeploymentPlan.class);
        if (cdp != null) {
            this.entryPoints = new BasicEList();
            for (InstanceSpecification is : DepUtils.getInstances((Package)pkg)) {
                Class implementation;
                Classifier cl = DepUtils.getClassifier((InstanceSpecification)is);
                if (!(cl instanceof Class) || !AbstractBootLoaderGen.hasUnconnectedStartRoutine((Class)(implementation = (Class)cl), null)) continue;
                this.entryPoints.add((Object)implementation.getName());
            }
            if (this.entryPoints.size() > 1) {
                String msg = "";
                for (String entryPoint : this.entryPoints) {
                    if (msg.length() > 0) {
                        msg = String.valueOf(msg) + ", ";
                    }
                    msg = String.valueOf(msg) + entryPoint;
                }
                return ctx.createFailureStatus(new Object[]{String.format("The deployment plan '%s' contains more than one start entry point: %s", pkg.getName(), msg)});
            }
        }
        return ctx.createSuccessStatus();
    }
}

