/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.partition;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jet.internal.editor.partition.ITokenScannerProvider;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.swt.custom.StyleRange;

public class PartitionScannerBasedDamagerRepairer
implements IPresentationDamager,
IPresentationRepairer {
    protected IDocument document;
    protected IPartitionTokenScanner partitionScanner;
    protected ITokenScannerProvider tokenScannerProvider;
    protected TextAttribute defaultTextAttribute;

    public PartitionScannerBasedDamagerRepairer(IPartitionTokenScanner scanner, ITokenScannerProvider provider) {
        Assert.isNotNull((Object)scanner);
        Assert.isNotNull((Object)provider);
        this.partitionScanner = scanner;
        this.tokenScannerProvider = provider;
        this.defaultTextAttribute = new TextAttribute(null);
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setPartitionScanner(IPartitionTokenScanner partitionScanner) {
        this.partitionScanner = partitionScanner;
    }

    public void setTokenScannerProvider(ITokenScannerProvider provider) {
        this.tokenScannerProvider = provider;
    }

    public IRegion getDamageRegion(ITypedRegion partition, DocumentEvent e, boolean documentPartitioningChanged) {
        if (!documentPartitioningChanged) {
            return new Region(partition.getOffset(), partition.getLength());
        }
        return partition;
    }

    public void createPresentation(TextPresentation presentation, ITypedRegion region) {
        this.partitionScanner.setRange(this.document, region.getOffset(), region.getLength());
        String lastContentType = null;
        int partitionScannerTokenLength = 0;
        int partitionScannerTokenOffset = region.getOffset();
        while (true) {
            IToken partitionToken;
            if ((partitionToken = this.partitionScanner.nextToken()).isEOF()) {
                if (lastContentType == null) break;
                ITokenScanner tokenScanner = this.tokenScannerProvider.getTokenScanner(lastContentType);
                if (tokenScanner == null) {
                    this.addRange(presentation, this.partitionScanner.getTokenOffset(), this.partitionScanner.getTokenLength(), this.defaultTextAttribute);
                    break;
                }
                this.applyTokenScanner(presentation, partitionScannerTokenLength, partitionScannerTokenOffset, tokenScanner);
                break;
            }
            String contentType = this.getTokenContentType(partitionToken);
            if (contentType == null) {
                contentType = "__dftl_partition_content_type";
            }
            if (contentType.equals(lastContentType)) {
                partitionScannerTokenLength += this.partitionScanner.getTokenLength();
                continue;
            }
            if (lastContentType != null) {
                ITokenScanner tokenScanner = this.tokenScannerProvider.getTokenScanner(lastContentType);
                if (tokenScanner == null) {
                    this.addRange(presentation, this.partitionScanner.getTokenOffset(), this.partitionScanner.getTokenLength(), this.defaultTextAttribute);
                } else {
                    this.applyTokenScanner(presentation, partitionScannerTokenLength, partitionScannerTokenOffset, tokenScanner);
                }
            }
            lastContentType = contentType;
            partitionScannerTokenOffset = this.partitionScanner.getTokenOffset();
            partitionScannerTokenLength = this.partitionScanner.getTokenLength();
        }
    }

    private void applyTokenScanner(TextPresentation presentation, int partitionScannerTokenLength, int partitionScannerTokenOffset, ITokenScanner tokenScanner) {
        IToken token;
        int lastStart = partitionScannerTokenOffset;
        int length = 0;
        boolean firstToken = true;
        IToken lastToken = Token.UNDEFINED;
        TextAttribute lastAttribute = this.getTokenTextAttribute(lastToken);
        tokenScanner.setRange(this.document, partitionScannerTokenOffset, partitionScannerTokenLength);
        while (!(token = tokenScanner.nextToken()).isEOF()) {
            TextAttribute attribute = this.getTokenTextAttribute(token);
            if (lastAttribute != null && lastAttribute.equals((Object)attribute)) {
                length += tokenScanner.getTokenLength();
                firstToken = false;
                continue;
            }
            if (!firstToken) {
                this.addRange(presentation, lastStart, length, lastAttribute);
            }
            firstToken = false;
            lastToken = token;
            lastAttribute = attribute;
            lastStart = tokenScanner.getTokenOffset();
            length = tokenScanner.getTokenLength();
        }
        this.addRange(presentation, lastStart, length, lastAttribute);
    }

    protected String getTokenContentType(IToken token) {
        Object data = token.getData();
        if (data instanceof String) {
            return (String)data;
        }
        return null;
    }

    protected TextAttribute getTokenTextAttribute(IToken token) {
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            return (TextAttribute)data;
        }
        return this.defaultTextAttribute;
    }

    protected void addRange(TextPresentation presentation, int offset, int length, TextAttribute attr) {
        if (attr != null) {
            int style = attr.getStyle();
            int fontStyle = style & 3;
            StyleRange styleRange = new StyleRange(offset, length, attr.getForeground(), attr.getBackground(), fontStyle);
            styleRange.strikeout = (style & 0x20000000) != 0;
            styleRange.underline = (style & 0x40000000) != 0;
            styleRange.font = attr.getFont();
            presentation.addStyleRange(styleRange);
        }
    }
}

