/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jet.xpath.DefaultXPathFunctionResolver;
import org.eclipse.jet.xpath.IAnnotationManager;
import org.eclipse.jet.xpath.XPathFunctionResolver;
import org.eclipse.jet.xpath.XPathVariableResolver;
import org.eclipse.jet.xpath.inspector.INodeInspector;
import org.eclipse.jet.xpath.inspector.InspectorManager;

public final class Context {
    private static DefaultXPathFunctionResolver defaultXPathFunctionResolver;
    private final Object contextNode;
    private final int contextPosition;
    private final int contextSize;
    private final InspectorManager inspectorManager;
    private final XPathVariableResolver variableResolver;
    private final IAnnotationManager annotationManager;
    private final XPathFunctionResolver functionResolver;

    private static DefaultXPathFunctionResolver getDefaultFunctionResolver() {
        if (defaultXPathFunctionResolver == null) {
            defaultXPathFunctionResolver = new DefaultXPathFunctionResolver();
        }
        return defaultXPathFunctionResolver;
    }

    public Context(Object contextNode, IAnnotationManager annotationManager) {
        this(contextNode, Collections.EMPTY_MAP, annotationManager);
    }

    private Context(Object contextNode, int contextPosition, int contextSize, XPathVariableResolver variableResolver, XPathFunctionResolver functionResolver, IAnnotationManager annotationManager) {
        this.contextNode = contextNode;
        this.contextPosition = contextPosition;
        this.contextSize = contextSize;
        this.variableResolver = variableResolver;
        this.functionResolver = functionResolver;
        this.annotationManager = annotationManager;
        this.inspectorManager = InspectorManager.getInstance();
    }

    public Context(Object contextNode, final Map variables, IAnnotationManager annotationManager) {
        this(contextNode, new XPathVariableResolver(){

            public Object resolveVariable(String variableName) {
                return variables != null ? variables.get(variableName) : null;
            }
        }, annotationManager);
    }

    public Context(Object contextNode, XPathVariableResolver variableResolver, IAnnotationManager annotationManager) {
        this(contextNode, variableResolver, annotationManager, Context.getDefaultFunctionResolver());
    }

    public Context(Object contextNode, XPathVariableResolver variableResolver, IAnnotationManager annotationManager, XPathFunctionResolver functionResolver) {
        this(contextNode, 1, 1, variableResolver, functionResolver == null ? Context.getDefaultFunctionResolver() : functionResolver, annotationManager);
    }

    public IAnnotationManager getAnnotationManager() {
        if (this.annotationManager == null) {
            throw new IllegalStateException();
        }
        return this.annotationManager;
    }

    public Object getContextNode() {
        return this.contextNode;
    }

    public INodeInspector getContextNodeInspector() {
        return this.inspectorManager.getInspector(this.contextNode);
    }

    public int getContextPosition() {
        return this.contextPosition;
    }

    public int getContextSize() {
        return this.contextSize;
    }

    public XPathFunctionResolver getFunctionResolver() {
        return this.functionResolver;
    }

    public XPathVariableResolver getVariableResolver() {
        return this.variableResolver;
    }

    public boolean hasAnnotationManager() {
        return this.annotationManager != null;
    }

    public Context newSubContext(Object contextNode2, int contextPosition2, int contextSize2) {
        return new Context(contextNode2, contextPosition2, contextSize2, this.variableResolver, this.functionResolver, this.annotationManager);
    }

    public String toString() {
        return "Context(" + this.contextNode.toString() + "," + this.contextPosition + "," + this.contextSize + ")";
    }
}

