/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.xmi.impl.GenericXMLResourceFactoryImpl;
import org.eclipse.jet.runtime.model.IModelLoader;

public class EMFXMLModelLoader
implements IModelLoader {
    private static final String XML_TYPE = "xml";
    private static final String EMPTY_STRING = "";

    private Object getDocumentRoot(Resource emfResource) {
        EObject first = (EObject)emfResource.getContents().get(0);
        if (EMPTY_STRING.equals(ExtendedMetaData.INSTANCE.getName((EClassifier)first.eClass()))) {
            return first;
        }
        return emfResource;
    }

    private Map getLoadOptions() {
        HashMap<String, Boolean> options = new HashMap<String, Boolean>();
        options.put("EXTENDED_META_DATA", Boolean.TRUE);
        return options;
    }

    private ResourceSet getResourceSet() {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(XML_TYPE, new GenericXMLResourceFactoryImpl());
        return resourceSet;
    }

    public Object load(URL modelUrl) throws IOException {
        return this.load(modelUrl, XML_TYPE);
    }

    public Object load(URL modelUrl, String kind) throws IOException {
        URI emfURI = URI.createURI((String)modelUrl.toExternalForm());
        ResourceSet resourceSet = this.getResourceSet();
        Resource.Factory factory = (Resource.Factory)resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get(XML_TYPE);
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put(emfURI.fileExtension(), factory);
        Resource emfResource = resourceSet.createResource(emfURI);
        Map options = this.getLoadOptions();
        emfResource.load(options);
        return this.getDocumentRoot(emfResource);
    }

    public Object loadFromString(String serializedModel, String kind) throws IOException {
        URI emfURI = URI.createURI((String)"temp://in-memory-string.xml");
        ResourceSet resourceSet = this.getResourceSet();
        if (kind == null) {
            kind = XML_TYPE;
        }
        Resource.Factory factory = (Resource.Factory)resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().get(kind);
        Resource emfResource = factory.createResource(emfURI);
        Map options = this.getLoadOptions();
        emfResource.load((InputStream)new ByteArrayInputStream(serializedModel.getBytes("UTF-8")), options);
        return this.getDocumentRoot(emfResource);
    }

    public boolean canLoad(String kind) {
        throw new UnsupportedOperationException();
    }
}

