/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal;

public class JavaUtil {
    private JavaUtil() {
    }

    public static String escapeJavaString(char[] text) {
        StringBuffer buffer = new StringBuffer(text.length);
        JavaUtil.escapeJavaString(text, buffer);
        return buffer.toString();
    }

    public static void escapeJavaString(char[] originalText, StringBuffer escapedText) {
        int i = 0;
        while (i < originalText.length) {
            switch (originalText[i]) {
                case '\b': {
                    escapedText.append("\\b");
                    break;
                }
                case '\f': {
                    escapedText.append("\\f");
                    break;
                }
                case '\t': {
                    escapedText.append("\\t");
                    break;
                }
                case '\r': {
                    escapedText.append("\\r");
                    break;
                }
                case '\n': {
                    escapedText.append("\\n");
                    break;
                }
                case '\"': {
                    escapedText.append("\\\"");
                    break;
                }
                case '\\': {
                    escapedText.append("\\\\");
                    break;
                }
                default: {
                    escapedText.append(originalText[i]);
                }
            }
            ++i;
        }
    }

    public static String asJavaQuotedString(char[] text) {
        StringBuffer encoded = new StringBuffer(text.length + 2);
        encoded.append('\"');
        JavaUtil.escapeJavaString(text, encoded);
        encoded.append('\"');
        return encoded.toString();
    }
}

