/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.editor.outline;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jet.compiler.CompileOptionsManager;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.core.parser.ast.Comment;
import org.eclipse.jet.core.parser.ast.JETDirective;
import org.eclipse.jet.core.parser.ast.JavaDeclaration;
import org.eclipse.jet.core.parser.ast.JavaExpression;
import org.eclipse.jet.core.parser.ast.JavaScriptlet;
import org.eclipse.jet.core.parser.ast.TextElement;
import org.eclipse.jet.core.parser.ast.XMLElement;
import org.eclipse.jet.internal.editor.Activator;
import org.eclipse.jet.internal.editor.JETEditorHelper;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.outline.JETOutlineContentProvider;
import org.eclipse.jet.taglib.TagLibraryReference;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IFileEditorInput;

public class JETOutlineLabelProvider
extends LabelProvider {
    private JETTextEditor editor;

    public JETOutlineLabelProvider(JETTextEditor editor) {
        this.editor = editor;
    }

    public Image getImage(Object element) {
        if (element instanceof Comment) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jdoc_tag_obj.gif");
        }
        if (element instanceof JavaDeclaration) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
        }
        if (element instanceof JavaExpression) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methdef_obj.gif");
        }
        if (element instanceof JavaScriptlet) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpub_obj.gif");
        }
        if (element instanceof JETDirective) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpro_obj.gif");
        }
        if (element instanceof TextElement) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.imp_obj.gif");
        }
        if (element instanceof XMLElement) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.methpro_obj.gif");
        }
        if (element instanceof JETOutlineContentProvider.ImportsContainerInput) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.impc_obj.gif");
        }
        if (element instanceof JETOutlineContentProvider.ImportInput) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.imp_obj.gif");
        }
        if (element instanceof JETOutlineContentProvider.CompilationUnitContainerInput) {
            return Activator.getDefault().getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        if (element instanceof JETOutlineContentProvider.OutputPackageInput) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.packd_obj.gif");
        }
        if (element instanceof JETOutlineContentProvider.OutputClassInput) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.jcu_obj.gif");
        }
        if (element instanceof TagLibraryReference) {
            return JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.annotation_obj.gif");
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        if (element instanceof Comment) {
            return this.getShortText(((Comment)element).getCommentText());
        }
        if (element instanceof JavaDeclaration) {
            return new StringBuilder("<%!").append(this.getShortText(((JavaDeclaration)element).getJavaContent())).append("%>").toString();
        }
        if (element instanceof JavaExpression) {
            return new StringBuilder("<%=").append(this.getShortText(((JavaExpression)element).getJavaContent())).append("%>").toString();
        }
        if (element instanceof JavaScriptlet) {
            return new StringBuilder("<%").append(this.getShortText(((JavaScriptlet)element).getJavaContent())).append("%>").toString();
        }
        if (element instanceof JETDirective) {
            return new StringBuilder("<%@").append(((JETDirective)element).getName()).append(" ").append(this.getAttributesText((JETDirective)element)).append("%>").toString();
        }
        if (element instanceof TextElement) {
            return this.getShortText(new String(((TextElement)element).getText()));
        }
        if (element instanceof XMLElement) {
            return new StringBuilder("<").append(((XMLElement)element).getName()).append(" ").append(this.getAttributesText((XMLElement)element)).append(">").toString();
        }
        if (element instanceof JETOutlineContentProvider.ImportsContainerInput) {
            return "import declarations";
        }
        if (element instanceof JETOutlineContentProvider.CompilationUnitContainerInput) {
            return "Template AST";
        }
        if (element instanceof JETOutlineContentProvider.OutputPackageInput) {
            String packageName = ((JETOutlineContentProvider.OutputPackageInput)element).getCompilationUnit().getOutputJavaPackage();
            if (packageName == null) {
                Map options = CompileOptionsManager.getOptions((IProject)this.editor.getJavaProject().getProject());
                if (options.isEmpty()) {
                    options = JETCompilerOptions.getDefaultCompilerOptions();
                }
                packageName = (String)options.get("org.eclipse.jet.compiledTemplatePackage");
            }
            return packageName;
        }
        if (element instanceof JETOutlineContentProvider.OutputClassInput) {
            String className = ((JETOutlineContentProvider.OutputClassInput)element).getCompilationUnit().getOutputJavaClassName();
            if (className == null && this.editor.getEditorInput() instanceof IFileEditorInput) {
                String baseClassName;
                IFile file = ((IFileEditorInput)this.editor.getEditorInput()).getFile();
                String inputName = file.getFullPath().removeFileExtension().lastSegment();
                className = baseClassName = JETEditorHelper.makeJavaClassName(inputName);
            }
            return className;
        }
        if (element instanceof TagLibraryReference) {
            return ((TagLibraryReference)element).getTagLibraryId();
        }
        return super.getText(element);
    }

    private String getShortText(String text) {
        if (text.length() > 25) {
            text = String.valueOf(text.substring(0, 25)) + "...";
        }
        return text;
    }

    private String getAttributesText(XMLElement element) {
        Map attributes = element.getAttributes();
        StringBuffer textBuffer = new StringBuffer(attributes.size() * 5);
        Iterator iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            String attrName = (String)iterator.next();
            String attrValue = (String)attributes.get(attrName);
            textBuffer.append(attrName).append("=\"").append(attrValue).append("\"");
            textBuffer.append(' ');
        }
        return textBuffer.toString();
    }

    private String getAttributesText(JETDirective directive) {
        Map attributes = directive.getAttributes();
        StringBuffer textBuffer = new StringBuffer(attributes.size() * 5);
        Iterator iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            String attrName = (String)iterator.next();
            String attrValue = (String)attributes.get(attrName);
            textBuffer.append(attrName).append("=\"").append(attrValue).append("\"");
            textBuffer.append(' ');
        }
        return textBuffer.toString();
    }
}

