/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.expressions;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.core.expressions.IEmbeddedExpression;
import org.eclipse.jet.internal.core.expressions.EmbeddedExpressionLanguageManager;
import org.eclipse.jet.internal.core.expressions.IEmbeddedExpressionScanner;
import org.eclipse.jet.internal.core.expressions.IEmbeddedLanguage;

public final class EmbeddedExpressionFactory {
    public static final String DEFAULT_EXPRESSION_LANGUAGE = "jet.xpath";
    public static final String EXPRESSION_OPEN = "${";
    public static final char EXPRESSION_CLOSE = '}';
    private final Map languages = EmbeddedExpressionLanguageManager.getInstance().getLanguages();
    private final String defaultExpressionLanguage;

    public static EmbeddedExpressionFactory newInstance() {
        return new EmbeddedExpressionFactory(DEFAULT_EXPRESSION_LANGUAGE);
    }

    private EmbeddedExpressionFactory(String defaultExpressionLanguage) {
        this.defaultExpressionLanguage = defaultExpressionLanguage;
    }

    public IEmbeddedExpression createExpression(String expression) {
        return this.createExpression(this.defaultExpressionLanguage, expression);
    }

    public IEmbeddedExpression createExpression(String language, String expression) {
        IEmbeddedLanguage lang = (IEmbeddedLanguage)this.languages.get(language);
        LinkedList<IEmbeddedExpression> expressions = new LinkedList<IEmbeddedExpression>();
        int i = 0;
        while (i < expression.length()) {
            int elStart = expression.indexOf(EXPRESSION_OPEN, i);
            if (elStart == -1) {
                expressions.add(new TextExpression(expression.substring(i)));
                break;
            }
            int elEnd = this.scanExpression(lang, expression, elStart);
            if (elStart > i) {
                expressions.add(new TextExpression(expression.substring(i, elStart)));
            }
            expressions.add(lang.getExpression(expression.substring(elStart + EXPRESSION_OPEN.length(), elEnd - 1)));
            i = elEnd;
        }
        return expressions.size() == 1 ? (IEmbeddedExpression)expressions.get(0) : new ConcatExpression(expressions);
    }

    private int scanExpression(IEmbeddedLanguage lang, String expression, int elStart) {
        IEmbeddedExpressionScanner scanner = lang.getScanner();
        int j = elStart + EXPRESSION_OPEN.length();
        while (j < expression.length()) {
            char ch = expression.charAt(j);
            scanner.setNextChar(ch);
            if ('}' == ch && !scanner.ignoreChar()) {
                return j + 1;
            }
            ++j;
        }
        throw new IllegalArgumentException("Unterminated embedded expresion");
    }

    private static final class ConcatExpression
    implements IEmbeddedExpression {
        private final List expressions;

        public ConcatExpression(List expressions) {
            this.expressions = expressions;
        }

        public String evalAsString(JET2Context context) {
            StringBuffer result = new StringBuffer();
            Iterator i = this.expressions.iterator();
            while (i.hasNext()) {
                IEmbeddedExpression expr = (IEmbeddedExpression)i.next();
                result.append(expr.evalAsString(context));
            }
            return result.toString();
        }

        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator i = this.expressions.iterator();
            while (i.hasNext()) {
                IEmbeddedExpression expr = (IEmbeddedExpression)i.next();
                result.append(expr.toString());
            }
            return result.toString();
        }

        public boolean isText() {
            return false;
        }
    }

    private static final class TextExpression
    implements IEmbeddedExpression {
        private final String text;

        public TextExpression(String text) {
            this.text = text;
        }

        public String evalAsString(JET2Context context) {
            return this.text;
        }

        public String toString() {
            return this.text;
        }

        public boolean isText() {
            return true;
        }
    }
}

