/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.ui.prefs;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jet.internal.ui.prefs.ExtensionListEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CompilePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IProject element;
    private StringFieldEditor packageFieldEditor;
    private ExtensionListEditor extFieldEditor;
    private StringFieldEditor srcFolderFieldEditor;
    private StringFieldEditor templatesFolderFieldEditor;
    private BooleanFieldEditor derivedJavaFieldEditor;
    private BooleanFieldEditor projectSpecificSettingsEditor = null;
    private RadioGroupFieldEditor jetVersionFieldEditor;
    private BooleanFieldEditor compileBaseTemplatesFieldEditor = null;
    private StringFieldEditor baseTransformationFieldEditor = null;
    private Composite javaGenerationGroup;
    private Composite v1OptionsGroup;
    private Composite v2OptionsGroup;
    private boolean v1OptionsEnabled;
    private BooleanFieldEditor useJava5FieldEditor;

    public CompilePreferencePage() {
        super(1);
    }

    protected void createFieldEditors() {
        boolean projectSettings;
        boolean bl = projectSettings = this.element != null;
        if (projectSettings) {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.element), "org.eclipse.jet"));
        } else {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.jet"));
        }
        if (projectSettings) {
            this.projectSpecificSettingsEditor = new BooleanFieldEditor("org.eclipse.jet.projectPrefs", Messages.CompilePreferencePage_EnableProjectSettings, this.getFieldEditorParent());
            this.addField((FieldEditor)this.projectSpecificSettingsEditor);
            Label horizontalLine = new Label(this.getFieldEditorParent(), 258);
            horizontalLine.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            horizontalLine.setFont(this.getFieldEditorParent().getFont());
        }
        this.jetVersionFieldEditor = new RadioGroupFieldEditor("org.eclipse.jet.jetSpecificationVersion", Messages.CompilePreferencePage_JETComformanceGroupLabel, 1, (String[][])new String[][]{{Messages.CompilePreferencePage_JET1_OPTION, String.valueOf(1)}, {Messages.CompilePreferencePage_JET2_Option, String.valueOf(2)}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)this.jetVersionFieldEditor);
        this.v1OptionsEnabled = this.getPreferenceStore().getInt("org.eclipse.jet.jetSpecificationVersion") == 1;
        this.javaGenerationGroup = this.createGroup(Messages.CompilePreferencePage_JavaGenerationGroupLabel);
        this.srcFolderFieldEditor = new StringFieldEditor("org.eclipse.jet.compiledTemplateSrcDir", Messages.CompilePreferencePage_SourceFolder, this.javaGenerationGroup);
        this.addField((FieldEditor)this.srcFolderFieldEditor);
        this.derivedJavaFieldEditor = new BooleanFieldEditor("org.eclipse.jet.setJavaDerived", Messages.CompilePreferencePage_DeriveJavaFiles, this.javaGenerationGroup);
        this.addField((FieldEditor)this.derivedJavaFieldEditor);
        this.useJava5FieldEditor = new BooleanFieldEditor("org.eclipse.jet.useJava5", Messages.CompilePreferencePage_use_java5, this.javaGenerationGroup);
        this.addField((FieldEditor)this.useJava5FieldEditor);
        this.v1OptionsGroup = this.createGroup(Messages.CompilePreferencePage_JET1OptionsGroupLabel);
        this.templatesFolderFieldEditor = new StringFieldEditor("org.eclipse.jet.v1TemplatesDir", Messages.CompilePreferencePage_TemplatesDirLabel, this.v1OptionsGroup);
        this.addField((FieldEditor)this.templatesFolderFieldEditor);
        if (projectSettings) {
            this.baseTransformationFieldEditor = new StringFieldEditor("org.eclipse.jet.v1BaseTransformationID", Messages.CompilePreferencePage_BaseLocationsLabel, StringFieldEditor.UNLIMITED, 0, this.v1OptionsGroup){

                protected boolean doCheckState() {
                    String trimmedValue = this.getStringValue().trim();
                    return trimmedValue.length() == 0 || CompilePreferencePage.this.isValidURIList(trimmedValue);
                }
            };
            this.baseTransformationFieldEditor.setErrorMessage(Messages.CompilePreferencePage_InvalidBaseLocations);
            this.addField((FieldEditor)this.baseTransformationFieldEditor);
            this.compileBaseTemplatesFieldEditor = new BooleanFieldEditor("org.eclipse.jet.v1CompileBaseTemplates", Messages.CompilePreferencePage_CompileBaseTemplates, this.v1OptionsGroup);
            this.addField((FieldEditor)this.compileBaseTemplatesFieldEditor);
        }
        this.v2OptionsGroup = this.createGroup(Messages.CompilePreferencePage_JET2_OPTIONS_GROUP_LABEL);
        this.extFieldEditor = new ExtensionListEditor("org.eclipse.jet.templateExt", Messages.CompilePreferencePage_FileExtensions, this.v2OptionsGroup);
        this.addField((FieldEditor)this.extFieldEditor);
        this.packageFieldEditor = new StringFieldEditor("org.eclipse.jet.compiledTemplatePackage", Messages.CompilePreferencePage_JavaPackage, this.v2OptionsGroup);
        this.addField((FieldEditor)this.packageFieldEditor);
    }

    private boolean isValidURIList(String uriList) {
        String[] uriStrings = uriList.split(",");
        boolean ok = true;
        int i = 0;
        while (i < uriStrings.length) {
            try {
                new URI(uriStrings[i]);
            }
            catch (URISyntaxException uRISyntaxException) {
                ok = false;
            }
            ++i;
        }
        return ok;
    }

    private Composite createGroup(String groupTitle) {
        Group group = new Group(this.getFieldEditorParent(), 0);
        group.setFont(this.getFieldEditorParent().getFont());
        group.setText(groupTitle);
        group.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.setGroupLayout((Composite)group, 2);
        return group;
    }

    private void setGroupLayout(Composite group, int numColumns) {
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
    }

    private void updateControlEnablement() {
        boolean projectSettings = this.projectSpecificSettingsEditor != null;
        boolean enabledGlobalSettings = !projectSettings || this.projectSpecificSettingsEditor.getBooleanValue();
        this.jetVersionFieldEditor.setEnabled(enabledGlobalSettings, this.getFieldEditorParent());
        this.srcFolderFieldEditor.setEnabled(enabledGlobalSettings, this.javaGenerationGroup);
        this.derivedJavaFieldEditor.setEnabled(enabledGlobalSettings, this.javaGenerationGroup);
        this.useJava5FieldEditor.setEnabled(enabledGlobalSettings, this.javaGenerationGroup);
        if (!enabledGlobalSettings) {
            this.srcFolderFieldEditor.loadDefault();
            this.derivedJavaFieldEditor.loadDefault();
            this.jetVersionFieldEditor.loadDefault();
            this.useJava5FieldEditor.loadDefault();
        }
        if (projectSettings) {
            boolean enableV1Options = this.v1OptionsEnabled && enabledGlobalSettings;
            this.baseTransformationFieldEditor.setEnabled(enableV1Options, this.v1OptionsGroup);
            this.compileBaseTemplatesFieldEditor.setEnabled(enableV1Options, this.v1OptionsGroup);
            this.templatesFolderFieldEditor.setEnabled(enableV1Options, this.v1OptionsGroup);
            if (!enableV1Options) {
                this.baseTransformationFieldEditor.loadDefault();
                this.compileBaseTemplatesFieldEditor.loadDefault();
                this.templatesFolderFieldEditor.loadDefault();
            }
        }
        if (projectSettings) {
            boolean enableV2Options = !this.v1OptionsEnabled && enabledGlobalSettings;
            this.extFieldEditor.setEnabled(enableV2Options, this.v2OptionsGroup);
            this.packageFieldEditor.setEnabled(enableV2Options, this.v2OptionsGroup);
            if (!enableV2Options) {
                this.extFieldEditor.loadDefault();
                this.packageFieldEditor.loadDefault();
            }
        }
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = (IProject)element;
    }

    protected void initialize() {
        super.initialize();
        if (this.projectSpecificSettingsEditor != null) {
            this.updateControlEnablement();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.projectSpecificSettingsEditor && "field_editor_value".equals(event.getProperty())) {
            this.updateControlEnablement();
        } else if (event.getSource() == this.jetVersionFieldEditor && "field_editor_value".equals(event.getProperty())) {
            this.v1OptionsEnabled = String.valueOf(1).equals(event.getNewValue());
            this.updateControlEnablement();
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.projectSpecificSettingsEditor != null) {
            this.updateControlEnablement();
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok) {
            try {
                if (this.element != null) {
                    this.element.build(15, null);
                } else {
                    ResourcesPlugin.getWorkspace().build(15, null);
                }
            }
            catch (CoreException coreException) {}
        }
        return ok;
    }
}

