/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.acceleo.ide.ui.AcceleoUIActivator;
import org.eclipse.acceleo.internal.ide.ui.editors.template.AcceleoEditor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.texteditor.MarkerAnnotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoHover
implements IAnnotationHover {
    protected AcceleoEditor editor;

    public AcceleoHover(AcceleoEditor editor) {
        this.editor = editor;
    }

    public String getHoverInfo(ISourceViewer sourceViewer, int lineNumber) {
        return this.getHoverText(sourceViewer.getAnnotationModel(), sourceViewer.getDocument(), lineNumber);
    }

    protected String getHoverText(IAnnotationModel model, IDocument document, int lineNumber) {
        StringBuffer text = null;
        for (Annotation annotation : this.findAnnotations(model, document, lineNumber)) {
            String msg = null;
            if (annotation instanceof MarkerAnnotation) {
                try {
                    msg = (String)((MarkerAnnotation)annotation).getMarker().getAttribute("message");
                }
                catch (CoreException e) {
                    AcceleoUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.acceleo.ide.ui", e.getMessage(), (Throwable)e));
                }
            }
            if (msg == null) continue;
            if (text == null) {
                text = new StringBuffer(msg);
                continue;
            }
            text.append('\n');
            text.append(msg);
        }
        if (text != null) {
            return text.toString();
        }
        return null;
    }

    private List<Annotation> findAnnotations(IAnnotationModel model, IDocument document, int lineNumber) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        IAnnotationModel annotationModel = model == null && this.editor != null ? this.editor.getDocumentProvider().getAnnotationModel((Object)this.editor.getEditorInput()) : model;
        if (annotationModel != null) {
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Annotation annotation = (Annotation)it.next();
                Position position = annotationModel.getPosition(annotation);
                try {
                    if (document == null || document.getLineOfOffset(position.offset) != lineNumber) continue;
                    annotations.add(annotation);
                }
                catch (BadLocationException badLocationException) {}
            }
        }
        return annotations;
    }
}

