/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.engine.generation;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import org.eclipse.acceleo.engine.AcceleoEngineMessages;
import org.eclipse.acceleo.engine.AcceleoEvaluationCancelledException;
import org.eclipse.acceleo.engine.AcceleoEvaluationException;
import org.eclipse.acceleo.engine.event.AcceleoTextGenerationEvent;
import org.eclipse.acceleo.engine.event.IAcceleoTextGenerationListener;
import org.eclipse.acceleo.engine.generation.AbstractAcceleoEnvironmentFactory;
import org.eclipse.acceleo.engine.generation.IAcceleoEngine;
import org.eclipse.acceleo.engine.generation.strategy.IAcceleoGenerationStrategy;
import org.eclipse.acceleo.engine.internal.environment.AcceleoEnvironmentFactory;
import org.eclipse.acceleo.engine.internal.environment.AcceleoPropertiesLookup;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.OCLExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AcceleoEngine
implements IAcceleoEngine {
    private static final String SELF_CONTEXT_VARIABLE_NAME = "context$0";
    private static final String SELF_VARIABLE_NAME = "self";
    protected final List<IAcceleoTextGenerationListener> listeners = new ArrayList<IAcceleoTextGenerationListener>();
    protected AcceleoPropertiesLookup propertiesLookup = new AcceleoPropertiesLookup();
    protected boolean notifyOnGenerationEnd;
    private OCL ocl;

    @Override
    public void addListener(IAcceleoTextGenerationListener listener) {
        this.listeners.add(listener);
        if (listener.listensToGenerationEnd()) {
            this.notifyOnGenerationEnd = true;
        }
    }

    @Override
    public void addProperties(String propertiesHolder) throws MissingResourceException {
        this.propertiesLookup.addProperties(propertiesHolder);
    }

    @Override
    public void addProperties(Map<String, String> customProps) {
        this.propertiesLookup.addProperties(customProps);
    }

    @Override
    public Map<String, String> evaluate(Template template, List<? extends Object> arguments, File generationRoot, IAcceleoGenerationStrategy strategy, Monitor monitor) {
        if (template == null || arguments == null) {
            throw new NullPointerException(AcceleoEngineMessages.getString("AcceleoEngine.NullArguments"));
        }
        if (template.getVisibility() != VisibilityKind.PUBLIC) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalTemplateInvocation"));
        }
        if (template.getParameter().size() != arguments.size()) {
            throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.IllegalArguments"));
        }
        AbstractAcceleoEnvironmentFactory factory = this.createEnvironmentFactory(generationRoot, (Module)template.eContainer(), strategy, monitor);
        this.ocl = OCL.newInstance((EnvironmentFactory)factory);
        try {
            this.doEvaluate(template, arguments);
        }
        catch (AcceleoEvaluationCancelledException acceleoEvaluationCancelledException) {}
        this.hookGenerationEnd(factory);
        Map<String, String> result = Collections.emptyMap();
        if (strategy.willReturnPreview()) {
            result = factory.getEvaluationPreview();
        }
        factory.dispose();
        return result;
    }

    @Override
    public void removeListener(IAcceleoTextGenerationListener listener) {
        this.listeners.remove(listener);
    }

    protected AbstractAcceleoEnvironmentFactory createEnvironmentFactory(File generationRoot, Module rootModule, IAcceleoGenerationStrategy strategy, Monitor monitor) {
        ArrayList<IAcceleoTextGenerationListener> listenersCopy = new ArrayList<IAcceleoTextGenerationListener>(this.listeners);
        return new AcceleoEnvironmentFactory(generationRoot, rootModule, listenersCopy, this.propertiesLookup, strategy, monitor);
    }

    protected void hookGenerationEnd(AbstractAcceleoEnvironmentFactory factory) {
        factory.hookGenerationEnd();
        this.fireGenerationEnd();
    }

    protected void fireGenerationEnd() {
        if (!this.notifyOnGenerationEnd) {
            return;
        }
        for (IAcceleoTextGenerationListener listener : this.listeners) {
            if (!listener.listensToGenerationEnd()) continue;
            listener.generationEnd(new AcceleoTextGenerationEvent());
        }
    }

    /*
     * Unable to fully structure code
     */
    private void doEvaluate(Template template, List<? extends Object> arguments) {
        guardValue = true;
        if (template.getGuard() != null) {
            guard = this.ocl.createQuery((OCLExpression)template.getGuard());
            i = 0;
            while (i < template.getParameter().size()) {
                param = (Variable)template.getParameter().get(i);
                value = arguments.get(i);
                if (!((EClassifier)param.getType()).isInstance(value)) {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.ArgumentMismatch", new Object[]{template.getName()}));
                }
                guard.getEvaluationEnvironment().add(param.getName(), value);
                if (i == 0) {
                    guard.getEvaluationEnvironment().add("self", value);
                    guard.getEvaluationEnvironment().add("context$0", value);
                }
                ++i;
            }
            guardValue = (Boolean)guard.evaluate();
            for (Variable var : template.getParameter()) {
                guard.getEvaluationEnvironment().remove(var.getName());
            }
            if (template.getParameter().size() > 0) {
                guard.getEvaluationEnvironment().remove("self");
                guard.getEvaluationEnvironment().remove("context$0");
            }
        }
        if (guardValue) {
            query = this.ocl.createQuery((OCLExpression)template);
            i = 0;
            while (i < template.getParameter().size()) {
                param = (Variable)template.getParameter().get(i);
                value = arguments.get(i);
                if (!((EClassifier)param.getType()).isInstance(value)) {
                    throw new AcceleoEvaluationException(AcceleoEngineMessages.getString("AcceleoEngine.ArgumentMismatch", new Object[]{template.getName()}));
                }
                query.getEvaluationEnvironment().add(param.getName(), value);
                if (i == 0) {
                    query.getEvaluationEnvironment().add("self", value);
                    query.getEvaluationEnvironment().add("context$0", value);
                }
                ++i;
            }
            try {
                query.evaluate();
            }
            finally {
                ** for (var : template.getParameter())
            }
lbl-1000:
            // 1 sources

            {
                query.getEvaluationEnvironment().remove(var.getName());
                continue;
            }
lbl49:
            // 1 sources

            if (template.getParameter().size() > 0) {
                query.getEvaluationEnvironment().remove("self");
                query.getEvaluationEnvironment().remove("context$0");
            }
        }
    }
}

