/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.inactive.StreamDecoder;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.util.ResourceManagerImpl;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitResolver;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.BundleUnitResolver;

public class BundleResourceManager
extends ResourceManagerImpl {
    private final URL[] paths;

    public BundleResourceManager(URL ... paths) {
        assert (paths != null && paths.length > 0);
        this.paths = new URL[paths.length];
        int i = 0;
        while (i < paths.length) {
            this.paths[i] = BundleResourceManager.fixTrailingSlash(paths[i]);
            ++i;
        }
    }

    private static URL fixTrailingSlash(URL u) {
        try {
            if (u.getPath() != null && !u.getPath().endsWith("/")) {
                return new URL(u, String.valueOf(u.getPath()) + '/');
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return u;
    }

    protected boolean shouldCache() {
        return true;
    }

    protected void handleParserException(ParserException ex) {
        throw new EvaluationException(ex.toString());
    }

    private Reader createReader(String urlPath, URL baseUrl) throws MalformedURLException, IOException {
        URL u = new URL(baseUrl, urlPath);
        InputStream is = u.openStream();
        return new StreamDecoder(is, StreamDecoder.LEGACY_ENCODING).getReader();
    }

    protected Reader[] resolveMultiple(String fullyQualifiedName, String extension) throws IOException {
        String urlPath = String.valueOf(fullyQualifiedName.replaceAll("::", "/")) + '.' + extension;
        ArrayList<Reader> result = new ArrayList<Reader>(this.paths.length);
        int i = 0;
        while (i < this.paths.length) {
            try {
                result.add(this.createReader(urlPath, this.paths[i]));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception ex) {
                Activator.logError(ex);
            }
            ++i;
        }
        if (result.isEmpty()) {
            throw new FileNotFoundException(fullyQualifiedName);
        }
        return result.toArray(new Reader[result.size()]);
    }

    protected String resolveCFileFullPath(String fullyQualifiedName, String extension) {
        String urlPath = String.valueOf(fullyQualifiedName.replaceAll("::", "/")) + '.' + extension;
        if (this.paths.length > 0) {
            try {
                return new URL(this.paths[0], urlPath).toString();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return String.valueOf(fullyQualifiedName) + "." + extension;
    }

    protected UnitResolver getQVTUnitResolver() {
        return BundleUnitResolver.createResolver(Arrays.asList(this.paths), (boolean)true);
    }
}

