/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public class LabelProvider
implements EValidator.SubstitutionLabelProvider {
    public static final EValidator.SubstitutionLabelProvider INSTANCE = new LabelProvider();
    private final AdapterFactory ecoreLabelProviderFactory = new EcoreItemProviderAdapterFactory();

    private LabelProvider() {
    }

    public String getFeatureLabel(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getName();
    }

    public String getObjectLabel(EObject eObject) {
        if (eObject == null) {
            return String.valueOf(eObject);
        }
        if (eObject instanceof EStructuralFeature) {
            return this.getFeatureLabel((EStructuralFeature)eObject);
        }
        if (eObject instanceof ENamedElement) {
            return LabelProvider.qualifiedName((ENamedElement)eObject, new StringBuffer()).toString();
        }
        String displayName = this.toDisplayName(eObject);
        return displayName != null ? displayName : EcoreUtil.getIdentification((EObject)eObject);
    }

    public String getValueLabel(EDataType eDataType, Object value) {
        return EcoreUtil.convertToString((EDataType)eDataType, (Object)value);
    }

    private static StringBuffer qualifiedName(ENamedElement namedElement, StringBuffer buf) {
        EObject container;
        if (buf == null) {
            buf = new StringBuffer();
        }
        if ((container = namedElement.eContainer()) instanceof ENamedElement) {
            ENamedElement owner = (ENamedElement)container;
            LabelProvider.qualifiedName(owner, buf);
            buf.append("::");
        }
        buf.append(namedElement.getName());
        return buf;
    }

    private String toDisplayName(EObject eObject) {
        IItemLabelProvider labelAdapter = (IItemLabelProvider)EcoreUtil.getRegisteredAdapter((EObject)EcorePackage.eINSTANCE.getEAnnotation(), IItemLabelProvider.class);
        if (labelAdapter == null) {
            labelAdapter = (IItemLabelProvider)this.ecoreLabelProviderFactory.adapt((Notifier)eObject, IItemLabelProvider.class);
        }
        String label = null;
        try {
            label = labelAdapter.getText((Object)eObject);
        }
        catch (RuntimeException runtimeException) {
            label = EcoreUtil.getIdentification((EObject)eObject);
        }
        return label;
    }

    public static final String getTextLabel(Object obj) {
        return obj instanceof EObject ? INSTANCE.getObjectLabel((EObject)obj) : String.valueOf(obj);
    }
}

